# -*- coding: UTF-8 -*-
import traceback
import re
import util

'''
判断是否存在高密框，若存在高密框，则返回高密框的ID
'''
def isContainSAS4U_75(cli):
    cliRet = cli.execCmd("show enclosure")
    cliRetList = util.formatList(cliRet)
    encId = ""
    result = False
    for rec in cliRetList:
        if rec['Type'].find(' 75 Slot ') != -1:
            encId = rec['ID']
            result = True
            break
    
    return [result, encId]  
    
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check Logic version
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show version all")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[47] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[47] execute command result:\n" + cliRet)

        #Check controller logic version
        versionCtrTrace = []
        list1 = cliRet.splitlines()
        con_flag = False
        for field in list1:
            field = field.replace(" ", "")
            if re.search("Controller:", field, re.IGNORECASE):
                con_flag = True
                
            if not con_flag:
                continue
            
            if re.search("Expansion Module:", field, re.IGNORECASE) or re.search("BBU:", field, re.IGNORECASE):
                break
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[47] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[47]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
     
            if field.startswith("LogicVersion:"):
                versionCtrTrace.append(field.replace("LogicVersion:", ""))
         
        #大小排序   
        logicCtrlVersionSort = sorted(versionCtrTrace) 
        
        #判断控制器Logic版本是否一致
        if 0 != logicCtrlVersionSort:
            if (logicCtrlVersionSort[0]!=logicCtrlVersionSort[-1]):
                flag = False 
                versionCtrlDisplay = ""
                for version in versionCtrTrace:
                    if "zh" == lang:
                        versionCtrlDisplay +=version+u"，"
                    else:
                        versionCtrlDisplay +=version+u","
                versionCtrlDisplay = versionCtrlDisplay[:-1]
                
                if "zh" == lang:
                    errMsg += u"\n控制器Logic版本不一致：" + versionCtrlDisplay
                else:
                    errMsg += "\nThe logic version of controller is different: " + versionCtrlDisplay
        
        #Check enclosure logic version
        #获取是否存在高密框
        result = isContainSAS4U_75(cli)
        isCon75 = result[0]
        encId = result[1]
        
        list2 = cliRet.splitlines()
        versionEncTrace = []
        version4U_SAS_75_EncTrace = []
        startFalg = False
        
        for field in list2:
            if field.startswith("Expansion"):
                startFalg = True
                
            if not startFalg:
                continue
            
            if field.startswith("BBU:") or field.startswith("Controller:"):
                break

            if -1 != field.find("----") or -1 != field.find(" ID ") or -1 != field.find("Expansion"):
                continue
            
            list = field.split()
            if(len(list) >= 2):
                if True == isCon75 and list[0].strip().startswith(encId):
                    version4U_SAS_75_EncTrace.append(list[1])
                else:
                    versionEncTrace.append(list[1])
        
        
        #判断高密框级联板Logic版本是否一致
        if True == isCon75:
            sesLogicVersionSort = sorted(version4U_SAS_75_EncTrace)
            if 0 != len(sesLogicVersionSort):
                if (sesLogicVersionSort[0] != sesLogicVersionSort[-1]):
                    flag = False 
                    versionEncDisplay = ""
                    for version in sesLogicVersionSort:
                        if versionEncDisplay.find(version) == -1:
                            if "zh" == lang:
                                versionEncDisplay +=version + u"，"
                            else:
                                versionEncDisplay +=version + u","
                    versionEncDisplay = versionEncDisplay[:-1]
                    
                    if "zh" == lang:
                        errMsg += u"\n高密框的级联模块Logic版本不一致：" + versionEncDisplay
                    else:
                        errMsg += "\nThe logic version of expansion modules on high-density disk enclosures are inconsistent: " + versionEncDisplay
        
        sesLogicVersionSort = sorted(versionEncTrace)
        #判断级联框Logic版本是否一致
        if 0 != len(sesLogicVersionSort):
            if (sesLogicVersionSort[0] != sesLogicVersionSort[-1]):
                flag = False 
                versionEncDisplay = ""
                for version in versionEncTrace:
                    if versionEncDisplay.find(version) == -1:
                        if "zh" == lang:
                            versionEncDisplay +=version + u"，"
                        else:
                            versionEncDisplay +=version + u","
                versionEncDisplay = versionEncDisplay[:-1]
                
                if "zh" == lang:
                    errMsg += u"\n硬盘框的级联模块Logic版本不一致：" + versionEncDisplay
                else:
                    errMsg += "\nThe logic version of expansion modules on disk enclosures are inconsistent: " + versionEncDisplay
                       
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[47] catch except of check logic version.")
        PY_LOGGER.error("Sequence[47] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[47] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[47] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
