# -*- coding: UTF-8 -*-
import traceback
import common
       
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showbbu")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        i = 0
        inDeveloper = False
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        retInfo= common.change2Developer(cli, py_java_env)
        cliRet = retInfo[1]
        errMsg = retInfo[2]
        if not retInfo[0]:
            common.anyModel2Cli(cli)
            PY_LOGGER.info("Sequence[5] inspect not pass. (can't enter to developer model!)")
            return(False, cliRet, errMsg)  
        inDeveloper = True
        #执行的CLI命令
        cmd = "show bbu life"
        PY_LOGGER.info("Sequence[5] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[5] inspect not pass. (system abnormal!)")
            common.anyModel2Cli(cli)
            inDeveloper = False
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        #增加BBU不在位判断
        if common.isExecSuccess(cliRet) or len(list) <= 3:
            flag = False
            if "zh" == lang:
                errMsg += u"\nBBU不在位"
            else:
                errMsg += "\nThe BBU cannot be detected."
            return (flag, cliRet, errMsg)
        
        bbuId=""
        for field in list:         
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if len(list2) != 2:
                    continue
                
                if "--" == list2[1]:
                    flag = False
                    bbuId = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]生命剩余时间未能查到"
                    else:
                        errMsg += "\nThe remain life of BBU[" + bbuId + "] can't be queried"
                    continue
                
                if int(list2[1]) < 60:
                    flag = False
                    bbuId = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]生命剩余时间小于60天"
                    else:
                        errMsg += "\nThe remain life of BBU[" + bbuId + "] less than 60 days"

        if not flag:
             PY_LOGGER.info("Sequence[5] inspect not pass.")
     
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[5] catch except of check bbu life.")
        PY_LOGGER.error("Sequence[5] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[5] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[5] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
