# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check POOL status
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        
        #执行的CLI命令
        cmd = "show storage_pool general"
        PY_LOGGER.info("Sequence[62] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[62] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet)
        
        list = cliRet.splitlines()
        i = 0
        poolId=""
        for field in list:
            i = i+1
            if i > 4:
                list1 = field.split()
                if common.isEndLine(list1[0]):
                    break

                if ("Fault" == list1[3] or "fault" == list1[3]):
                    flag = False
                    if len(list1)>0:
                        poolId = list1[0]
                        if 'zh' == lang:
                            errMsg += u"\nPool ID[" + poolId + u"]状态检查异常"
                        else:
                            errMsg += "\nThe status of pool [" + poolId + "] is abnormal" 
                    continue
                
                if ("Offline" == list1[4] or "offline" == list1[4]):
                    flag = False
                    if len(list1)>0:
                        poolId = list1[0]
                        if "zh" == lang:
                            errMsg += u"\nPool ID[" + poolId + u"]状态检查异常"
                        else:
                            errMsg += "\nThe status of pool [" + poolId + "] is abnormal"
                    continue
                            
                if ("Degraded" == list1[3] and "Reconstruction" != list1[4]):
                    flag = False
                    if len(list1)>0:
                        poolId = list1[0]
                        if "zh" == lang:
                            errMsg += u"\nPool ID[" + poolId + u"]状态检查异常"
                        else:
                            errMsg += "\nThe status of pool [" + poolId + "] is abnormal"
        if not flag:
             PY_LOGGER.info("Sequence[62] inspect not pass.")
                      
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[62] catch except of check POOL status.")
        PY_LOGGER.error("Sequence[62] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[62] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[62] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
