# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check Tier status
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet1 = ""
        cliRet = ""
    	errMsg = ""

        #执行的CLI命令
        cmd = "show storage_pool general"
        PY_LOGGER.info("Sequence[63] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet1 = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[63] inspect not pass. (system abnormal!)")
            return (False, cliRet1, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet1):
            return (True, cliRet1)

        cliRet = ""
        list = cliRet1.splitlines()
        i = 0
        poolId=""
        for field1 in list:        
            i = i+1
            if i > 4:
                list1 = field1.split()

                if len(list1)<1:
                    continue
                
                #Find to the end
                if common.isEndLine(list1[0]):
                    break

                if("ID" == list1[0]) or ("--" == list1[0]):
                    continue

                #Find right lines and show each POOL_ID
                if(len(list1)>=6):
                    cliRet2 = ""
                    PY_LOGGER.info("Sequence[63] show storage_pool tier ID is:"+ str(list1[0]))
                    #执行的CLI命令
                    cmd = "show storage_pool tier pool_id=" + str(list1[0])
                    #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
                    checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)            
                    cliRet2 = checkRet[1]
                    cliRet = cliRet + cliRet2
                    errMsg += checkRet[2]
                    if checkRet[0]:
                        PY_LOGGER.info("Sequence[63] inspect not pass. (system abnormal!)")
                        return (False, cliRet, errMsg)

                    listTier = cliRet2.splitlines()
                    #HealthStatus equal to normal is OK
                    tierName = ""
                    for field2 in listTier:
                        field2 = field2.replace(" ", "")
                        if field2.startswith("Name:"):
                            tierName = field2.replace("Name:", "")
                            continue
                        if field2.startswith("HealthStatus:"):
                            if field2.replace("HealthStatus:", "") != "Normal":
                                flag = False
                                poolId = list1[0]
                                if "zh" == lang:
                                    errMsg += u"\nPool[" + poolId + u"]名称为["+tierName+u"]的Tier健康状态检查异常"
                                else:
                                    errMsg += "\nThe health status of tier named ["+tierName+"] in pool [" + poolId + "] is abnormal"
                                    
        if not flag:
             PY_LOGGER.info("Sequence[63] inspect not pass.")
             
        return (flag, cliRet1 + cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[63] catch except of check Tier status.")
        PY_LOGGER.error("Sequence[63] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[63] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[63] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1 + cliRet, errMsg)
