# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check hotspare spaces
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = ""
        
        cmd = "show disk_domain general"
        PY_LOGGER.info("Sequence[64] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[64] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet)
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            list1 = field.split()
            if len(list1) < 8:
                continue
            if field.find("----") !=-1 or field.find("ID") !=-1:
                continue
            if list1[7] != "0.000B":
                PY_LOGGER.info(" Used Hot Spare Capacity:" + list1[7])
                flag = False
                
                if list1[7] =="--" or list1[7] =="" or list1[7] ==" ":
                    if "zh" == lang:
                        errMsg += u"\nPool(" + list1[0] + u")的Hotspare Used Capacity信息未找到"
                    else:
                        errMsg += "\nFailed to find The Hotspare Used Capacity in pool(" + list1[0] + ")"
                    continue
                
                if "zh" == lang:
                    errMsg += u"\nPool(" + list1[0] + u")的Hotspare Used Capacity大于0"
                else:
                    errMsg += "\nThe Hotspare Used Capacity in pool(" + list1[0] + ") is more than 0"
                
        if not flag:
             PY_LOGGER.info("Sequence[64] inspect not pass.")
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[64] catch except of check hotspare spaces.")
        PY_LOGGER.error("Sequence[64] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[64] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[64] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1 + cliRet, errMsg)
