# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check PreCopy switch
    Input              : cli--Telnet access proxy 
					 e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
        
        #执行的CLI命令
        cmd = "show disk precopy"
        PY_LOGGER.info("Sequence[66] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[66] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)

        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet)
	
        list = cliRet.splitlines()
        i = 0
        for field in list:           
            i = i+1
            if i > 2:
                field = field.replace(" ", "")
                if field.startswith("PreCopyEnabled:"):
                    if (field.replace("PreCopyEnabled:", "") == "Yes") or (field.replace("PreCopyEnabled:", "") == "No"):
                        flag = True
                        return(flag, cliRet)
                        
        PY_LOGGER.info("\nSequence[62] inspect not pass.")
        if "zh" == lang:
            errMsg = u"\n硬盘预拷贝状态检查异常"
        else:
            errMsg = "\nThe precopy of disk is abnormal"
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[66] catch except of check PreCopy switch.")
        PY_LOGGER.error("Sequence[66] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[66] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[66] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
	if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
