# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN controller
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show lun lun_id=LUN_ID")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet2=""
        cliRet1=""
        controllerList = []
        cmd0 = "show controller general"
        
        checkRet0 = common.isCliExecRetInBlackList(cli,cmd0,lang,True)
        cliRet0 = checkRet0[1]
        errMsg = checkRet0[2]
        if checkRet0[0]:
            PY_LOGGER.info("Sequence[69] inspect not pass. (system abnormal!)")
            return (False, cliRet0, errMsg)
        
        list0 = cliRet0.splitlines()
        for field in list0:
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                if ctrlId != "" and ctrlId != " " and (ctrlId.find("A")!=-1 or ctrlId.find("B")!=-1):
                    controllerList.append(ctrlId)
                continue
        #查看两个控制器是否合法（--）
        cmdinvalidController="show lun general |filterRow column=Owner\sController predict=equal_to value=-- logicOp=or column=Work\sController predict=equal_to value=--"
            
        checkRetinvalidCon =  common.isCliExecRetInBlackList(cli,cmdinvalidController,lang,True)
        cliRetinvalidCon = checkRetinvalidCon[1]
        errMsg = checkRetinvalidCon[2]
        if checkRetinvalidCon[0]:
            PY_LOGGER.info("Sequence[69] inspect not pass. (system abnormal!)")
            return (False, cliRetinvalidCon, errMsg)
        
        cliRet2 +=cliRetinvalidCon
        listinval = cliRetinvalidCon.splitlines()
        i = 0
        for field in listinval:
            i = i + 1
            
            if field.find("Command executed successfully") != -1:
                break
            
            if i > 3:
                flag = False
                
                if field.find("---") != -1 or field.find("ID") != -1:
                    continue
                list2 = field.split()
                if len(list2) < 3:
                    continue
                lunID = list2[0]
                if "zh" == lang:
                    errMsg += u"\nLun["+lunID+u"]的工作控制器或归属控制器不合法"
                else:
                    errMsg += "\nThe owner controller or work controller of lun["+lunID+"] is invalid"
        
            
        for controller in controllerList:
            cmd = "show lun general |filterRow column=Work\sController predict=equal_to value="+controller+" logicOp=and column=Owner\sController predict=not predict2=equal_to value="+controller
            
            #If more than 3 lines its means have not equal value
            checkRetTmp =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet1 = checkRetTmp[1]
            errMsg += checkRetTmp[2]
            if checkRetTmp[0]:
                PY_LOGGER.info("Sequence[69] inspect not pass. (system abnormal!)")
                return (False, cliRet1, errMsg)
            
            cliRet2 +=cliRet1
            list = cliRet1.splitlines()
            i = 0
            for field in list:
                i = i + 1
                
                if field.find("Command executed successfully") != -1:
                    break
                
                if i > 3:
                    flag = False
                    
                    if field.find("---") != -1 or field.find("ID") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nLun["+lunID+u"]的工作控制器和归属控制器不一致"
                    else:
                        errMsg += "\nThe owner controller of lun["+lunID+"] is not consistent with it's work controller"
                        
        if not flag:
            PY_LOGGER.info("Sequence[69] inspect not pass.")
        
        return (flag, cliRet2, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[69] catch except of check LUN controller.")
        PY_LOGGER.error("Sequence[69] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[69] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[69] catch except of trace back:" + str(traceback.print_exc()))
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet2, errMsg)
