# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showdisk -physic")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        
        #执行的CLI命令
        cmd = "show disk general |filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        PY_LOGGER.info("Sequence[7] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[7] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet)
        
        list = cliRet.splitlines()
        i = 0
        
        diskID = ""
        for field in list:       
            i = i + 1
            
            #If more than 3 lines its means have fault or offline disk
            if i > 3:
                flag = False
				
                if -1 != field.find("----"):
                    continue
					
                list2 = field.split()
                if len(list2) < 4:
                    continue
                diskID = list2[0]
                if "zh" == lang:
                    errMsg += u"\n硬盘[" + diskID + u"]状态存在异常"
                else:
                    errMsg += "\nThe status of disk [" + diskID + "] is abnormal"
                    
        if not flag:
             PY_LOGGER.info("Sequence[7] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[7] catch except of check disk status.")
        PY_LOGGER.error("Sequence[7] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[7] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[7] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
