# -*- coding: UTF-8 -*-
import traceback
import common
            
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showdisk -logic")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        inDeveloper = False
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        retInfo= common.change2Developer(cli, py_java_env)
        cliRet = retInfo[1]
        errMsg = retInfo[2]
        if not retInfo[0]:
            common.anyModel2Cli(cli)
            PY_LOGGER.info("Sequence[8] inspect not pass. (can't enter to developer model!)")
            return(False, cliRet, errMsg)  
        inDeveloper = True
            
        #执行的CLI命令
        cmd = "show disk write_cache"
        PY_LOGGER.info("Sequence[8] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[8] inspect not pass. (system abnormal!)")
            common.anyModel2Cli(cli)
            inDeveloper = False
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                if inDeveloper == True:
                    cli.execCmd("exit")
                    inDeveloper = False
                flag = False
                PY_LOGGER.info("Sequence[8] not in admin mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
            list2 = field.split()
            if field.find("Enabled") != -1:
                if list2[2] != "Yes" and list2[2] != "No":
                    flag = False
                    PY_LOGGER.info("Sequence[8] inspect not pass.")
                    if inDeveloper == True:
                        common.anyModel2Cli(cli)
                        inDeveloper = False
                    if "zh" == lang:
                        errMsg = u"\n硬盘write_cache属性异常("+list2[2]+u")"
                    else:
                        errMsg = "\nThe write_cache property of disk is abnormal("+list2[2]+")"
                    return (flag, cliRet, errMsg)

        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        return (flag, cliRet)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[8] catch except of check disk write_cache.")
        PY_LOGGER.error("Sequence[8] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[8] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[8] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
