# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/08/06
    Function name      : execute(cliConnection)
    Function describe  : check consistency stauts
    Input              : cli--Telnet acess proxy 
                         e.g: cliRet = cli.execCmd("show consistency_group general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #执行的CLI命令
        cmd = "show consistency_group general"
        PY_LOGGER.info("Sequence[86] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetJudgeWithDoubleList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CLI_RET_FAULT == checkRet[0]:
            PY_LOGGER.info("Sequence[86] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)        
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        elif common.CLI_RET_SUCCESS == checkRet[0]:
            return (True, cliRet, "")
        
        list = cliRet.splitlines()
        i = 0
        for field in list:                
            i = i+1
            if i > 4:
                list1 = field.split()
                if common.isEndLine(list1[0]):
                    break
                    
                if (len(list1) >= 7) and ("Normal" != list1[2]):
                    flag = False
                    PY_LOGGER.info("Sequence[86] inspect consistency stauts:"+list1[2]+" ID: "+list1[0])
                    if "zh" == lang:
                        errMsg += u"\n一致性组[" + list1[0] + u"]状态检查异常"
                    else:
                        errMsg += "\nThe status of consistency group ["+list1[0]+"] is abnormal" 

        if not flag:
             PY_LOGGER.info("Sequence[86] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[86] catch except of check consistency stauts.")
        PY_LOGGER.error("Sequence[86] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[86] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[86] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
