﻿# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2014/03/28
    Function name      : execute(cliConnection)
    Function describe  : check lun_migration general status
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show lun_migration general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #执行的CLI命令
        cmd = "show lun_migration general"
        PY_LOGGER.info("Sequence[88] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetJudgeWithDoubleList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CLI_RET_FAULT == checkRet[0]:
            PY_LOGGER.info("Sequence[88] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)        
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        
        
        list = cliRet.splitlines()
        i = 0
        for field in list:    
            i = i+1
            if i > 4:
                list1 = field.split()
                if common.isEndLine(list1[0]):
                    break
                if (len(list1)>= 7) and ("Fault" == list1[4]):                    
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nLUN迁移[源LUN ID:" + list1[0] + u"]状态检查异常"
                    else:
                        errMsg += "\nThe status of lun migration [source lun id:"+list1[0]+"] is abnormal"  
                        
        if not flag:
             PY_LOGGER.debug ("Sequence[88] inspect not pass.")
                         
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[88] catch except of check lun_migration general status.")
        PY_LOGGER.error("Sequence[88] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[88] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[88] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
