# -*- coding: UTF-8 -*-
import traceback
import common
            
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showdisk -logic")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        inDeveloper = False
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        retInfo= common.change2Developer(cli, py_java_env)
        cliRet = retInfo[1]
        errMsg = retInfo[2]
        if not retInfo[0]:
            common.anyModel2Cli(cli)
            PY_LOGGER.info("Sequence[9] inspect not pass. (can't enter to developer model!)")
            return(False, cliRet, errMsg)  
        inDeveloper = True
        cliRet = str(cli.execCmd("show disk ncq"))
        PY_LOGGER.info("\nSequence[9] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                if inDeveloper == True:
                    cli.execCmd("exit")
                    inDeveloper = False
                flag = False
                PY_LOGGER.info("Sequence[9] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if len(list2) < 2:
                    continue
                if list2[1] != "Yes" and list2[1] != "No":
                    flag = False
                    if inDeveloper == True:
                        cli.execCmd("exit")
                        inDeveloper = False
                    if "zh" == lang:
                        errMsg = u"\n硬盘ncq属性异常("+list2[1]+u")"
                    else:
                        errMsg = "\nThe ncq property of disk is abnormal("+list2[1]+")"
                    return (flag, cliRet, errMsg)
                
        if inDeveloper == True:
            cli.execCmd("exit")
            inDeveloper = False
        return (flag, cliRet)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[9] catch except of check disk NCQ status.")
        PY_LOGGER.error("Sequence[9] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[9] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[9] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            cli.execCmd("exit")
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
