# -*- coding: UTF-8 -*-
import common


LANG = common.getLang(py_java_env)

def execute(cli):
    '''
    @summary: 检查当前设备型号和版本号，且是否包含4K盘
    '''
    
    cliRet = ""
    errMsg = ""
    flag = True
    checkRet = True
    all4KDiskList = []
    
    #定义问题型号和版本号
    bugProduct_18000 = ("HVS85T", "HVS88T", "18500", "18800", "18800F")
    bugVersion_18000 = ["V100R001C10"]
    
    #查询产品型号
    result, cliRet, productModel = common.getProductModel(cli, LANG)
    if not result:
        if "zh" == LANG:
            errMsg = u"\n获取产品型号失败。"
        else:
            errMsg = "\nFailed to query the product model."
        return (False, cliRet, errMsg)
    
    if productModel not in bugProduct_18000:
        return ("NOSUPPORT", cliRet, "")
    
    #获取版本号和补丁版本号，并判断是否为风险版本
    resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += resultList[1]
    if resultList[0] != True:
        return (resultList[0], cliRet, resultList[2])
    
    result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        return (False, cliRet, errMsg)
     
    #检查产品版本是否有风险
    if currentVersion not in bugVersion_18000:
         return (True, cliRet, errMsg)
    
    #查询是否存在4K盘
    result, cmdRet, errInfo, diskSectorSizeDictList = common.getDiskSectorSize(cli, LANG)
    cliRet += cmdRet
    errMsg += errInfo
    if not result:
        return (False, cliRet, errMsg)
    
    result, is4KDiskIdListSectorSize, errInfo = common.is4KDiskWithSectorSize(diskSectorSizeDictList,LANG)
    errMsg += errInfo
    all4KDiskList += is4KDiskIdListSectorSize
    if result:
        checkRet = False
    
    #检查是否有大于1TB的SAS盘，或大于5TB的NL SAS盘
    result, cmdRet, errInfo, is4kDiskListCap = common.get4kDiskInfo(cli, LANG)
    cliRet += cmdRet
    errMsg += errInfo
    all4KDiskList += is4kDiskListCap
    if not result:
        checkRet = False
        
    #根据总的4K盘列表是否为空判断是否存在问题
    if all4KDiskList:
        checkRet = False
        
    return (checkRet, cliRet, errMsg)
    
    