# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    硬盘的固件版本检查

    1 如果硬盘的检查标准满足以下条件之一，则检查结果为不通过。
     1） Model为ST2000NM0023、ST3000NM0023、ST4000NM0023其中之一，且Firmware Version为0003,0004,0005,0006,0007其中之一；
     2） Model为ST1000NM0033、ST2000NM0033、ST3000NM0033、ST4000NM0033其中之一，且Firmware Version为SN01,SN02,SN03,SN04,SN05,SN06,SNC6,SNA5其中之一；
    2 其他情况检查结果为通过。"""
    
    flag = True
    bugDiskIDList = []
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""
    #存在问题的固件Model与对应的FW
    bugFWVersionMap = {
                        "ST2000NM0023":("0003","0004","0005","0006","0007"),
                        "ST3000NM0023":("0003","0004","0005","0006","0007"),
                        "ST4000NM0023":("0003","0004","0005","0006","0007"),
                        "ST1000NM0033":("SN01","SN02","SN03","SN04","SN05","SN06","SNC6","SNA5"),
                        "ST2000NM0033":("SN01","SN02","SN03","SN04","SN05","SN06","SNC6","SNA5"),
                        "ST3000NM0033":("SN01","SN02","SN03","SN04","SN05","SN06","SNC6","SNA5"),
                        "ST4000NM0033":("SN01","SN02","SN03","SN04","SN05","SN06","SNC6","SNA5"),
                        }
    #用于版本新旧对比的固件Model与对应的阈值
    oldFWVersionMap = {
                       "HUC101818CS4200":"AAG4",
                       "HUC101812CS4200":"AAG4",
                       }

    #存放无法获取固件版本值的硬盘
    errInfoDiskIDList = []  
    try:
        cmd = "show disk general|filterColumn include columnList=ID,Model,Firmware\\sVersion,Serial\\sNumber"
        #CLI命令执行后，通过接口初步判断命令是否命令不支持
        checkRet = common.isCliExecRetInBlackList(cli, cmd, lang, False)
        flagRet =  common.hasCliExecPrivilege(checkRet[1])
        if not flagRet:
            cmd = "show disk general|filterColumn include colunmList=ID,Model,Firmware\\sVersion,Serial\\sNumber"
            checkRet = common.isCliExecRetInBlackList(cli, cmd, lang, False)
        cliRet = checkRet[1]
        if checkRet[0]:
            errMsg = checkRet[2]
            return (False, cliRet, errMsg)

        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet, errMsg)

        diskDictList = common.getHorizontalCliRet(cliRet)
        for diskDict in diskDictList:
            diskID = diskDict.get("ID","")
            model = diskDict.get("Model","")
            FWVersion = diskDict.get("Firmware Version","")
            bugVersionList = bugFWVersionMap.get(model)
            limitVersion = oldFWVersionMap.get(model)
            if FWVersion == "" or FWVersion == "--":
                errInfoDiskIDList.append(diskID)
                continue
            if (not bugVersionList) and (not limitVersion):
                continue
            if bugVersionList:
                if FWVersion.upper() in bugVersionList:
                    bugDiskIDList.append(diskID)
            if limitVersion:
                if FWVersion.upper() < limitVersion:
                    bugDiskIDList.append(diskID)
        
        PY_LOGGER.info("bugDiskIDList:" + str(bugDiskIDList))
        if bugDiskIDList:
            flag = False
            message = {"zh":u"\n固件版本较低的硬盘如下：\n%s",
                       "en":"\nDisks whose firmware versions are too early are as follows: \n%s",
                      }
            errMsg = message.get(lang) % ", ".join(bugDiskIDList)
        if errInfoDiskIDList:
            flag = False
            message = {"zh":u"\n无法获取固件版本的硬盘如下：\n%s",
                       "en":"\nDisks whose firmware version cannot be obtained are as follows: \n%s",
                      }
            errMsg += message.get(lang) % ", ".join(errInfoDiskIDList)

        return (flag, cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[check disk Firmware Version] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        message = {"zh":u"\n查询结果异常",
                   "en":"\nQuery result is abnormal",
                  }
        errMsg = message.get(lang)
        return (flag, cliRet, errMsg)
