# -*- coding: UTF-8 -*-
import common
import traceback

LANG = py_java_env.get("lang")

def execute(cli):
    '''
        硬盘域扩容导致双控交替复位问题检查： 
        背景：硬盘域扩容操作会消耗系统节点资源（节点用于标记硬盘已分配区间），当节点资源耗尽以后，将导致均衡失败，存储系统部分版本会主动发起控制器复位。（预警公告：EIT-P-S-201619）
        控制器复位触发条件：
        条件一：存储系统版本为风险版本；
        条件二：单引擎容量达到下表所示阈值；
        条件三：对系统中已创建硬盘域进行扩容（新创建硬盘域无该问题）。
        工具需要检查设备是否满足条件1,2。提前识别用户后续对硬盘域扩容可能导致控制器复位的问题。
    '''
    flag = True
    allCliRet = ""
    errMsg = ""
    
    engineCapacityLimitDict = {
                               "S2600T" : 70,#单位TB
                               "S5500T" : 141,
                               "S5600T" : 143,
                               "S5800T" : 284,
                               "S6800T" : 284,
                               "2200 V3" : 18,
                               "2600 V3" : 70,
                               "2800 V3" : 141,
                               "5300 V3" : 70,
                               "5500 V3" : 141,
                               "5600 V3" : 141,
                               "5800 V3" : 284,
                               "6800 V3" : 289,
                               "18500 V3" : 298,
                               "18800 V3" : 307,
                               "18500" : 143,
                               "18800" : 148,
                               "18800F" : 148,
                               "HVS85T" : 143,
                               "HVS88T": 148,
                               }
    
    #问题型号及其对应的版本
    bugProductModelAndVersionListDict = {
        "(?!2800 V3)" : ["V100R001C99.*", "V100R001C00.*", "V100R001C10.*", "V100R001C20.*", "[V100R001C30,V100R001C30SPC200]", "V200R001C00.*", "V200R002C00.*", "V200R002C10.*", 
        "V200R002C20.*", "[V200R002C30,V200R002C30SPC200]", "V300R001C00", "V300R001C10.*", "V300R001C20.*", "V300R002C10.*", "V300R002C10.*", "V300R003C00.*", "^V300R003C10$"],
        "2800 V3" : ["V300R001C00.*", "[V300R003C00,V300R003C00SPC100]"]}
    
    try:
        checkRet = common.checkProductModelAndVersion(cli, bugProductModelAndVersionListDict, LANG)
        allCliRet += checkRet[1]
        #检查过程异常退出
        if not checkRet[0]:
            PY_LOGGER.info("Sequence[disk_domain_expansionCapacity] inspect not pass. (system abnormal!)")
            return (False, allCliRet, checkRet[2])
                
        #非问题版本
        if checkRet[3]:
            PY_LOGGER.info("the device model is %s, the product version is %s." % (checkRet[4], checkRet[5]))
            return (True, allCliRet, "")
                
        #获取所有硬盘域id
        cmd = "show disk_domain general"
        cliRet = cli.execCmd(cmd)
        allCliRet += cliRet
                
        if common.queryResultWithNoRecord(cliRet):
            return (True, allCliRet, errMsg)
        
        productModel = checkRet[4]
        engineCapacityDict = {}
        
        diskDomainInfoDictList = common.getHorizontalCliRet(cliRet)
        for diskDomainInfoDict in diskDomainInfoDictList:
            diskDomainId = diskDomainInfoDict.get("ID")
            cmd = "show disk in_domain disk_domain_id=%s" % diskDomainId
            cliRet = cli.execCmd(cmd)
            allCliRet += cliRet
            
            diskInfoDictList = common.getHorizontalCliRet(cliRet)
            for diskInfoDict in diskInfoDictList:
                diskId = diskInfoDict.get("ID")
                diskCapacity = diskInfoDict.get("Capacity")
                flag, diskCapacityFloat = common.changUnit2GB(diskCapacity)
                if not flag:
                    return (False, allCliRet, errMsg)
                logicEngine = common.getLogicEngineOfDisk(diskId, productModel)
                engineCapacity = engineCapacityDict.get(logicEngine, 0.0)
                engineCapacityDict[logicEngine] = engineCapacity + diskCapacityFloat
        
        engineCapacityLimit = engineCapacityLimitDict.get(productModel, None)
        #6900 V3现网无设备，内部测试直接通过
        if engineCapacityLimit is None:
            return (True, allCliRet, errMsg)
        
        for logicEngine in engineCapacityDict:
            engineCapacity = engineCapacityDict.get(logicEngine)
            if engineCapacity > (engineCapacityLimit * 1024):
                flag = False
                if "zh" == LANG:
                    errMsg += u"\n逻辑引擎%i的容量为%sTB，超过容量阀值%sTB。" % (logicEngine, engineCapacity / 1024, engineCapacityLimit)
                else:
                    errMsg += "\nThe capacity of logical engine %i is %s TB, exceeding the threshold %s TB." % (logicEngine, engineCapacity / 1024, engineCapacityLimit)               
            
        return (flag, allCliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[disk_domain_expansionCapacity] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[disk_domain_expansionCapacity] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[disk_domain_expansionCapacity] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == LANG:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, allCliRet, errMsg)