# -*- coding:utf-8 -*-
import common

resource_dct = {
    'cannot.get.version.info': {
        'en': '\nFailed to get the version of product.',
        'zh': u'\n获取产品版本失败。'
    },
    'query.result.abnormal': {
        'zh': u'\n获取信息失败。',
        'en': '\nThere is an error in getting information.'
    }
}

product_version_for_18000 = ['V100R001C00', 'V100R001C00SPC100', 'V100R001C20', 'V100R001C20SPC100']


def execute(cli):
    """
    检查存储版本状态
    步骤1：以用户admin登录设备；
    步骤2：执行命令： show upgrade package，查询产品型号和版本。
    检查标准：
    若满足以下条件，则检查不通过，否则检查通过。
    1，产品型号为18000 V1系列（含HVS系列），版本为：V100R001C99全部，V100R001C00-V100R001C00SPC100，V100R001C10-V100R001C20SPC100；
    2，产品型号为TV2系列，版本为： V200R002C00-V200R002C20SPC100；
    3、产品型号为2800 V3，版本为：V300R001C00-V300R001C00SPC100，V300R003C00；
    4，产品型号为V3系列其他产品，版本为：V300R001C00-V300R001C10SPC100，V300R002C00-V300R002C10，V300R003C00。
    :param cli:
    :return:
    """
    lang = py_java_env.get("lang")
    cli_ret_all = ''
    try:
        # 获取产品版本
        product_version, cli_ret = common.getCurrentVesionWithCliRet(cli)
        cli_ret_all += cli_ret
        if not product_version:
            return common.NOCHECK, cli_ret_all, resource_dct.get('cannot.get.version.info').get(lang)
        # 检查版本
        if not check_product_version(product_version):
            resource_dct.update({'product.version.low': {
                'zh': u'\n当前存储版本号较低（版本号为：%s），请联系技术支持工程师，升级存储版本。' % product_version,
                'en': '\nThe current storage version is too early (version: %s). Contact technical support engineers to upgrade it.' % product_version
            }})
            return False, cli_ret_all, resource_dct.get('product.version.low').get(lang)
        return True, cli_ret_all, ''
    except Exception:
        return common.NOCHECK, cli_ret_all, resource_dct.get('query.result.abnormal').get(lang)


def check_product_version(product_version):
    """
    1，若产品型号为18000 V1系列（含HVS系列），版本为：V100R001C99全部，V100R001C00-V100R001C00SPC100，V100R001C10-V100R001C20SPC100，则检查不通过；
    :param product_version:
    :return:
    """
    if product_version.startswith('V100R001C99') or product_version.startswith(
            'V100R001C10') or product_version in product_version_for_18000:
        return False
    return True
