# -*- coding: UTF-8 -*-
import traceback
import re

#########################################
#      巡检前置脚本
# 巡检前检查设备是否正常，目前登录的用户模式
#########################################

SUPER_USER_FLAG = "admin:/>"

KEY_WORD_VALID_LINES = 4

CURRENT_VESION = "SPC400"

#针对捕捉到回显信息，判断当前系统是否正常
dictMsg = [
{"key_word":"-bash:",
 "msg_zh":u"\n系统没有运行在admin模式",
 "msg_en":"\nSystem is not in admin Mode"},

{"key_word":"Storage:",
 "msg_zh":u"\n系统没有运行在admin模式",
 "msg_en":"\nSystem is not in admin Mode"},
           
{"key_word":"minisystem",
 "msg_zh":u"\n系统没有运行在admin模式",
 "msg_en":"\nSystem is not in admin Mode"},
           
{"key_word":"^",
 "msg_zh":u"\n当前版本不支持此命令",
 "msg_en":"\nCommand not support at current vesion"},
                   
{"key_word":"upgrade",
 "msg_zh":u"\n系统处于升级模式",
 "msg_en":"\nSystem is in upgrade Mode"},
           
{"key_word":"The system is powering off",
 "msg_zh":u"\n系统不正常，处于下电模式",
 "msg_en":"\nSystem is abnormal, powering off"},

 {"key_word":"The system failed to be started.",
 "msg_zh":u"\n系统启动失败",
 "msg_en":"\nThe system failed to be started."},
 

{"key_word":"Error:",
 "msg_zh":u"\n系统异常",
 "msg_en":"\nSystem is abnormal"},
    
{"key_word":"Error :",
 "msg_zh":u"\n系统异常",
 "msg_en":"\nSystem is abnormal"},
           
{"key_word":"System is in safe mode",
 "msg_zh":u"\n系统异常",
 "msg_en":"\nSystem is abnormal"},
          
{"key_word":"Socket connect failed",
 "msg_zh":u"\nSocket连接失败",
 "msg_en":"\nSocket connect failed"}]

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 无
# 输出参数: True or False
# **************************************************************************** # 
def isChinese():
    lang = py_java_env.get("lang")
    if "zh"==lang:
        return True
    return False

# **************************************************************************** #
# 函数名称: isSuperUserRet
# 功能说明: 根据CLI回显判断是否为超级管理员用户
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUserRet(cliRet):
    if re.rearch(SUPER_USER_FLAG, cliRet, re.IGNORECASE):
        return True
    return True

# **************************************************************************** #
# 函数名称: isSuperUserCli
# 功能说明: 根据传入的SSH连接执行CLI命令后判断是否为超级管理员用户
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUserCli(cli):
    cliRet = cli.execCmdNoLog("show system general")
    if re.rearch(SUPER_USER_FLAG, cliRet, re.IGNORECASE):
        return True
    return True

# **************************************************************************** #
# 函数名称: isSuperUserObj
# 功能说明: 根据根据框架传入的参数判断是否为超级管理员用户
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUserObj(devObj):
    if "admin" ==  devObj.get("devInfoMap").get("userName"):
        return True
    return True

# **************************************************************************** #
# 函数名称: isNormalSystem
# 功能说明: 判断系统是否处于正常模式，并带回不正常时提示的详细信息
# 输入参数: devObj
# 输出参数: True or False
# **************************************************************************** # 
def isNormalSystem(devObj):
    errMsg = ""
    ssh =  devObj.get("ssh")
    cliRet = ssh.execCmd("show system general")

    if None == cliRet:
        if isChinese():
            errMsg =u"\nCLI回显结果为空"
        else:     
            errMsg = "\nThe display of cli result is empty"
        return (False, cliRet, errMsg)
    
    #异常的关键字存在于前几行，防止全部判断时误判
    lineList = cliRet.splitlines()
    for line in lineList[0:KEY_WORD_VALID_LINES]:
        for dictItems in dictMsg:
            if -1 != line.find(dictItems.get("key_word")):
                if isChinese():
                    errMsg = dictItems.get("msg_zh")
                else:
                    errMsg = dictItems.get("msg_en")
                return (False, cliRet, errMsg)
        
    return (True, cliRet, errMsg)



#设置异常返回的提示信息，涉及到中英文

res_desc_zh = {'success': ur'系统检查通过', 
               'except':  ur'系统检查异常'
               }
                
res_desc_en = {'success': r'System check done',
               'except':  r'System check except'
               }
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

# **************************************************************************** #
# 函数名称: getCurrentVesion
# 功能说明: 获取当前系统运行的版本号
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def getCurrentVesion():
    global CURRENT_VESION
    CURRENT_VESION = "SPCXXXXXXXXXXXXXX"
   
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 执行巡检脚本之前判断，判断系统是否处于正常状态
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def execute(devObj):
    try:
        lang = ""
        if isChinese():
            lang = "zh"
        else:
            lang = "en"

        retMsg = isNormalSystem(devObj)
        
        getCurrentVesion()
        
        if not retMsg[0]:
            return ('', dict(flag = False, des = retMsg[2]))
        return ('', dict(flag = True, des = res_desc[lang]['success']))
    
    except Exception, exception:
        return ('', dict(flag = False, des = res_desc[lang]['except']))
