# -*- coding: UTF-8 -*-
import re

RESULT_WARNING = "WARNING"

# ************************************** #
# 函数名称: formatList
# 功能说明: 将list样式字符串转换成list对象
# 输入参数: descStr字符串
# 输出参数: 由多个dict对象组成的list
# ************************************** #
def formatList(descStr):
    
    # 由---和空格构成行的行号，大于等于1
    REF_LINE_NO = None                              
    # 最后需要返回的结果
    result = []
    # 存放各列数据的开始位置/结束位置
    valsIndex = []
    # 将字符串拆成单行并存放在list对象中
    lsts = descStr.splitlines()                    
    #正则表达式，以空格隔开的由多个-构成的字符串（首尾空格不限）
    pattern = re.compile("^\s*-+(\s+-+)*\s*$")    

    # 尝试找到符合正则表达式的行
    for i in xrange(len(lsts)):
        if  pattern.match(lsts[i]):
            # 确定行号
            REF_LINE_NO = i
            # 确定列取值的开始位置
            valsIndex.append(lsts[i].find("-"))
            break
        
    # 如果没有找到符合正则表达式的行号，意味着格式不符合，不再继续解析，直接返回空结果    
    if not REF_LINE_NO:
        return result

    # 取出---和空格构成的行
    strVals = lsts[REF_LINE_NO] 

    while valsIndex[-1] != -1:
        #依次取出“ -”所在的位置并添加到valsIndex，直到取到-1为止
        valsIndex.append(strVals.find(" -", valsIndex[-1] + 1))    
    #将最后一位设为字符串长度，最后一次取值直接取到末尾
    valsIndex[-1] = len(strVals)
    
    # 在各dict中作为键值的list
    keys = []   
    # 计算key值，以valsIndex中的两个相临值作为开始位置和结束位置，并去除空格
    for i in xrange(1, len(valsIndex), 1):
        key = lsts[REF_LINE_NO - 1][valsIndex[i - 1]:valsIndex[i]].strip()
        #判断是否有重复存在的列名，若存在则追加一个下标
        if keys.count(key) > 0:
            temp = 1
            while keys.count(key + "_" + str(temp)) != 0:
                temp += 1
            key = key + "_" + str(temp)
  
        keys.append(key)

    # 取出---下面的单行进行解析
    for i in xrange(REF_LINE_NO + 1, len(lsts), 1):
        
        # 排除最后一行，若遇到最后一行则退出循环
        if isEndLine(lsts[i]):            
            break
        #遇到空行时忽略
        if re.compile("^\s*$").match(lsts[i]):
            continue
        
        # 单行dict中作为value值的list        
        vals = []    
        # 计算单行的value值，以valsIndex中的两个相临值作为开始位置和结束位置，并去除空格
        for j in xrange(1, len(valsIndex), 1):
            vals.append(lsts[i][valsIndex[j - 1]:valsIndex[j]].strip())

        # 单行value计算完成后，与key值合并成dict添加到result结果集中
        result.append(dict(zip(keys, vals)))  
    
    # 所有行解析完成后返回result结果集
    return result

# **************************************
# 函数名称: formatDict
# 功能说明: 将dict样式字符串转换成list/dict对象
# 输入参数: descStr字符串
#          simpleMode:是否为简单模式，若为True则所有Value值解析成字符串，不会再对其作进一步解析
#          若为False则会对Value作进一步判断，可能会将其进一步转化为dict或list
# 输出参数: 若解析出来只有一个Dict则直接返回Dict对象，
#          若包含多个Dict则返回由多个Dict组成的List对象
# **************************************
def formatDict(descStr, simpleMode=False):
    
    # 最后需要返回的结果
    result = []
    # 将字符串拆成单行并存放在list对象中
    lsts = descStr.splitlines()
    # 用于分隔两个字典的单行，整行都由---构成
    pattern = re.compile("^\s*[-]*-\s*$")
    # 用于匹配”--------  xxx Key : ---------“这类字符串以作为Key值
    pattern_key_str = "^\s*-+\s*([a-zA-z0-9]+\s*)+:\s*-+\s*$"
    pattern_key = re.compile(pattern_key_str)
    # dict中的键集合
    keys = []
    # dict中的值集合
    vals = []                               

    #当前所读取的行号
    i = 0 
    while i < len(lsts):
        
        str_line = lsts[i] #缓存此行
        
        #遇到最后一行则退出while循环
        if isEndLine(str_line):
            break
        
        i += 1 #行号+1，准备读取下一行数据

        # 如果遇到整行都是---，将键值对添加到result中并重新初始化key和val
        if pattern.match(str_line): 
            result.append(dict(zip(keys, vals)))
            keys = []
            vals = []
            continue
        
        # 找到冒号所在的位置   
        index = str_line.find(":")        
        # 当冒号存在时，将冒号前的字符串添加到key中，冒号后的字符串添加到val中，均需要去除前后的字符串
        if index != -1:
            
            #该行中格式类似”------  key:  ------“
            from com.huawei.ism.tool.obase.utils import StringUtils
            if StringUtils.checkRegexReDos(str_line, pattern_key_str) \
                    and pattern_key.match(str_line) and not simpleMode:
                key = str_line[:index].strip('-').strip()
                val = ""
                #追加键
                keys.append(key)
                #此while语句用于拼接字符串
                while i < len(lsts):
                    str_line = lsts[i]

                    if str_line.endswith(":") or pattern_key.match(str_line) or str_line.find(":/>") != -1:
                        break
                    else:
                        val = val + "\r\n" + str_line               
                        i += 1 #行号+1，准备读取下一行数据
                val = formatStr(val) #退出while循环时需要对key值进行格式化,递归调用
                vals.append(val)             
                continue
            else:
                key = str_line[:index].strip()
                #因为有时候键后面为一堆空格，这里为特殊处理，空格不当成空处理，但保存时仍然存空（即else中的处理）
                val = str_line[index + 1:]
                #追加键
                keys.append(key)
                #若同行取到的value值为空，则认为从下一行开始才是该key的value值，在这种情况下value又将是一个Dict或List对象
                if val == "":
                    #此while语句用于拼接字符串，直到再次遇到以冒号结尾或者包含":/>"情况
                    while i < len(lsts):
                        str_line = lsts[i]
                        if str_line.endswith(":") or isEndLine(str_line):
                            break
                        else:
                            val = val + "\r\n" + str_line               
                            i += 1 #行号+1，准备读取下一行数据
                    if not simpleMode:
                        val = formatStr(val) #退出while循环时需要对key值进行格式化,递归调用
                else:
                    val = val.strip() 
                vals.append(val)               
                continue        
        
        # 若某行是[Board Properties]的集合时暂时未做处理，会忽略掉后面的行
        
    #此行已退出while循环
        
    # 退出while循环时判断result是否为空，若为空则返回字典，否则返回由字典组成的序列    
    if len(result) > 0:
        result.append(dict(zip(keys, vals)))
    else:
        result = dict(zip(keys, vals))
    return result

# **************************************
# 函数名称: formatStr
# 功能说明: 在不确定字符串样式自动判断样式并转换成List/Dict对象
# 输入参数: descStr：需要解析的字符串
#          cmdLineFlag：是否包含第一行命令的boolean值
# 输出参数: 若传入空字符串也返回空字符串
#          若解析出来只有一个Dict则直接返回Dict对象，
#          若包含多个Dict则返回由多个Dict组成的List对象
# **************************************
def formatStr(descStr):
    
    pattern = re.compile("^\s*-+(\s+-+)*\s*$") 
    lsts = descStr.strip().splitlines()
    if len(lsts) == 0:
        return ""
    #以show开头的认为是命令行，直接排除
    if lsts[0].startswith("show "):
        lsts.pop(0)
        
    for i in xrange(len(lsts)):
        if "" != lsts[i].strip():
                      
            #若字符串中带有冒号，则认为是
            if lsts[i].find(":") != -1:
                return formatDict(descStr)
            
            #当不带冒号且次行符合由多个---与空格组成的格式
            elif i + 1 < len(lsts) - 1:
                if pattern.match(lsts[i + 1].strip()):                
                    return formatList(descStr)
                
            #若无法确定格式则直接返回该字符串（去除命令行,最后的结束及前后的空白）
            else:
                if isEndLine(lsts[-1]):
                    lsts.pop()
                    
            return "\r\n".join(lsts).strip()

# **************************************
# 函数名称: isEndLine(descStr)
# 功能说明: 判断是否为结束行
# 输入参数: descStr:一行字符串
# 输出参数: Boolean值
# **************************************
def isEndLine(descStr):
    patternEndflag = re.compile(r".*:/.*>.*")
    return patternEndflag.match(descStr)

