# -*- coding: UTF-8 -*-
import traceback
import common
G_ITEM_NUM_CONTROLLER = 2
def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show controller general"
        PY_LOGGER.info("Sequence[1] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]: 
            PY_LOGGER.info("Sequence[1] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        list = cliRet.splitlines()
        i = 0;j=0
        for field in list:
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                continue
                
            if field.startswith("HealthStatus"):
                if field.replace("HealthStatus:","") not in ["normal", "Normal"]:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+ctrlId+u"]健康状态检查异常"
                    else:
                        errMsg += "\nThe health status of Controller ["+ctrlId+"] is abnormal"
                i = i + 1
                continue
                
            if field.startswith("RunningStatus"):
                if field.replace("RunningStatus:","") not in ["online", "Online"]:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+ctrlId+u"]运行状态检查异常"
                    else:
                        errMsg += "\nThe running status of Controller ["+ctrlId+"] is abnormal"
                j = j + 1
                continue
            
        if i != G_ITEM_NUM_CONTROLLER or j != G_ITEM_NUM_CONTROLLER:
            flag = False
            PY_LOGGER.info("Sequence[1] inspect not pass.")
            if "zh" == lang:
                errMsg = u"\n系统可能处于单控状态"
            else:
                errMsg = "\nSystem may be in single status"
            return (flag, cliRet, errMsg)
        
        if not flag:
             PY_LOGGER.info("Sequence[1] inspect not pass.")
             
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[1] catch except of check controller status.")
        PY_LOGGER.error("Sequence[1] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[1] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[1] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
