# -*- coding: UTF-8 -*-
import traceback
import common

#SPC500发布开放巡检命令，脚本兼容处理，2013/11/12，modified Begin
# **************************************************************************** #
# 函数名称: checkCliRet
# 功能说明: 判断CLI回显是否满足此项巡检通过的标准
# 输入参数: cliRet,lang
# 输出参数: True or False
# **************************************************************************** #    
def checkCliRet(cliRet,lang):
    errMsg = ""
    flag = common.CHECK_PASS
    list = cliRet.splitlines()
    for field in list:          
        field = field.replace(" ","")
        if field.startswith("Controller:"):
            list2 = field.split(":")
            
            if len(list2)<2:
                break
            
            controller = str(list2[1])

        if field.startswith("AllTemperatures(Celsius)"):
            list2 = field.split(":")
            
            if len(list2)<2:
                break
                 
            #Get temperatrues of four points: CPU, in, out1, out2
            list3 = str(list2[1]).split(",")
            tempCPU = int(list3[0])
            tempIN = int(list3[1])

            if(tempCPU > 85):
                flag = common.CHECK_NOPASS
                if "zh" == lang:
                    errMsg += u"\n控制器["+controller+u"] CPU温度超过85摄氏度"
                else:
                    errMsg += "\nThe CPU temperature of controller["+controller+u"] exceed 85 celsius"

            if(tempIN > 52):
                flag = common.CHECK_NOPASS
                if "zh" == lang:
                    errMsg += u"\n控制器["+controller+u"] 温控检测点温度超过52摄氏度"
                else:
                    errMsg += "\nThe temperature monitoring point of controller["+controller+u"] exceed 52 celsius"
   
    return (flag, errMsg)
#SPC500发布开放巡检命令，脚本兼容处理，2013/11/12，modified End

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = common.CHECK_PASS
        cliRet = ""
        errMsg = ""
        cmd = "show controller general"
        lang = py_java_env.get("lang")
        userLevel = common.getUserPrivilege(cli,py_java_env)
        
        #命令从XXX版本开始开放到只读用户下，直接在CLI模式下获取回显值
        if common.isSupportVersion(cli,py_java_env):
            PY_LOGGER.info("Sequence[11] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                flag = common.CHECK_NOPASS
                PY_LOGGER.info("Sequence[11] inspect not pass. (system abnormal!)")
                return (flag, cliRet, errMsg)

        #老版本需要切入到调试模式获取CLI回显值
        elif "super_admin"==userLevel or "admin"==userLevel:
            retInfo= common.change2Developer(cli, py_java_env)
            cliRet = retInfo[1]
            errMsg = retInfo[2]
            if not retInfo[0]:
                flag = common.CHECK_NOPASS
                common.anyModel2Cli(cli, py_java_env)
                PY_LOGGER.info("Sequence[11] inspect not pass. (can't enter to developer model!)")
                return(flag, cliRet, errMsg)  
            
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                flag = common.CHECK_NOPASS
                PY_LOGGER.info("Sequence[11] inspect not pass. (system abnormal!)")
                common.anyModel2Cli(cli, py_java_env)
                return (flag, cliRet, errMsg)
            
        #其它情况   
        else:
            flag = common.CHECK_NOSUPPORT
            cliRet = "Login user is low-privileged, cant't support checking this item, \nplease using super-admin user to login."
            PY_LOGGER.info("Sequence[11] inspect can't check this item, low-privileged")
            if "zh" == lang:
                errMsg += u"\n用户登录权限过低，不支持此项巡检"
            else:
                errMsg += "\nLogin user is low-privileged, cant't support checking this item"
            return (flag, cliRet, errMsg)
            

        checkRet = checkCliRet(cliRet,lang)
        flag = checkRet[0]
        errMsg = checkRet[1]
        
        if common.CHECK_PASS != flag:
             PY_LOGGER.info("Sequence[11] inspect not pass.")
             
        common.anyModel2Cli(cli, py_java_env)
        return (flag, cliRet,errMsg)  
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[11] catch except of check controller temperature.")
        PY_LOGGER.error("Sequence[11] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[11] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[11] catch except of trace back:" + str(traceback.print_exc()))
        flag = common.CHECK_NOPASS
        common.anyModel2Cli(cli, py_java_env)
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
