# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkfc_start = False
        lang = py_java_env.get("lang")
    	errMsg = ""
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show port general"
            PY_LOGGER.info("Sequence[15] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[15] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showPortGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[15] begin to inspect, get cli result form java.")
        
        list = cliRet.splitlines()
        #巡检项检查结果优化 modified Begin
        for field in list:        
            if field.find("ETH port") != -1:
                chkfc_start = True
            if field.find("FC port") != -1 or field.find("COM port") != -1 \
                or field.find("SAS port") != -1 or field.find("Management Port:---") != -1 :
                chkfc_start = False
            if chkfc_start == True:
                
                #端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过
                checkLine = common.isNormalLine(field,lang)
                if not checkLine[0]:
                    flag = False
                    errMsg = checkLine[1]
                    return (flag, cliRet, errMsg)
                if field.find("Host Port") == -1 or -1 != field.find("------------"):
                    continue
                
                #有效行必须含有"INI and TGT"
                if (-1!=field.find("INI and TGT")):     
                    list2 = field.split()
                    if "Normal"!=list2[1]:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nISCSI端口["+list2[0]+u"]健康状态检查异常"
                        else:
                            errMsg += "\nThe health status of ISCSI port ["+list2[0]+"] is abnormal" 
                        continue
                    if list2[1] == "Normal" and list2[3] == "Up":
                        if list2[len(list2)-1] not in ["10", "100", "1000", "10000"]:
                            flag = False
                            if "zh" == lang:
                                errMsg += u"\nISCSI端口["+list2[0]+u"]速率异常"
                            else:
                                errMsg += "\nThe speed of iscsi port["+list2[0]+"] is abnormal"

        if not flag:
             PY_LOGGER.info("Sequence[15] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[15] catch except of when check FC port."+str(chkfc_start))
        PY_LOGGER.error("Sequence[15] catch except of check FC port.")
        PY_LOGGER.error("Sequence[15] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[15] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[15] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
