# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
          
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show disk bad_sector_record"
        PY_LOGGER.info("Sequence[17] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetJudgeWithDoubleList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CHECK_NOPASS == checkRet[0]:
            PY_LOGGER.info("Sequence[17] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #命令执行后包含Command executed successfully等成功标志，直接退出，巡检通过
        elif common.CHECK_PASS == checkRet[0]:
            return (True, cliRet, "")
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
    
        list = cliRet.splitlines()
        i = 0
        line=""
        for field in list:
            line=field.strip()
            field = field.replace(" ", "")      
            if len(line) == 0:
                continue
            
            if line.startswith("Disk") or line.startswith('--') or \
                line.startswith('show disk bad_sector_record') or common.isEndLine(line):
                continue
            flag = False
            diskId=line.split()[0]
            
            if 'zh' == lang:
                errMsg += u"\n硬盘[" + diskId+ u"]存在有坏块标记"
            else:
                errMsg += "\nThe disk [" + diskId+ "] is exists bad sector tag"
    
        if not flag:
             PY_LOGGER.info("Sequence[17] inspect not pass.")
             
        return (flag, cliRet,errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[17] catch except of check disk bad_sector.")
        PY_LOGGER.error("Sequence[17] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[17] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[17] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
