# -*- coding: UTF-8 -*-
import traceback
import common

#SPC500发布开放巡检命令，脚本兼容处理，2013/11/12，modified Begin
# **************************************************************************** #
# 函数名称: checkCliRet
# 功能说明: 判断CLI回显是否满足此项巡检通过的标准
# 输入参数: cliRet,lang
# 输出参数: True or False
# **************************************************************************** #    
def checkCliRet(cliRet,lang):
    errMsg = ""
    chk_start =False
    type = "default"
    flag = common.CHECK_PASS
    list = cliRet.splitlines()
    ethId=""
    fcId=""
    
    for field in list:       
        if -1!=field.find("FC port"):
            chk_start = True
            type = "fc"
        if -1!=field.find("ETH port"):
            chk_start = True
            type = "eth"
               
        if -1!=field.find("SAS port"):
            chk_start = False
            
        if chk_start == True:
            if -1!=field.find("Start Time") or -1!=field.find("Host Port"):
                continue
            
            list2 = field.split()
            if type == "eth":
                #端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过
                checkLine = common.isNormalLine(field,lang)
                if not checkLine[0]:
                    flag = common.CHECK_NOPASS
                    errMsg = checkLine[1]
                    return (flag, errMsg)
                
                if len(list2) < 5:
                    continue
                
                if -1!=field.find("-------") or -1!=field.find("ID"):
                    continue
                
                for indexEth in range(1, 4):
                    if "0"!=list2[indexEth] and -1==list2[indexEth].find("--"):
                        flag = common.CHECK_NOPASS
                        ethId = list2[0]
                        if "zh" == lang:
                            errMsg += u"\n网口["+ethId+u"]存在误码"
                        else:
                            errMsg += "\nThe ETH port ["+ethId+"] exist error bits"
                        break
               
            if type == "fc":
                #端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过
                checkLine = common.isNormalLine(field,lang)
                if not checkLine[0]:
                    flag = common.CHECK_NOPASS
                    errMsg = checkLine[1]
                    return (flag, errMsg)
                
                if len(list2) < 6 or len(list2) >= 12:
                    continue
                
                if -1!=field.find("-------") or -1!=field.find("ID"):
                    continue

                for index in range(1, 5):
                    if "0"!=list2[index] and -1==list2[index].find("--"):
                        flag = common.CHECK_NOPASS
                        fcId = list2[0]
                        if "zh" == lang:
                            errMsg += u"\nFC口["+ fcId+u"]存在误码"
                        else:
                            errMsg += "\nThe FC port ["+fcId+"] exist error bits"
                        break
                    
    return (flag, errMsg)
#SPC500发布开放巡检命令，脚本兼容处理，2013/11/12，modified End

def execute(cli):
    """
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = common.CHECK_PASS
        cliRet = ""
        errMsg = ""
        cmd = "show port bit_error"
        lang = py_java_env.get("lang")
        userLevel = common.getUserPrivilege(cli,py_java_env)
        
        #命令从XXX版本开始开放到只读用户下，直接在CLI模式下获取回显值
        if common.isSupportVersion(cli,py_java_env):
            PY_LOGGER.info("Sequence[18] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                flag = common.CHECK_NOPASS
                PY_LOGGER.info("Sequence[18] inspect not pass. (system abnormal!)")
                return (flag, cliRet, errMsg)

        #老版本需要切入到调试模式获取CLI回显值
        elif "super_admin"==userLevel or "admin"==userLevel:
            retInfo= common.change2Developer(cli, py_java_env)
            cliRet = retInfo[1]
            errMsg = retInfo[2]
            if not retInfo[0]:
                flag = common.CHECK_NOPASS
                common.anyModel2Cli(cli, py_java_env)
                PY_LOGGER.info("Sequence[18] inspect not pass. (can't enter to developer model!)")
                return(flag, cliRet, errMsg)  
            
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                flag = common.CHECK_NOPASS
                PY_LOGGER.info("Sequence[18] inspect not pass. (system abnormal!)")
                common.anyModel2Cli(cli, py_java_env)
                return (flag, cliRet, errMsg)
            
        #其它情况   
        else:
            flag = common.CHECK_NOSUPPORT
            cliRet = "Login user is low-privileged, cant't support checking this item, \nplease using super-admin user to login."
            PY_LOGGER.info("Sequence[18] inspect can't check this item, low-privileged")
            if "zh" == lang:
                errMsg += u"\n用户登录权限过低，不支持此项巡检"
            else:
                errMsg += "\nLogin user is low-privileged, cant't support checking this item"
            return (flag, cliRet, errMsg)
            

        checkRet = checkCliRet(cliRet,lang)
        flag = checkRet[0]
        errMsg = checkRet[1]
        
        if common.CHECK_PASS != flag:
             PY_LOGGER.info("Sequence[18] inspect not pass.")
             
        common.anyModel2Cli(cli, py_java_env)
        return (flag, cliRet, errMsg)  
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[18] catch except of check host port error.")
        PY_LOGGER.error("Sequence[18] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[18] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[18] catch except of trace back:" + str(traceback.print_exc()))
        flag = common.CHECK_NOPASS
        common.anyModel2Cli(cli, py_java_env)
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

