# -*- coding: UTF-8 -*-
import traceback
import common
G_RETRY_TIMES = 30

def execute(cli):
    """
    Create date        : 2013/07/24
    Function describe  : execute check disk path
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""   
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show disk general|filterColumn include ID,Multipathing|filterRow Multipathing equal_to A or Multipathing equal_to B"
        PY_LOGGER.info("Sequence[20] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetWithTimeout(cli,cmd,G_RETRY_TIMES,lang)
        cliRet = checkRet[1]
        if common.CHECK_NOPASS == checkRet[0]:
            errMsg = checkRet[2]
            PY_LOGGER.info("Sequence[20] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        elif common.CHECK_PASS == checkRet[0]:
            return (True, cliRet, "")
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End

        list = cliRet.splitlines()             
        #巡检项检查结果优化 modified 20130913 Begin
        line=""
        for field in list:
            line=field.strip()
            field = field.replace(" ", "")
            
            if len(line) == 0:
                continue
            if line.startswith("ID") or line.startswith('---') or line.startswith('show disk general') \
                or line.startswith("***") or common.isEndLine(line):
                continue
            flag = False
            locStr=line.split()[0]
     
            if 'zh' == lang:
                errMsg += u"\n硬盘[" + locStr+ u"] 单链路"
            else:
                errMsg += "\nThe disk [" + locStr+ "] is single path"

        if not flag:
             PY_LOGGER.info("Sequence[20] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified 20130913 End
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[20] catch except of check single link disk.")
        PY_LOGGER.error("Sequence[20] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[20] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[20] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
