# -*- coding: UTF-8 -*-
import traceback
import common
import re

#重试时间30S
G_RETRY_TIMES = 180

#是否存在托管的SVP
def isFailed2Manage(cli, lang):
    
    cliRet = ""
    errMsg = ""
    
    #执行的CLI命令
    cmd = "show alarm |filterRow ID equal_to 0xF8008000B"
    
    #命令从XXX版本开始开放到只读用户下，或非guest用户直接在CLI模式下获取回显值
    userLevel= common.getUserPrivilege(cli, py_java_env)
    if common.isSupportVersion(cli,py_java_env)\
       or "super_admin"==userLevel or "admin"==userLevel:
        PY_LOGGER.info("Sequence[21] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetWithTimeout(cli,cmd,G_RETRY_TIMES,lang)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CHECK_NOPASS == checkRet[0]:
            PY_LOGGER.info("Sequence[21] inspect not pass. (system abnormal!)")
            return (common.CHECK_NOPASS, cliRet, errMsg)
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        elif common.CHECK_PASS == checkRet[0]:
            return (common.CHECK_PASS, cliRet, errMsg)
        
    #获取用户目前的登录权限，此命令guest用户在小于V100R001C99SPC500版本不支持
    else:
        #命令支持的版本为V100R001C99SPC500，小于此版本的都不支持
        PY_LOGGER.info("Sequence[21] can't inspect, user level is:"+str(userLevel))
        cliRet = "\nLogin user is low-privileged, cant't check whether exist the alarm of failed to manage SVP, \nplease using super-admin or admin user to login"
        if "zh" == lang:
            errMsg += u"\n用户登录权限过低，不支持此项巡检"
        else:
            errMsg += "\nLogin user is low-privileged, cant't support checking this item"
        return (common.CHECK_NOSUPPORT, cliRet, errMsg)
        
    #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin

    list = cliRet.splitlines()
    for field in list:
        if re.search("Failed to manage", field, re.IGNORECASE):
            if "zh" == lang:
                errMsg = u"\n存在不能被管理的SVP"
            else:
                errMsg = "\nFailed to manage SVP is exist" 
            return (common.CHECK_NOPASS, cliRet, errMsg)
    return (common.CHECK_PASS, cliRet, errMsg)


def execute(cli):
    """
    Create date        : 2013/08/09
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
    	flag = common.CHECK_PASS
    	lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show enclosure"
        PY_LOGGER.info("Sequence[21] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            flag = common.CHECK_NOPASS
            PY_LOGGER.info("Sequence[21] inspect not pass. (system abnormal!)")
            return (flag, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
    	list = cliRet.splitlines()
    	svpId=""
    	for field in list:
            list2=field.split()
            field=field.replace(" ","")
            if True==field.startswith("SVP"):
                if (-1==field.find("Normal")) or (-1!=field.find("Fault")) or (-1!=field.find("Offline")):
                    flag = common.CHECK_NOPASS
                    if len(list2)>0:
                        svpId = list2[0]
                        if "zh" == lang:
                             errMsg += u"\nSVP["+svpId+u"]状态检查异常"
                        else:  
                            errMsg += "\nThe status of SVP ["+svpId+"] is abnormal" 

        retMsg = isFailed2Manage(cli, lang)
        flag = retMsg[0]
        cliRet +=retMsg[1]
        errMsg += retMsg[2]
    
        if common.CHECK_NOPASS != flag:
             PY_LOGGER.info("Sequence[21] inspect not pass.")
             
        return (flag, cliRet, errMsg)      

    except Exception, exception:
        PY_LOGGER.error("Sequence[21] catch except of check SVP status.")
        PY_LOGGER.error("Sequence[21] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[21] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[21] catch except of trace back:" + str(traceback.print_exc()))
        flag = common.CHECK_NOPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
