# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18 
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        i = 0
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show bbu general"
        PY_LOGGER.info("Sequence[4] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[4] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        list = cliRet.splitlines()
        bbuId=""
		#巡检项检查结果优化 modified Begin
        for field in list:         
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if len(list2) < 5:
                    continue

                #health status要为Normal
                if -1==field.find("normal") and -1==field.find("Normal"):
                    flag = False
                    bbuId = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]健康状态检查异常"
                    else:
                        errMsg += "\nThe health status of BBU [" + bbuId + "] is abnormal"
                
                #runnig status要为Charging，Discharging或Online
                if -1==field.find("charging") and -1==field.find("discharging") and -1==field.find("online")\
                    and -1==field.find("Charging") and -1==field.find("Discharging") and -1==field.find("Online"):
                    flag = False
                    bbuId = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]运行状态检查异常"
                    else:
                        errMsg += "\nThe running status of BBU [" + bbuId + "] is abnormal"

        if not flag:
             PY_LOGGER.info("Sequence[4] inspect not pass.")
             
        return (flag, cliRet, errMsg)
		#巡检项检查结果优化 modified End

    except Exception, exception:
        PY_LOGGER.error("Sequence[4] catch except of check bbu status.")
        PY_LOGGER.error("Sequence[4] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[4] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[4] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
