# -*- coding: UTF-8 -*-
import traceback
import common
G_RETRY_TIMES = 30

def query_HostName(cli, seq):
    try:
        result = ""
        i = 0
        detail = ""
        cliRet = cli.execCmd("show alarm sequence="+ str(seq))
        isStart = False
        list_info = cliRet.splitlines()
        if len(list_info) <= 3:
            return ""
        for element in list_info:
            element_tmp = element.replace(" ","")
            if element_tmp.startswith("Detail") == True:
                detail = detail+element
                isStart = True
            elif isStart == True:
                detail = detail+element
                continue
            if element_tmp.startswith("Repair") == True:
                isStart = False
                break
        if detail == "":
            return detail
        index_1 = detail.find("(name")
        index_2 = detail.find(")")
        host_name = detail[index_1+6:index_2]
        return host_name
    except Exception, exception:
        PY_LOGGER.error("Sequence[72] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[72] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[72] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[72] catch except of trace back:" + str(traceback.print_exc()))
        return ""
    
def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function describe  : execute warning alarm check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = common.CHECK_PASS
        lang = py_java_env.get("lang")
        host_name = ""
        send_alarm = False
        alarmInfo = [{"alarm_id":"0xF00150019", "desc_zh":"主机["+host_name+"]到阵列没有冗余路径", "desc_en":"A redundant path from host["+host_name+"] to a storage array was not configured."}]
    	errMsg = ""
        cliRet = ""
            
        for element in alarmInfo:
            #执行的CLI命令
            cmd = "show alarm |filterRow ID equal_to "+element.get("alarm_id")
            PY_LOGGER.info("Sequence[72] begin to inspect, exec cli command:"+str(cmd))
            
            #命令从XXX版本开始开放到只读用户下，或非guest用户直接在CLI模式下获取回显值
            userLevel= common.getUserPrivilege(cli, py_java_env)
            if common.isSupportVersion(cli,py_java_env)\
               or "super_admin"==userLevel or "admin"==userLevel:
                #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
                checkRet =  common.cliExecRetWithTimeout(cli,cmd,G_RETRY_TIMES,lang)
                cliRet = checkRet[1]
                errMsg = checkRet[2]
                if common.CHECK_NOPASS == checkRet[0]:
                    PY_LOGGER.info("Sequence[72] inspect not pass. (system abnormal!)")
                    return (common.CHECK_NOPASS, cliRet, errMsg)
                #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
                elif common.CHECK_PASS == checkRet[0]:
                    return (common.CHECK_PASS, cliRet, errMsg)
                
            #获取用户目前的登录权限，此命令guest用户在小于V100R001C99SPC500版本不支持
            else:
                #命令支持的版本为V100R001C99SPC500，小于此版本的都不支持
                PY_LOGGER.info("Sequence[72] can't inspect, user level is:"+str(userLevel))
                cliRet = "\nLogin user is low-privileged, cant't check whether exist the alarm of failed to manage SVP, \nplease using super-admin or admin user to login"
                if "zh" == lang:
                    errMsg += u"\n用户登录权限过低，不支持此项巡检"
                else:
                    errMsg += "\nLogin user is low-privileged, cant't support checking this item"
                return (common.CHECK_NOSUPPORT, cliRet, errMsg)
            
            list = cliRet.splitlines()
            for field in list:
                if -1!= field.find("Major"):
                    send_alarm = True
                    list_alarm_info = field.replace(" ", "").split("Major")
                    if len(list_alarm_info) >=2:
                        seq = list_alarm_info[0]
                        hostName = query_HostName(cli, seq)
                        if hostName != "":
                            if "" != host_name:
                                host_name += ", "
                            host_name = host_name+hostName
                            
        if send_alarm == True:
            PY_LOGGER.info("Sequence[72] inspect not pass.")
            flag = common.CHECK_NOPASS
            if "zh" == lang:
                errMsg = u"主机["+host_name+u"]到阵列没有冗余路径"
            else:
                errMsg = "A redundant path from host ["+host_name+"] to a storage array was not configured."
            return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[72] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[72] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[72] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[72] catch except of trace back:" + str(traceback.print_exc()))
        flag = common.CHECK_NOPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
