# -*- coding: UTF-8 -*-
import traceback
import common
  
#SPC500发布开放巡检命令，脚本兼容处理，2013/11/12，modified Begin
# **************************************************************************** #
# 函数名称: checkCliRet
# 功能说明: 判断CLI回显是否满足此项巡检通过的标准
# 输入参数: cliRet,lang
# 输出参数: True or False
# **************************************************************************** #    
def checkCliRet(cliRet,lang):
    errMsg = ""
    flag = common.CHECK_PASS
    
    list = cliRet.splitlines()
    for field in list:          
        list2 = field.split()
        if field.find("Enabled") != -1:
            if list2[2] != "Yes" and list2[2] != "No":
                flag = common.CHECK_NOPASS
                if "zh" == lang:
                    errMsg = u"\n硬盘write_cache属性异常"
                else:
                    errMsg = "\nThe write_cache property of disk is abnormal"
                return (flag, errMsg)
                  
    return (flag, errMsg)  
#SPC500发布开放巡检命令，脚本兼容处理，2013/11/12，modified End
     
def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = common.CHECK_PASS
        cliRet = ""
        errMsg = ""
        cmd = "show disk write_cache"
        lang = py_java_env.get("lang")
     
        #命令从XXX版本开始开放到只读用户下，直接在CLI模式下获取回显值
        if common.isSupportVersion(cli,py_java_env):
            PY_LOGGER.info("Sequence[8] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                flag = common.CHECK_NOPASS
                PY_LOGGER.info("Sequence[8] inspect not pass. (system abnormal!)")
                return (flag, cliRet, errMsg)

        #老版本需要切入到调试模式获取CLI回显值
        elif "super_admin" == common.getUserPrivilege(cli,py_java_env):
            retInfo= common.change2Developer(cli, py_java_env)
            cliRet = retInfo[1]
            errMsg = retInfo[2]
            if not retInfo[0]:
                flag = common.CHECK_NOPASS
                common.anyModel2Cli(cli, py_java_env)
                PY_LOGGER.info("Sequence[8] inspect not pass. (can't enter to developer model!)")
                return(flag, cliRet, errMsg)  
            
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                flag = common.CHECK_NOPASS
                PY_LOGGER.info("Sequence[8] inspect not pass. (system abnormal!)")
                common.anyModel2Cli(cli, py_java_env)
                return (flag, cliRet, errMsg)
            
        #其它情况   
        else:
            flag = common.CHECK_NOSUPPORT
            cliRet = "Login user is low-privileged, cant't support checking this item, \nplease using super-admin user to login."
            PY_LOGGER.info("Sequence[8] inspect can't check this item, low-privileged")
            if "zh" == lang:
                errMsg += u"\n用户登录权限过低，不支持此项巡检"
            else:
                errMsg += "\nLogin user is low-privileged, cant't support checking this item"
            return (flag, cliRet, errMsg)
            

        checkRet = checkCliRet(cliRet,lang)
        flag = checkRet[0]
        errMsg = checkRet[1]
        
        if common.CHECK_PASS != flag:
             PY_LOGGER.info("Sequence[8] inspect not pass.")
             
        common.anyModel2Cli(cli, py_java_env)
        return (flag, cliRet,errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[8] catch except of check disk write_cache.")
        PY_LOGGER.error("Sequence[8] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[8] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[8] catch except of trace back:" + str(traceback.print_exc()))
        flag = common.CHECK_NOPASS
        common.anyModel2Cli(cli, py_java_env)
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
