# -*- coding: UTF-8 -*-
import traceback
import common
G_RETRY_TIMES = 30
HAS_RECORD_MIN_LINES = 4

def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function describe  : execute major alarm check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = common.CHECK_PASS
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #执行的CLI命令
        cmd = "show alarm level=major number=10"
        #命令从XXX版本开始开放到只读用户下，或非guest用户直接在CLI模式下获取回显值
        userLevel = common.getUserPrivilege(cli, py_java_env)
        if not common.isSupportVersion(cli,py_java_env) and "guest" == common.getUserPrivilege(cli, py_java_env):
            flag = common.CHECK_NOSUPPORT
            cliRet = "Login user is low-privileged, cant't support checking alarm, \nplease using super-admin or admin user to login."
            if "zh" == lang:
                errMsg += u"\n用户登录权限过低，不支持此项巡检"
            else:
                errMsg += "\nLogin user is low-privileged, cant't support checking this item"
            return (flag, cliRet, errMsg)
        else:
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            PY_LOGGER.info("Sequence[92] begin to inspect, exec cli command:"+str(cmd))
            checkRet =  common.cliExecRetWithTimeout(cli,cmd,G_RETRY_TIMES,lang)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if common.CHECK_NOPASS == checkRet[0]:
                PY_LOGGER.info("Sequence[92] inspect not pass. (system abnormal!)")
                return (common.CHECK_NOPASS, cliRet, errMsg)
            #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
            elif common.CHECK_PASS == checkRet[0]:
                return (common.CHECK_PASS, cliRet, errMsg)
            
            #命令执行后包含Command executed successfully，直接退出，巡检通过
            if common.isExecSuccess(cliRet):
                flag = common.CHECK_PASS
                return (flag, cliRet, "")
            
        #获取用户目前的登录权限，此命令guest用户在小于V100R001C99SPC900版本不支持
            #命令支持的版本为V100R001C99SPC900，小于此版本的都不支持
            
        list = cliRet.splitlines()
        if len(list)>HAS_RECORD_MIN_LINES:
            flag = common.CHECK_NOPASS
            PY_LOGGER.info("Sequence[92] inspect not pass.")
            if "zh" == lang:
                errMsg = u"\n系统存在重要告警"
            else:
                errMsg = "\nSystem exists major alarm"
            return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[92] catch except of check major alarm.")
        PY_LOGGER.error("Sequence[92] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[92] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[92] catch except of trace back:" + str(traceback.print_exc()))
        flag = common.CHECK_NOPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
