# -*- coding: UTF-8 -*-
import traceback

LANG = py_java_env.get("lang")

def execute(cli):
    '''
        硬盘域扩容导致双控交替复位问题检查： 
        背景：硬盘域扩容操作会消耗系统节点资源（节点用于标记硬盘已分配区间），当节点资源耗尽以后，将导致均衡失败，存储系统部分版本会主动发起控制器复位。（预警公告：EIT-P-S-201619）
        控制器复位触发条件：
        条件一：存储系统版本为风险版本；
        条件二：单引擎容量达到下表所示阈值；
        条件三：对系统中已创建硬盘域进行扩容（新创建硬盘域无该问题）。
        工具需要检查设备是否满足条件1,2。提前识别用户后续对硬盘域扩容可能导致控制器复位的问题。
       对于V100R001C99版本需要用户结合预警公告手动排查，工具只是在界面上提示用户该版本的检查结果为建议优化
    '''
    flag = "WARNING"
    cliRet = ""
    errMsg = ""
    
    try:
       
        cmd = "show system general"
        cliRet = cli.execCmd(cmd)
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[disk_domain_expansionCapacity] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[disk_domain_expansionCapacity] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[disk_domain_expansionCapacity] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == LANG:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)