@echo off
setlocal EnableDelayedExpansion

rem Vars
set LEGO_HOME=
call :FindLegoHome LEGO_HOME
set BASE_DIR=%LEGO_HOME%\Runtime\LegoRuntime\

set SCRIPT_FOLDER=%~dp0
set WMI_RESULT="%SCRIPT_FOLDER%wmiResult.txt"
set RESULT_FLAG="%SCRIPT_FOLDER%ResultFlag"
set WMI_COMMAND_TIMEOUT=120

rem Change code page to English
mode con cp select=437 > nul

rem
rem The main process
rem
set PARAM2=%2
if "%PARAM2%" EQU "2" (
    call :writeResultOfLogCheck 2
) else if "%PARAM2%" EQU "3" (
    call :writeResultOfResourceCheck 3
) else if "%PARAM2%" EQU "4" (
    call :writeResultOfServerCheck 4
) else (
    echo Invalid params.
)

rem fin
call :DeleteFile %WMI_RESULT%
call :DeleteFile %RESULT_FLAG%
goto :eof


rem =============================================
rem  Functions
rem =============================================

rem
rem Find the Lego's Installed Path by querying registry
rem  %1: return value, the path where Lego installed, if not found, return "n/a"
rem
:FindLegoHome
    set LegoHomeTemp=n/a

    rem Query the registry to find the Lego's log Path, it should be combined by Lego_Home and "\Runtime\LegoRuntime\"
    reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Apache Software Foundation\Procrun 2.0\LEGOService\Parameters\Log" /v "Path" 1>temp_LegoHome.txt 2>nul
    for /F "skip=2 tokens=3" %%i in (temp_LegoHome.txt) do (
        set LegoHomeTemp=%%i
    )
    
    rem If we get nothong from the upper Path, just query this registry path
    if "%LegoHomeTemp%" EQU "n/a" (
        reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Apache Software Foundation\Procrun 2.0\LEGOService\Parameters\Log" /v "Path" 1>temp_LegoHome.txt 2>nul
        for /F "skip=2 tokens=3" %%i in (temp_LegoHome.txt) do (
            set LegoHomeTemp=%%i
        )
    )
    
    rem 21 is the length of "\Runtime\LegoRuntime\"
    if "%LegoHomeTemp%" NEQ "n/a" (
        set LegoHomeTemp=%LegoHomeTemp:~0,-21%
    )
    set %1=%LegoHomeTemp%
    
    call :DeleteFile temp_LegoHome.txt
goto :eof

rem
rem Delete a file
rem
:DeleteFile
    set FileName=%~1
    if exist "%FileName%" (del /f /q "%FileName%")
goto :eof

rem
rem Main feature: check if the write-log feature is OK
rem
:writeResultOfLogCheck
    rem Beginning of xml
    echo ^<?xml version="1.0" encoding="UTF-8"?^>
    echo ^<device^>
    echo    ^<cmditem id="%1"^>
    echo        ^<item id="%10"^>
    
    if exist %BASE_DIR% (
        rem The 'checklog' Directory we will check, we just check if the checklog is the most fresh file in Five minitues
        set CHECKLOG_DIRECTORY=!BASE_DIR!\logs\ISM
        set CHECKLOG_FILE=!CHECKLOG_DIRECTORY!\checklog
        
        rem Empty the checklog file
        echo 0 > !CHECKLOG_FILE!
        
        rem Check timeout is 300s
        set MAX_TIMEOUT=300
        rem The return value of write-log check (in seconds)
        set logCheckResult=
        rem Do check, if success, return a value smaller than MAX_TIMEOUT, otherwise return MAX_TIMEOUT
        call :checkLogPrint logCheckResult !MAX_TIMEOUT!
    
        if !logCheckResult! LSS !MAX_TIMEOUT! (
            echo            ^<commonvalue type="0"^>Logging within !logCheckResult! seconds^</commonvalue^>
            echo            ^<judge^>0^</judge^>
        ) else (
            echo            ^<errorvalue type="0"^>No logging exceed 5 minute^</errorvalue^>
            echo            ^<judge^>1^</judge^>
        )
        echo        ^</item^>
        echo        ^<item id="%11"^>
        
        rem
        rem Call checkDiskVolume and do some echos
        rem
        set IsFreeSpaceEnough=
        set FreeCapacity=
        call :checkDiskVolume IsFreeSpaceEnough FreeCapacity
        if "!IsFreeSpaceEnough!"=="yes" (
            echo            ^<commonvalue type="0"^>!FreeCapacity!G^</commonvalue^>
            echo            ^<judge^>0^</judge^>
        ) else (
            echo            ^<errorvalue type="0"^>!FreeCapacity!G^</errorvalue^>
            echo            ^<judge^>1^</judge^>
        )
        
        echo        ^</item^>
        echo    ^</cmditem^>
        echo ^</device^>
    ) else (
        echo            ^<errorvalue type="0"^>ISM server not installed^</errorvalue^>
        echo            ^<judge^>1^</judge^>
        echo        ^</item^>
        echo        ^<item id="%11"^>
        echo            ^<errorvalue type="0"^>ISM server not installed^</errorvalue^>
        echo            ^<judge^>1^</judge^>
        echo        ^</item^>
        echo    ^</cmditem^>
        echo ^</device^>
    )
goto :eof

rem
rem Check free disk space of dir 'BASE_DIR'
rem  %1: return value, "yes" means enough, "no" means not enough
rem  %2: return the free capacity
rem
:checkDiskVolume
    rem Get free disk space by parsing 'dir' command result
    set DIR_RESULT=dir_result.txt
    dir %BASE_DIR% > %DIR_RESULT%
    set FreeSpace=
    for /F "skip=5 tokens=3" %%i in (!DIR_RESULT!) do (
        set FreeSpace=%%i
    )
    call :DeleteFile %DIR_RESULT%
    
    rem
    rem Now we've got the free disk space, process it
    rem
    
    rem Get rid of all commas
    set FreeSpace=%FreeSpace:,=%
    
    rem Because the batch can't calculate big number(>2^31), so we can't compare directly,
    rem  so we change this problem to compare 2 number as strings.
    rem The minimal threshold of free disk space is 5GB (5*1024*1024*1024)
    set FreeSpace_Threshold=5368709120
    
    set CompResult=
    call :IsNum1BiggerThanNum2 %FreeSpace% %FreeSpace_Threshold% CompResult
    if "%CompResult%"=="true" (
        set %1=yes
    ) else (
        set %1=no
    )
    
    rem Convert the FreeSpace's unit from Bytes to GB
    set Len_FreeSpace=
    call :GetStringLength %FreeSpace% Len_FreeSpace
    rem Because we will divide FreeSpace by 1000 later, so Len_FreeSpace should be larger than three bits in decimal
    if %Len_FreeSpace% LSS 4 (
        set FreeSpace=0.00
    ) else (
        rem divide the FreeSpace by 1000
        set FreeSpace=!FreeSpace:~0,-3!
        rem 1048576=1024*1024
        call :DivideWithFraction !FreeSpace! 1048576 2 FreeSpace
    )
    rem Return the free capacity, now the FreeSpace'unit is GB, because Bytes has divided by 1000*1024*1024
    set %2=%FreeSpace%
goto :eof

rem
rem Check log print
rem
:checkLogPrint
    rem Check interval is 5s
    set CheckInterval=5
    set /a count=%CheckInterval%
    
    :ReCheckLog
    if %count% LSS %2 (
        rem Sleep several seconds
        ping -n !CheckInterval! 127.0.0.1 > nul
        
        rem
        rem Check if the most fresh file is 'checklog'
        rem
        set DIR_RESULT=dir_result.txt
        dir /o-d /a-d %CHECKLOG_DIRECTORY% > !DIR_RESULT!
        set flag=0
        set file_Latest=
        for /F "skip=5 tokens=1,2,3*" %%i in (!DIR_RESULT!) do (
            if "!flag!" EQU "0" (
                set file_Latest=%%l
                set flag=1
            )
        )
        
        rem
        rem Compare !file_Latest! with 'checklog', if equals, continue checking,
        rem  else, return sccesss.
        rem
        if "!file_Latest!" NEQ "checklog" (
            set %1=!count!
        ) else (
            set /a count+=!CheckInterval!
            goto :ReCheckLog
        )
    ) else (
        rem Check timeout, return 'MAX_TIMEOUT'
        set %1=%2
    )
    
    rem Delete temp file
    call :DeleteFile !DIR_RESULT!
goto :eof

rem
rem Get string length
rem  %1: the input string
rem  %2: the return value
rem
:GetStringLength
    set String=%~1
    set Length=
    
    :CountLength
    if "%String%" NEQ "" (
        set /a Length+=1
        set "String=%String:~1%
        goto CountLength
    )
    
    set %2=%Length%
goto :eof

rem
rem Compare if num1 is bigger than num2
rem  %1: num1
rem  %2: num2
rem  %3: return value, "true" if num1>num2, "false" if num1<=num2
rem
:IsNum1BiggerThanNum2
    set Num1=%~1
    set Num2=%~2
    set StrLen_Num1=
    set StrLen_Num2=
    call :GetStringLength %~1 StrLen_Num1
    call :GetStringLength %~2 StrLen_Num2

    if %StrLen_Num1% GTR %StrLen_Num2% (
        set %3=true
    ) else if %StrLen_Num1% LSS %StrLen_Num2% (
        set %3=false
    ) else (
        rem String length of Num1, Num2 are the same, we compare each letters 1 by 1
        set Letter1=
        set Letter2=
        set Pos=0
        
        :CompareNextLetter
        set /a Letter1=!Num1:~%Pos%,1!
        set /a Letter2=!Num2:~%Pos%,1!
        if !Letter1! GTR !Letter2! (
            set %3=true
        ) else if !Letter1! LSS !Letter2! (
            set %3=false
        ) else (
            set /a Pos+=1
            if !Pos! LSS %StrLen_Num1% (
                goto :CompareNextLetter
            )
            set %3=false
        )
    )
goto :eof

rem
rem Main feature: check cpu&memory resource
rem
:writeResultOfResourceCheck
    echo ^<?xml version="1.0" encoding="UTF-8"?^>
    echo ^<device^>
    echo    ^<cmditem id="%1"^>
    echo        ^<item id="%10"^>
    
    rem Check memory
    set UsedMemPercent=
    set Alarm=
    call :checkMemory UsedMemPercent Alarm
    if "%Alarm%" EQU "alarm" (
        echo            ^<errorvalue type="0"^>%UsedMemPercent%%%^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        echo            ^<commonvalue type="0"^>%UsedMemPercent%%%^</commonvalue^>
        echo            ^<judge^>0^</judge^>
    )
    
    echo        ^</item^>
    echo        ^<item id="%11"^>
    
    rem Check CPU
    set CpuPercent=
    set Alarm=
    call :checkCpu CpuPercent Alarm
    if "%Alarm%" EQU "alarm" (
        echo            ^<errorvalue type="0"^>%CpuPercent%%%^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        echo            ^<commonvalue type="0"^>%CpuPercent%%%^</commonvalue^>
        echo            ^<judge^>0^</judge^>
    )
    
    echo        ^</item^>
    echo    ^</cmditem^>
    echo ^</device^>
goto :eof

rem
rem Get memory info via 'systeminfo'
rem  %1: output, value of used memory percent
rem  %2: output, alarm or not
rem
:checkMemory
    rem Call 'systeminfo'
    set MEM_RESULT=memory_result.txt
    systeminfo > %MEM_RESULT%
    
    set TotalMem=
    set FreeMem=
    
    rem Get "Total Physical Memory" in MB
    for /F "tokens=2 delims=:" %%i in ('type %MEM_RESULT% ^| findstr -C:"Total Physical Memory"') do (
        for /F "tokens=1" %%a in ("%%i") do (
            set TotalMem=%%a
            set TotalMem=!TotalMem:,=!
        )
    )
    
    rem Get "Available Physical Memory" in MB
    for /F "tokens=2 delims=:" %%i in ('type %MEM_RESULT% ^| findstr -C:"Available Physical Memory"') do (
        for /F "tokens=1" %%a in ("%%i") do (
            set FreeMem=%%a
            set FreeMem=!FreeMem:,=!
        )
    )
    
    rem Calc used memory
    set /a UsedMem=%TotalMem% - %FreeMem%
    
    rem Calc percent of used memory
    set /a UsedPercent=%UsedMem% * 1000 / %TotalMem%

    set StrLen=
    call :GetStringLength %UsedPercent% StrLen
    if "%StrLen%" EQU "3" (
        set /a UsedPercent=!UsedPercent:~0,-1!
        set %1=!UsedPercent!
        if !UsedPercent! GTR 80 (
            set %2=alarm
        ) else (
            set %2=noalarm
        )
    ) else if "%StrLen%" EQU "2" (
        set UsedPercent=!UsedPercent:~0,-1!
        set %1=!UsedPercent!
        set %2=noalarm
    ) else if "%StrLen%" EQU "1" (
        set UsedPercent=0.!UsedPercent!
        set %1=!UsedPercent!
        set %2=noalarm
    ) else (
        set %1=--
        set %2=--
    )
    
    rem Delete temp file
    call :DeleteFile %MEM_RESULT%
goto :eof

rem
rem Get cpu info via 'wmic'
rem  %1: output, value of used cpu percent
rem  %2: output, alarm or not
rem
:checkCpu
    set WmiResult=0
    call :CallWmiCommand "wmic CPU get loadpercentage" WmiResult

    if %WmiResult%==0 (
        set %1=n/a
        set %2=noalarm
    ) else (
        set CpuPercent=
        set flag=0
        for /F "usebackq skip=1 tokens=1" %%i in (`type %WMI_RESULT%`) do (
            if "!flag!"=="0" (
                set flag=1
                set /a CpuPercent=%%i
            )
        )
        
        if !CpuPercent! GTR 80 (
            set %1=!CpuPercent!
            set %2=alarm
        ) else (
            set %1=!CpuPercent!
            set %2=noalarm
        )
    )
goto :eof

rem
rem Main feature: Check several Java app status
rem
:writeResultOfServerCheck
    echo ^<?xml version="1.0" encoding="UTF-8"?^>
    echo ^<device^>
    echo    ^<cmditem id="%1"^>
    
    rem checkJVMRunning
    echo        ^<item id="%10"^>
    set ProcessId=
    call :checkJVMRunning ProcessId
    if "%ProcessId%" EQU "n/a" (
        echo            ^<errorvalue type="0"^>ISM server not running^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        echo            ^<commonvalue type="0"^>PID %ProcessId%^</commonvalue^>
        echo            ^<judge^>0^</judge^>
    )
    echo        ^</item^>
    
    rem checkDeadLock
    echo        ^<item id="%11"^>
    if "%ProcessId%" EQU "n/a" (
        rem Not running
        echo            ^<errorvalue type="0"^>ISM server not running^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        set RetValue=
        call :checkDeadLock %ProcessId% RetValue
        if "!RetValue!" EQU "hasdeadlock" (
            rem Has deadlock
            echo            ^<errorvalue type="0"^>Found^</errorvalue^>
            echo            ^<judge^>1^</judge^>
        ) else (
            rem No deadlock
            echo            ^<commonvalue type="0"^>Not found^</commonvalue^>
            echo            ^<judge^>0^</judge^>
        )
    )
    echo        ^</item^>
    
    rem checkThreadNumber
    echo        ^<item id="%12"^>
    if "%ProcessId%" EQU "n/a" (
        rem Not running
        echo            ^<errorvalue type="0"^>ISM server not running^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        set ThreadCount=
        call :checkThreadNumber ThreadCount
        set /a ThreadCount=!ThreadCount!
        if !ThreadCount! LSS 500 (
            rem Normal status
            echo            ^<commonvalue type="0"^>!ThreadCount!^</commonvalue^>
            echo            ^<judge^>0^</judge^>
        ) else (
            rem Abnormal status
            echo            ^<errorvalue type="0">!ThreadCount!^</errorvalue^>
            echo            ^<judge^>1^</judge^>
        )
    )
    echo        ^</item^>
    
    rem checkIsmHttpPort
    echo        ^<item id="%13"^>
    set PortNum=
    call :checkIsmHttpOrHttpsPort "http" PortNum
    if "%PortNum%" EQU "notrunning" (
        rem ISM not running
        echo            ^<errorvalue type="0"^>ISM server not running^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else if "%PortNum%" EQU "n/a" (
        rem Port not opened by our process
        echo            ^<errorvalue type="0"^>^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        rem Port opened as we wish
        echo            ^<commonvalue type="0"^>Http port %PortNum%^</commonvalue^>
        echo            ^<judge^>0^</judge^>
    )
    echo        ^</item^>
    
    rem checkIsmHttpsPort
    echo        ^<item id="%14"^>
    set PortNum=
    call :checkIsmHttpOrHttpsPort "https" PortNum
    if "%PortNum%" EQU "notrunning" (
        rem ISM not running
        echo            ^<errorvalue type="0"^>ISM server not running^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else if "%PortNum%" EQU "n/a" (
        rem Port not opened by our process
        echo            ^<errorvalue type="0"^>^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        rem Port opened as we wish
        echo            ^<commonvalue type="0"^>Https port %PortNum%^</commonvalue^>
        echo            ^<judge^>0^</judge^>
    )
    echo        ^</item^>
    
    rem checkJVMMemory
    echo        ^<item id="%15"^>
    set MemUsedInKB=
    call :checkJVMMemory MemUsedInKB
    if "%MemUsedInKB%" EQU "notrunning" (
        rem ISM not running
        echo            ^<errorvalue type="0"^>ISM server not running^</errorvalue^>
        echo            ^<judge^>1^</judge^>
    ) else (
        rem Format string for display
        set strMemUsed=
        if %MemUsedInKB% LSS 1048576 (
            rem Less than 1GB
            set RetValue=
            call :DivideWithFraction %MemUsedInKB% 1024 2 RetValue
            set strMemUsed=!RetValue!M
        ) else (
            rem More than 1GB
            set RetValue=
            call :DivideWithFraction %MemUsedInKB% 1048576 2 RetValue
            set strMemUsed=!RetValue!G
        )

        if %MemUsedInKB% LSS 2097152 (
            rem Less than 2GB usage, OK
            echo            ^<commonvalue type="0"^>!strMemUsed!^</commonvalue^>
            echo            ^<judge^>0^</judge^>
        ) else (
            rem More than 2GB usage, error
            echo            ^<errorvalue type="0"^>!strMemUsed!^</errorvalue^>
            echo            ^<judge^>1^</judge^>
        )
    )
    echo        ^</item^>
    
    echo    ^</cmditem^>
    echo ^</device^>
goto :eof

:GetRidOfSpacesRightside
    set tmpString=%~1
    
    :intercept_right
    if "%tmpString:~-1%"==" " (
        set "tmpString=%tmpString:~0,-1%"
        goto intercept_right
    )
    
    set %~2=%tmpString%
goto :eof

rem
rem Check if 'equinox.jar' is running on JVM
rem  %1: output, return value of javaId(e.g. processId of 'javaw.exe') or "n/a"(if 'equinox.jar' not found)
rem
:checkJVMRunning
    set %1=n/a
    
    rem
    rem Execute a WMI command to get information we need
    rem The original Command which is execute in CMD WINDOW is:
    rem    wmic process where "name = 'legosrv.exe'" get processid
    rem
    set WmiResult=0
    call :CallWmiCommand "wmic process where name='legosrv.exe' get processid" WmiResult

    if %WmiResult%==0 (
        set %1=n/a
    ) else (
        for /F "usebackq skip=1 tokens=1" %%i in (`type %WMI_RESULT%`) do (
            set PID=%%i
            call :GetRidOfSpacesRightside !PID! PID
            set %1=!PID!
        )
    )
goto :eof

rem
rem Check if there is any deadlocks
rem  %1: ProcessId we need to check
rem  %2: Return value, can be: "hasdeadlock"/"nodeadlock"
rem
:checkDeadLock
    set DEADLOCK_CHECKFILE=tmpDeadlock.txt
    rem Check deadlock
    jstack -l %~1 > %DEADLOCK_CHECKFILE% 2>nul
    if exist %DEADLOCK_CHECKFILE% (
        findstr -C:"Java-level\\ deadlock\\:" %DEADLOCK_CHECKFILE% > nul
        if !errorlevel! EQU 0 (
            set %2=hasdeadlock
        ) else (
            set %2=nodeadlock
        )
        
        rem Delete temp file
        call :DeleteFile %DEADLOCK_CHECKFILE%
    ) else (
        set %2=nodeadlock
    )
goto :eof

rem
rem Check thread number(in fact is count of threads)
rem  %1: Return value of thread count
rem The original Command which is execute in CMD WINDOW is:
rem wmic process where "name = 'legosrv.exe'" get threadcount
rem
:checkThreadNumber
    set %1=0
    
    rem Get threads count
    set WmiResult=0
    call :CallWmiCommand "wmic process where name='legosrv.exe' get threadcount" WmiResult

    if %WmiResult%==0 (
        set %1=0
    ) else (
        for /F "usebackq skip=1 tokens=1" %%i in (`type %WMI_RESULT%`) do (
            set CNT=%%i
            call :GetRidOfSpacesRightside !CNT! CNT
            set %1=!CNT!
        )
    )
goto :eof

rem
rem Check ISM http(s) port
rem  %1: "http" or "https"
rem  %2: Return value, can be "notrunning"/"n/a"/[portnumber]
rem
:checkIsmHttpOrHttpsPort
    rem If 'server.xml' not exist, return
    set SERVER_XML=%LEGO_HOME%\Runtime\Tomcat6\conf\server.xml
    if not exist !SERVER_XML! (
        set %2=n/a
        goto :eof
    )
    
    rem Get process id
    set WmiResult=0
    call :CallWmiCommand "wmic process where name='legowebsrv.exe' get processid" WmiResult

    set PID=
    if %WmiResult%==0 (
        set PID=
    ) else (
        for /F "usebackq skip=1 tokens=1" %%i in (`type %WMI_RESULT%`) do (
            set PID=%%i
            call :GetRidOfSpacesRightside !PID! PID
        )
    )
    
    rem
    rem Get http (or https) port info
    rem
    if "%PID%" NEQ "" (
        set Cmd=
        if "%~1" EQU "http" (
            set Cmd=type %SERVER_XML% ^| findstr "HTTP/1.1" ^| findstr "redirectPort" ^| findstr "^<Connector port"
        ) else if "%~1" EQU "https" (
            set Cmd=type %SERVER_XML% ^| findstr "org.apache.coyote.http11.Http11Protocol" ^| findstr "https" ^| findstr "^<Connector port"
        ) else (
            rem Err, set return value as "n/a"
            set %2=n/a
            goto :eof
        )
        
        set Port=
        rem ==================================================================
        rem  Notice! to use " as delims, we have to write some strange code..
        rem ==================================================================
        for /F tokens^=2^ delims^=^" %%i in ('!Cmd!') do (
            set Port=%%i
            
            rem Call 'netstat' to get PID who open this port
            set NETSTAT_FILE=tmpNetstat.txt
            set Cmd=netstat -o -n -a ^| findstr "TCP"
            for /F "tokens=3,7 delims=: " %%a in ('!Cmd!') do (
                if "%%a" EQU "!Port!" (
                    if "%%b" EQU "%PID%" (
                        rem Set return value as port number
                        set %2=!Port!
                        goto :eof
                    )
                )
            )
            
            rem Delete temp file
            call :DeleteFile !NETSTAT_FILE!
            
            rem Set return value as "n/a"
            set %2=n/a
        )
    ) else (
        rem Process not found
        set %2=notrunning
    )
goto :eof

rem
rem Check memory used by ISM
rem  %1: Return value of memory used (in KB), or "notrunning"
rem
:checkJVMMemory
    rem
    rem Execute a WMI command to get process id
    rem Command is:
    rem    wmic process where "name = 'legosrv.exe'" get processid
    rem
    set WmiResult=0
    call :CallWmiCommand "wmic process where name='legosrv.exe' get processid" WmiResult

    set PID=
    if %WmiResult%==0 (
        set PID=
    ) else (
        for /F "usebackq skip=1 tokens=1" %%i in (`type %WMI_RESULT%`) do (
            set PID=%%i
            call :GetRidOfSpacesRightside !PID! PID
        )
    )
    
    rem
    rem Process due to process id
    rem
    if "%PID%" NEQ "" (
        rem
        rem Get memory used by this process
        rem
        for /F "tokens=4,5" %%i in ('tasklist ^| findstr -C:" %PID% "') do (
            rem Get memory in KB
            set MemInKB=
            if "%%j" NEQ "K" (
                set MemInKB=%%j
            ) else (
                set MemInKB=%%i
            )
            rem Get rid of all commas
            set MemInKB=!MemInKB:,=!
            
            set %1=!MemInKB!
        )
    ) else (
        set %1=notrunning
    )
goto :eof

rem
rem Divide 2 integers with outputing the fractional part
rem (To understand the algorithm, try doing this job on paper with a pen...)
rem  %1: vA
rem  %2: vB
rem  %3: number of fractional part to output
rem  %4: Return value of vA/vB
rem
:DivideWithFraction
    set vA=%1
    set vB=%2
    
    rem
    rem Main algorithm begins
    rem
    set Ret=
    set flag=false
    set /a FractionCount=0
    
    rem Test if vA is greater than vB
    :TestIfvAGtrvB
    if !vA! LSS !vB! (
        rem The result must be like "0.xxx"
        if "!Ret!" EQU "" (
            set Ret=0.
            set flag=true
        )
        
        rem Add a '0' at the end of vA and compare again
        set vA=!vA!0
        if !vA! LSS !vB! (
            set Ret=!Ret!0
            
            set /a FractionCount+=1
            if !FractionCount! GEQ %3 (
                set %4=!Ret!
                goto :eof
            )
        )
        
        goto :TestIfvAGtrvB
    )
    
    rem Now vA is greater than vB, we do the division to get the "integer part"
    set /a IntegerPart=%vA% / %vB%
    if "%Ret%" EQU "" (
        set Ret=%IntegerPart%.
        set flag=true
    ) else (
        set Ret=%Ret%%IntegerPart%
        if "!flag!" EQU "true" (
            set LenOfFractional=
            call :GetStringLength %IntegerPart% LenOfFractional
            set /a FractionCount+=!LenOfFractional!
            if !FractionCount! GEQ %3 (
                set %4=!Ret!
                goto :eof
            )
        )
    )
    
    rem
    rem vA minus vB*IntegerPart as the new vA, and continue the algorithm
    rem
    set /a Remains=%vA% - %vB% * %IntegerPart%
    if %Remains% EQU 0 (
        rem
        rem Check if the length of fractional part is enough, if not, add several "0"s
        rem
        :TestIfFractionalEnough
        for /F "tokens=1,2 delims=." %%i in ("!Ret!") do (
            if "%%j" EQU "" (
                set Ret=!Ret!0
                goto :TestIfFractionalEnough
            )
            
            set LenOfFractional=
            call :GetStringLength %%j LenOfFractional
            if !LenOfFractional! LSS %3 (
                set Ret=!Ret!0
                goto :TestIfFractionalEnough
            )
        )

        set %4=!Ret!
        goto :eof
    )
    rem OK, continuing the algorithm
    set vA=%Remains%
    goto :TestIfvAGtrvB
goto :eof

rem
rem Call a WMI command and wait for the result
rem  %1: wmi command
rem  %2: return value, 0-failure, 1-success
rem
:CallWmiCommand
    call :DeleteFile %RESULT_FLAG%
    
    set wmiCmd=%1
    start /D "%SCRIPT_FOLDER%" WmicCaller.bat %wmiCmd%
    
    rem Sleep for a while, waiting for result of the wmi command
    set /a loopcount=0
    :WaitForWmiResult
    ping -n 2 127.0.0.1 > nul
    if exist %RESULT_FLAG% (
        set %2=1
        goto :eof
    ) else (
        if !loopcount! GTR %WMI_COMMAND_TIMEOUT% (
            set %2=0
            goto :eof
        )
        set /a loopcount+=1
        goto :WaitForWmiResult
    )
goto :eof
