#!/bin/bash


CMD_FILE=./cmd_tmp_file
UP_EXIST=0
PACKAGE_TYPE=""
UP_VERSION=""
UP_SERVICE=""
OS_MENULST_FILE=""
OS_RELEASE_FILE=""

t270s_UltraPathFlagBegin="###UltraPath code,please don't change this###begin###"
t270s_UltraPathFlagEnd="###UltraPath code,please don't change this###end###"
t270s_targetFile="/etc/rc.d/rc.sysinit"
R2C00=200000
R3C00=300000
R5C01=501050
R6C00=601000
R8C00=801000
R8C20=803000
PRINT_LINE=100

. ./c10s_pub.sh

HOST_00_ChkUltraPathExist()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=1
        WRITE_XML_ERROR 0 "INFO:Not install UltraPath"
    else
        WRITE_XML_COMMON 0 "[upexist]:yes"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_01_ChkUltraPathVersion()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    if [ "${upVersion}" -lt "${R2C00}" ]; then
        isPass=4
    fi
    
    commonResult="UltraPath version is ${c10s_upVersion}"
    WRITE_XML_COMMON 0 ":${commonResult}"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_02_ChkUpServer()
{
    errResult=""
    isPass=0
    local upVersion=""
    local ret
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ "${upVersion}" -lt "${R5C01}" ]
    then
        isPass=3;
        errResult="The version ${c10s_upVersion} does not have a upservice"
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    c10s_isModLoaded
    if [ $? -eq 0 ]; then
        isPass=3;
        errResult="UlraPath service is not running."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    psResult=`echo "~ # ps -ef | grep -v 'grep' | grep upservice"; ps -ef | grep -v 'grep' | grep upservice`
    WRITE_XML_COMMON 0 ":${psResult}"
    
    ps -ef|grep -v grep|grep upservice > /dev/null 2>&1
    
    if [ $? -ne 0 ]; then
        isPass=1
        errResult="upservice is not running"
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_03_ChkUpFiles()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ "${upVersion}" -lt "${R2C00}" ]; then
        isPass=3
        errResult="The version of UltraPath is too low, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    if [ ${upVersion} -ge ${R5C01} ]
    then
        which upRescan >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=1
            errResult="Not found file: upRescan."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
        
        which upadmin >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=1
            errResult="Not found file: upadmin."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
        
        if [ ! -d /UltraPath ]; then
            isPass=1
            errResult="Not found dir: /UltraPath."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
        
        if [ ${upVersion} -ge ${R8C00} ] && [ ! -f /etc/user_cfg.xml ]; then
            isPass=1
            errResult="Not found file: user_cfg.xml."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
        
        if [ ! -f /etc/UltraPath.packages.info ]; then
            isPass=1
            errResult="Not found file: UltraPath.packages.info."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    fi

    if [ ${upVersion} -ge ${R3C00} ]; then
        which upadm >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=1
            errResult="Not found file: upadm."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    fi
    
    which hot_add >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        isPass=1
        errResult="Not found file: hot_add."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi
    
    if [ ! -f /etc/up.conf ]; then
        isPass=1
        errResult="Not found file: up.conf."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi
    
    if [ ${isPass} -eq 0 ]; then
        errResult="The UltraPath files are normal."
        WRITE_XML_ERROR 0 ":${errResult}"
    fi                

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_04_ChkUpConfig()
{
    errResult=""
    isPass=0
    local upVersion=""
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ "${upVersion}" -lt "${R2C00}" ]; then
        isPass=3
        errResult="The version of UltraPath is too low, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    if [ ${upVersion} -lt ${R5C01} ]
    then
        titleCount=0
        tmpCount=0
        for menulst in "${c10s_supportMenuLst[@]}"
        do
            if [ -f "${menulst}" ]; then
                tmpCount=`cat ${menulst} | grep -c -E -i "title[[:blank:]]*Linux[[:blank:]]*with[[:blank:]]*(UltraPath|UPforLinux|UpforLinux|ultrapath)|label[[:blank:]]*=[[:blank:]]*ultrapath"`
                let titleCount=titleCount+tmpCount
            fi
        done
        
        if [ ${titleCount} -eq 0 ]; then
            isPass=1
            errResult="UltraPath title is missing."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    elif [ -f /etc/UltraPath.packages.info ] && [ "`cat /etc/UltraPath.packages.info | grep "t140s_solutionType" | awk -F "=" '{print $2}'`" = "mkinitrd" ]
    then
        titleCount=0
        tmpCount=0
        for menulst in "${c10s_supportMenuLst[@]}"
        do
            if [ -f "${menulst}" ]; then
                tmpCount=`cat ${menulst} | grep -c -E -i "title[[:blank:]]*Linux[[:blank:]]*with[[:blank:]]*(UltraPath|UPforLinux|UpforLinux|ultrapath)|label[[:blank:]]*=[[:blank:]]*ultrapath"`
                let titleCount=titleCount+tmpCount
            fi
        done
        
        if [ ${titleCount} -eq 0 ]; then
            isPass=1
            errResult="UltraPath title is missing."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    elif [ "`cat /etc/UltraPath.packages.info | grep "t140s_solutionType" | awk -F "=" '{print $2}'`" = "service" ] && [ `which systemctl > /dev/null 2>&1; echo $?` -ne 0 ]
    then
        c10s_getOSReleaseFile
        if [ "${c10s_OSReleaseFile}" = "" ]; then
            errResult="Not found the release file, skip the rc.sysinit check."
            WRITE_XML_ERROR 0 ":${errResult}"
        else
            if [ `cat ${c10s_OSReleaseFile} | grep -c -E "Red Hat|CentOS|Oracle Linux|Asianux"` -gt 0 ]; then
                ret=`grep -E -c "(${t270s_UltraPathFlagBegin}|${t270s_UltraPathFlagEnd})" "${t270s_targetFile}"`
                if [ $ret -eq 2 ]; then
                    isPass=0
                else
                    isPass=1
                    errResult="rc.sysinit is destroyed."
                    WRITE_XML_ERROR 0 ":${errResult}"
                fi
            fi
        fi
    fi
    
    if [ ${isPass} -eq 0 ]; then
        commonResult="The config files of UltraPath are normal."
        WRITE_XML_COMMON 0 ":${commonResult}"
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_05_ChkUpLogSpace()
{
    errResult=""
    isPass=0
    
    local log_size=0
    local upVersion=""
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    if [ ${upVersion} -lt ${R5C01} ]
    then
        isPass=3
        errResult="The version ${c10s_upVersion} does not have log directory, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi

    if [ -d /opt/UltraPath/log/kernel_log ]; then
        duResult=`echo "~ # du -sk /opt/UltraPath/log/kernel_log"; du -sk /opt/UltraPath/log/kernel_log`
        WRITE_XML_COMMON 0 ":${duResult}"
        log_size=`du -sk /opt/UltraPath/log/kernel_log|awk '{print $1}'`
    else
        isPass=3
        commonResult="No compress log directory"
        WRITE_XML_COMMON 0 ":${commonResult}"
    fi

    if [ ${log_size} -gt 262144 ]; then
        isPass=4
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

DISK_CHK_STR="KB|MB|GB|TB"

HOST_06_ChkUpDiskStatus()
{
    errResult=""
    isPass=0
    
    local upVersion=""
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    rm -rf  ${CMD_FILE}
    touch ${CMD_FILE}
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ "${upVersion}" -lt "${R2C00}" ]; then
        isPass=3
        errResult="The version of UltraPath is too low, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    if [ ${upVersion} -lt ${R5C01} ]
    then
        which upadm >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=3
            errResult="~ # upadm show version"
            WRITE_XML_ERROR 0 ":${errResult}"
            errResult="-bash: upadm: command not found"
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
    
        arrayResult=`echo "~ # upadm show array"; upadm show array`
        WRITE_XML_COMMON 0 ":${arrayResult}"
        
        for arrayid in `upadm show array | grep -E '^[[:blank:]]*[[:digit:]]' | awk -F " " '{print $1}'`
        do
            lunResult=`echo "~ # upadm show lun array=${arrayid}"; upadm show lun array=${arrayid} | head -n 100`
            lineCount=`upadm show lun array=${arrayid} | wc -l`
            if [ ${lineCount} -gt 100 ]; then
                lunResult=`echo -e " ${lunResult} \n .................................."`
            fi
            WRITE_XML_COMMON 0 ":${lunResult}"
            upadm show lun array=${arrayid} | grep -E -A 3 "WWN:.*LUN[[:blank:]]Name" >> ${CMD_FILE}
        done

        CHK_FLAG=`cat ${CMD_FILE}|wc -l`
        if [ ${CHK_FLAG} -eq 0 ]; then
            isPass=3
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        else
            abnormal=`cat ${CMD_FILE}| grep -E -i "OPTIMAL_NEED_CHECK|FAILED"`
            if [ -n "${abnormal}" ]; then
                isPass=1
                errResult="Some LUNs managed by UltraPath is abnormal."
                WRITE_XML_ERROR 0 ":${errResult}"
            fi
        fi
    else
    
        c10s_isModLoaded
        if [ $? -eq 0 ]; then
            isPass=3;
            errResult="UlraPath service is not running."
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        which upadmin >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=3
            errResult="~ # upadmin show version"
            WRITE_XML_ERROR 0 ":${errResult}"
            errResult="-bash: upadmin: command not found"
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi

        if [ ${upVersion} -lt ${R8C20} ]; then
            lineCount=`upadmin show vlun | wc -l`
            lunResult=`echo "~ # upadmin show vlun"; upadmin show vlun | head -n 100`
            if [ ${lineCount} -gt 100 ]; then
                lunResult=`echo -e " ${lunResult} \n .................................."`
            fi
            WRITE_XML_COMMON 0 ":${lunResult}"
            upadmin show vlun | grep -E -i ${DISK_CHK_STR} > ${CMD_FILE}
        else
            lineCount=`upadmin show vlun type=all | wc -l`
            lunResult=`echo "~ # upadmin show vlun type=all"; upadmin show vlun type=all | head -n 100`
            if [ ${lineCount} -gt 100 ]; then
                lunResult=`echo -e " ${lunResult} \n .................................."`
            fi
            WRITE_XML_COMMON 0 ":${lunResult}"
            upadmin show vlun type=all | grep -E -i ${DISK_CHK_STR} > ${CMD_FILE}
        fi
        
        CHK_FLAG=`cat ${CMD_FILE}|wc -l`
        if [ ${CHK_FLAG} -eq 0 ]; then
            isPass=3
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        
        abnormal=`cat ${CMD_FILE} | grep -E -i "fault|degraded"`
        if [ -n "${abnormal}" ]; then
            isPass=1
            errResult="Some LUNs managed by UltraPath is abnormal."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    fi
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_07_ChkUpPathStatus()
{
    errResult=""
    isPass=-1
    
    local pathCount=0
    local normalCount=0
    
    
    WRITE_XML_SUBCMD_HEADER $1

    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi

    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ "${upVersion}" -lt "${R2C00}" ]; then
        isPass=3
        errResult="The version of UltraPath is too low, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi

    rm -rf  ${CMD_FILE}
    touch ${CMD_FILE}

    if [ ${upVersion} -lt ${R5C01} ]; then
        
        which upadm >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=3
            errResult="~ # upadm show version"
            WRITE_XML_ERROR 0 ":${errResult}"
            errResult="-bash: upadm: command not found"
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        arrayResult=`echo "~ # upadm show array"; upadm show array`
        WRITE_XML_COMMON 0 ":${arrayResult}"
        
        if [ `upadm show array | grep -E '^[[:blank:]]*[[:digit:]]' | wc -l` -eq 0 ]; then
            isPass=3
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        for arrayid in `upadm show array | grep -E '^[[:blank:]]*[[:digit:]]' | awk -F " " '{print $1}'`
        do
            lunResult=`echo "~ # upadm show lun array=${arrayid}"; upadm show lun array=${arrayid} | head -n 100`
            lineCount=`upadm show lun array=${arrayid} | wc -l`
            if [ ${lineCount} -gt 100 ]; then
                lunResult=`echo -e " ${lunResult} \n .................................."`
            fi
            WRITE_XML_COMMON 0 ":${lunResult}"
            upadm show lun array=${arrayid} > ${CMD_FILE}
            
            pathCount=`cat ${CMD_FILE} | grep -c -E "hostId:.*targetId.*channelId"`
            normalCount=`cat ${CMD_FILE} | grep -E -B 1 "hostId:.*targetId.*channelId" | grep -c "OPTIMAL"`
            if [ ${pathCount} -eq 0 ]; then
                if [ ${isPass} -ne 0 ]; then
                    isPass=3
                fi
            elif [ ${normalCount} -lt ${pathCount} ]; then
                isPass=1
                errResult="Some paths managed by UltraPath is abnormal."
                WRITE_XML_ERROR 0 ":${errResult}"
                break
            else
                isPass=0
            fi
        done 
    else
        c10s_isModLoaded
        if [ $? -eq 0 ]; then
            isPass=3;
            errResult="UlraPath service is not running."
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        which upadmin >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=3
            errResult="~ # upadmin show version"
            WRITE_XML_ERROR 0 ":${errResult}"
            errResult="-bash: upadmin: command not found"
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        pathResult=`echo "~ # upadmin show path"; upadmin show path`
        WRITE_XML_COMMON 0 ":${pathResult}"
        upadmin show path | grep -E "^[[:blank:]]*[[:digit:]]" > ${CMD_FILE}
        
        CHK_FLAG=`cat ${CMD_FILE}|wc -l`
        if [ ${CHK_FLAG} -eq 0 ]; then
            isPass=3
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        
        PATH_ID=`cat ${CMD_FILE}|awk '{print $1}'`
        
        for i in ${PATH_ID}
        do
            upadmin show path id=${i} > ${CMD_FILE}
            PATH_STATUS=`cat ${CMD_FILE}| grep "Path State" |awk -F: '{print $2}'`
            PATH_STATUS=$(echo ${PATH_STATUS})
            
            if [ "${PATH_STATUS}" != "Normal" ]; then
                isPass=1
                errResult="Some paths managed by UltraPath is abnormal."
                WRITE_XML_ERROR 0 ":${errResult}"
                break
            fi
        done
    fi
    if [ ${isPass} -eq -1 ];then
        isPass=0
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_08_ChkUpRedundancyController()
{
    errResult=""
    isPass=-1
    
    local CtlCount=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ "${upVersion}" -lt "${R2C00}" ]; then
        isPass=3
        errResult="The version of UltraPath is too low, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    rm -rf  ${CMD_FILE}
    touch ${CMD_FILE}
    
    if [ ${upVersion} -lt ${R5C01} ]; then
        
        which upadm >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=3
            errResult="~ # upadm show version"
            WRITE_XML_ERROR 0 ":${errResult}"
            errResult="-bash: upadm: command not found"
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        arrayResult=`echo "~ # upadm show array"; upadm show array`
        WRITE_XML_COMMON 0 ":${arrayResult}"
        
        if [ `upadm show array | grep -E '^[[:blank:]]*[[:digit:]]' | wc -l` -eq 0 ]; then
            isPass=3
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        for arrayid in `upadm show array | grep -E '^[[:blank:]]*[[:digit:]]' | awk -F " " '{print $1}'`
        do
            lunResult=`echo "~ # upadm show lun array=${arrayid}"; upadm show lun array=${arrayid} | head -n 100`
            lineCount=`upadm show lun array=${arrayid} | wc -l`
            if [ ${lineCount} -gt 100 ]; then
                lunResult=`echo -e " ${lunResult} \n .................................."`
            fi
            WRITE_XML_COMMON 0 ":${lunResult}"

            CtlCount=`upadm show lun array=${arrayid} | grep -E "ControllerFailed: N" | wc -l`
            if [ ${CtlCount} -eq 0 ]; then
                if [ ${isPass} -ne 0 ]; then
                    isPass=3
                fi
            elif [ ${CtlCount} -eq 1 ]; then
                isPass=1
                errResult="Some storage devices managed by UltraPath only connect single controller."
                WRITE_XML_ERROR 0 ":${errResult}"
                break
            else
                isPass=0
            fi
        done
    else
        c10s_isModLoaded
        if [ $? -eq 0 ]; then
            isPass=3;
            errResult="UlraPath service is not running."
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        which upadmin >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=3
            errResult="~ # upadmin show version"
            WRITE_XML_ERROR 0 ":${errResult}"
            errResult="-bash: upadmin: command not found"
            WRITE_XML_ERROR 0 ":${errResult}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        arrayResult=`echo "~ # upadmin show array"; upadmin show array`
        WRITE_XML_COMMON 0 ":${arrayResult}"
        
        if [ `upadmin show array | grep -E '^[[:blank:]]*[[:digit:]]' | wc -l` -eq 0 ]; then
            isPass=3
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0
        fi
        
        for arrayid in `upadmin show array | grep -E '^[[:blank:]]*[[:digit:]]' | awk -F " " '{print $1}'`
        do
            upadmin show array id=${arrayid} > ${CMD_FILE}
            pathResult=`echo "~ # upadmin show array id=${arrayid}"; upadmin show array id=${arrayid}`
            WRITE_XML_COMMON 0 ":${pathResult}"
            
            begin=0
            end=0
            CtlCount=0
            tmpCount=0
            
            for line in `cat ${CMD_FILE} | grep -n "Controller" | awk -F ":" '{print $1}'`
            do
                if [ ${begin} -eq 0 ]; then
                    begin=${line}
                    continue
                fi
                end=${line}
                tmpCount=`cat ${CMD_FILE} | sed -n "${begin},${end}p" | grep -i -c -E "normal|degraded|degradation"`
                if [ ${tmpCount} -ne 0 ]; then
                    let CtlCount=CtlCount+1
                fi
                begin=${end}
            done
            end=`cat ${CMD_FILE} | wc -l`
            tmpCount=`cat ${CMD_FILE} | sed -n "${begin},${end}p" | grep -i -c -E "normal|degraded|degradation"`
            if [ ${tmpCount} -ne 0 ]; then
                let CtlCount=CtlCount+1
            fi

            if [ ${CtlCount} -eq 0 ]; then
                if [ ${isPass} -ne 0 ]; then
                    isPass=3
                fi
            elif [ ${CtlCount} -eq 1 ]; then
                isPass=1
                errResult="Some storage devices managed by UltraPath only connect single controller."
                WRITE_XML_ERROR 0 ":${errResult}"
                break
            else
                isPass=0
            fi
        done
    fi
    
    if [ ${isPass} -eq -1 ];then
        isPass=0
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_11_ChkHcSingleDisk()
{
    errResult=""
    isPass=0
    
    local hypermetroCount=0
    
    WRITE_XML_SUBCMD_HEADER $1

    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    
    if [ ${upVersion} -lt ${R8C20} ]
    then
        isPass=3
        errResult="The UltraPath version is ${c10s_upVersion}, it cannot support hypermetro."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    c10s_isModLoaded
    if [ $? -eq 0 ]; then
        isPass=3;
        errResult="UlraPath service is not running."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi

    which upadmin >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        isPass=3
        errResult="~ # upadmin show version"
        WRITE_XML_ERROR 0 ":${errResult}"
        errResult="-bash: upadmin: command not found"
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    rm -rf  ${CMD_FILE}
    touch ${CMD_FILE}

    lineCount=`upadmin show vlun type=hypermetro | wc -l`
    hypermetroResult=`echo "~ # upadmin show vlun type=hypermetro"; upadmin show vlun type=hypermetro | head -n 100`
    if [ ${lineCount} -gt 100 ]; then
        hypermetroResult=`echo -e " ${hypermetroResult} \n .................................."`
    fi
    WRITE_XML_COMMON 0 ":${hypermetroResult}"

    upadmin show vlun type=hypermetro | grep -E -i ${DISK_CHK_STR} 2> /dev/null > ${CMD_FILE}
    
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi  
    
    VLUN_ID=`cat ${CMD_FILE}|awk '{print $1}'|sort|uniq`
    
    for i in ${VLUN_ID}
    do
        LUN_WWN_NUM=`upadmin show vlun id=${i} type=hypermetro | grep "LUN WWN"|wc -l`
        if [ ${LUN_WWN_NUM} -ne 2 ]; then
            isPass=1
        fi
        let hypermetroCount=hypermetroCount+1
        if [ ${hypermetroCount} -lt 20 ]; then
            hypermetroResult=`echo "~ # upadmin show vlun id=${i} type=hypermetro"; upadmin show vlun id=${i} type=hypermetro`
            WRITE_XML_COMMON 0 ":${hypermetroResult}"
        fi
    done
    
    if [ `cat ${CMD_FILE} | awk '{print $1}'|sort|uniq| wc -l` -gt 20 ];then
        hypermetroResult=".................................."
        WRITE_XML_COMMON 0 ":${hypermetroResult}"
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_UltraPathChkItem()
{
    WRITE_XML_CMD_HEADER $1
    
    case $1 in
        100)
        HOST_00_ChkUltraPathExist "0"        
        ;;
        101)
        HOST_01_ChkUltraPathVersion "0"
        ;;
        102)
        HOST_02_ChkUpServer "0"
        ;;
        103)
        HOST_03_ChkUpFiles "0" 
        ;;
        104)
        HOST_04_ChkUpConfig "0" 
        ;;
        105)
        HOST_05_ChkUpLogSpace "0"
        ;;
        106)
        HOST_06_ChkUpDiskStatus "0"
        ;;
        107)
        HOST_07_ChkUpPathStatus "0"
        ;;
        108)
        HOST_08_ChkUpRedundancyController "0"
        ;;
        109)
        HOST_09_ChkThirdMP "0"
        ;;
        110)
        HOST_10_ChkOsVersion "0"
        ;;
        111)        
        HOST_11_ChkHcSingleDisk "0"
        ;;
        *)
        echo "No this type"
        ;;
    esac

    WRITE_XML_CMD_TAIL         
}