#!/bin/bash

. ./c10s_pub.sh

R8C50SPC500=806063

# Ƿ޸ȷûз1,
check_openIscsi()
{
    local confFile=""
    local ret1
    local ret2
    local ret=0
    
    if [ -f /etc/iscsi/iscsid.conf ]
    then
        confFile="/etc/iscsi/iscsid.conf"
    elif [ -f /etc/iscsid.conf ]
    then
        confFile="/etc/iscsid.conf"
    else
        WRITE_XML_COMMON 0 "open-iscsi conf file not found"
        return 0
    fi
    
    ret1=`grep -E -c "^[[:blank:]]*node.startup[[:blank:]]*=[[:blank:]]*automatic([[:blank:]#]+|$)" "${confFile}"`
    ret2=`grep -E -c "^[[:blank:]]*node.session.timeo.replacement_timeout[[:blank:]]*=[[:blank:]]*1([[:blank:]#]+|$)" "${confFile}"`
    
    if [ ${ret1} -lt 1 ]; then
        ret=1
        WRITE_XML_ERROR 0 "node.startup is not automatic"
    fi
    if [ ${ret2} -lt 1 ]; then
        ret=1
        WRITE_XML_ERROR 0 "node.session.timeo.replacement_timeout is not 1"
    fi
    
    return ${ret}
}

check_linuxIscsi()
{
    local ret=0
    confFile="/etc/iscsi.conf"
    if [ ! -f ${confFile} ]; then
        WRITE_XML_COMMON 0 "linux iSCSI conf file not found"
        return 0
    fi
    
    ret1=`grep -E -c "^[[:blank:]]*Multipath[[:blank:]]*=[[:blank:]]*portal([[:blank:]#]+|$)" "${confFile}"`
    ret2=`grep -E -c "^[[:blank:]]*ConnFailTimeout[[:blank:]]*=[[:blank:]]*1([[:blank:]#]+|$)" "${confFile}"`
    
    if [ ${ret1} -lt 1 ]; then
        ret=1
        WRITE_XML_ERROR 0 "Multipath is not portal"
    fi
    if [ ${ret2} -lt 1 ]; then
        ret=1
        WRITE_XML_ERROR 0 "ConnFailTimeout is not 1"
    fi
    
    return ${ret}
}

HOST_13_ChkLunPathHeterogeneous()
{
    errResult=""
    isPass=0
    local typePara=""
    local hbas=""
    
    WRITE_XML_SUBCMD_HEADER $1

    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ] || [ "${c10s_upVersion}" -lt "${R2C00}" ]; then
        isPass=3
        WRITE_XML_ERROR 0 "UltraPath is not installed on this host or the version is too low, skip this item."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi

    which upadmin > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        isPass=0
        WRITE_XML_COMMON 0 "The version is before R5C01, cannot find out path heterogeneous"
    else
        if [ `upadmin show vlun type=all 2>/dev/null |grep -c "Invalid input"` -gt 0 ]
        then
            typePara=""
        else
            typePara="type=all"
        fi
        
        for vlunid in `upadmin show vlun ${typePara} | grep -E "^[[:blank:]]*[[:digit:]]" | awk -F " " '{print $1}' | sort | uniq`
        do
            if [ `upadmin show vlun id=${vlunid} ${typePara} | grep -E "Num of Paths" | awk -F ":" '{print $2}'` -eq 0 ]
            then
                isPass=0
                errResult="Warning: vlun_id:${vlunid} has no path."  
                WRITE_XML_ERROR 0 "${errResult}"   
                continue
            fi
            hbas=""
            for pathid in `upadmin show vlun id=${vlunid} ${typePara} | grep "^Path[[:blank:]]*[[:digit:]]" | awk -F " " '{print $2}'`
            do
                hbas="${hbas}`upadmin show path id=${pathid} | grep "Port Type" | awk -F ":" '{print $2}'`"
            done
            if [ `echo ${hbas} | grep "iSCSI" | grep "FC" | wc -l` -gt 0 ]; then
                isPass=0
                WRITE_XML_ERROR 0 "Warning: vlun_id:${vlunid} path heterogeneous."  
            else
                hbas=`echo ${hbas} | awk -F " " '{print $1}'`
                WRITE_XML_COMMON 0 "[vluninfo]:vlun_id:${vlunid} hba type:${hbas}"
            fi
        done
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_14_ChkOsDumpConfig()
{
    errResult=""
    isPass=0
    
    local crashKernel=""
    
    WRITE_XML_SUBCMD_HEADER $1
    
    [ -f /proc/cmdline ] && crashKernel=`cat /proc/cmdline`
    
    if [ `echo ${crashKernel} | grep -c -i "crashkernel"` -le 0 ]; then
        isPass=4
        WRITE_XML_ERROR 0 "kdump is not configured"
    else
        WRITE_XML_ERROR 0 "kdump is configured"
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_15_CheckSystemCompatibility()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    c10s_getUpInfo
    if [ "${c10s_upVersion}" = "" ]; then
        isPass=3
        errResult="UltraPath is not installed on this host, skip this item."
        WRITE_XML_ERROR 0 ":${errResult}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0
    fi
    
    upVersion=`echo ${c10s_upVersion} | awk -F "." '{print $1$2$3}'`
    kVersionMajor=`uname -r | awk -F '.' '{print $1}'`
    kVersionMinor=`uname -r | awk -F '.' '{print $2}'`

    commonResult="UltraPath version is ${c10s_upVersion}"
    WRITE_XML_COMMON 0 ":${commonResult}"
    
    cmdResult=`echo "~ # uname -r"; uname -r`
    WRITE_XML_COMMON 0 ":${cmdResult}"
    
    if [ "${upVersion}" -lt "${R8C50SPC500}" ]; then
        if [ "${kVersionMajor}" -ge 3 ] && [ "${kVersionMinor}" -ge 8 ]; then
            isPass=1
            errResult="The UltraPath version is not compatible with the OS kernel."
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}
               
               
HOST_HostSystemChkItem()
{
  

    WRITE_XML_CMD_HEADER $1
    
    
    case $1 in
        300)
        HOST_13_ChkLunPathHeterogeneous "0"
        ;;
        301)
        HOST_14_ChkOsDumpConfig "0"
        ;;
        302)
        HOST_15_CheckSystemCompatibility "0"
        ;;
        *)
        echo "No this type"
        ;;
    esac

    WRITE_XML_CMD_TAIL         
}