#!/bin/bash

if [ "${c10s_pub}" = "" ]
then
    c10s_pub="yes"
    c10s_packageType=""
    c10s_upVersion=""
    
    c10s_menuLstFile=""
    c10s_OSReleaseFile=""
    function c10s_getUpInfo()
    {
        c10s_upVersion=""
        c10s_packageType=""
        if [ `which rpm 2>/dev/null|grep -c "/rpm"` -eq 1 ] && [ `which dpkg 2>/dev/null|grep -c "/dpkg"` -eq 0 ]
        then
            if [ `rpm -qa | grep -c -E "UltraPath|[Uu][Pp][Ff]orLinux"` -gt 0 ]; then
                c10s_upVersion=`rpm -qa | grep -E "UltraPath|[Uu][Pp][Ff]orLinux" | awk -F "-" '{print $2}'`
                c10s_packageType="RPM"
            fi
        elif [ `which dpkg 2>/dev/null|grep -c "/dpkg"` -eq 1 ]
        then
            if [ `dpkg -s UltraPath|grep -c "^Status.*[[:blank:]]installed[[:blank:]]*$"` -gt 0 ]; then
                c10s_upVersion=`dpkg -s UltraPath | grep "Version" | awk -F ":" '{print $2}'`
                c10s_packageType="DPKG"
            fi
        fi
        
        c10s_upVersion=$(echo ${c10s_upVersion})
        return 0
    }
    
    c10s_supportMenuLst=( "/boot/grub/menu.lst" "/etc/lilo.conf" "/etc/elilo.conf" \
                           "/etc/elilo.conf" "/boot/grub/grub.cfg" "/boot/grub2/grub.cfg" "/etc/grub.conf")
    
    function c10s_getMenuLstFile()
    {
        local bootloaderCount=0
        c10s_menuLstFile=""

        if [ -f /boot/grub/menu.lst ] && [ ! -L /boot/grub/menu.lst ]
        then
            if [ -f /boot/grub/grub.conf ] && [ ! -L /boot/grub/grub.conf ]
            then
                return 1
            fi
            c10s_menuLstFile="/boot/grub/menu.lst"
            let bootloaderCount=bootloaderCount+1
        fi

        if [ -f /boot/grub/menu.lst ] && [ `ls -l /boot/grub/menu.lst|grep -c -E "/boot/grub/menu.lst[[:blank:]]*->.*/grub.conf|/boot/grub/menu.lst[[:blank:]]*->[[:blank:]]*grub.conf"` -eq 1 ]
        then
            c10s_menuLstFile="/boot/grub/menu.lst"
            let bootloaderCount=bootloaderCount+1
        fi
        
        if [ -f /etc/lilo.conf ]
        then
            c10s_menuLstFile="/etc/lilo.conf"
            let bootloaderCount=bootloaderCount+1
        fi
        
        if [ -f /etc/elilo.conf ]
        then
            c10s_menuLstFile="/etc/elilo.conf"
            let bootloaderCount=bootloaderCount+1
        fi
        
        if [ -f /boot/grub/grub.cfg ]
        then
            c10s_menuLstFile="/boot/grub/grub.cfg"
            let bootloaderCount=bootloaderCount+1
        fi
        
        if [ -f /boot/grub2/grub.cfg ]
        then
            c10s_menuLstFile="/boot/grub2/grub.cfg"
            let bootloaderCount=bootloaderCount+1
        fi
        
        efimountinfo=`mount | grep /boot/efi`
        if [ ! -f /boot/grub/menu.lst ] && [ -d /boot/efi ] && [ -f /etc/grub.conf ] && [ -L /etc/grub.conf ] && [ "$efimountinfo" != "" ]
        then
            c10s_menuLstFile="/etc/grub.conf"
            let bootloaderCount=bootloaderCount+1
        fi
        
        if [ ${bootloaderCount} -ne 1 ]; then
            return 1
        fi
        
        return 0
    }
    
    function c10s_getOSReleaseFile()
    {
        c10s_OSReleaseFile=""
        if [ -f /etc/SuSE-release ]; then
            c10s_OSReleaseFile="/etc/SuSE-release"
        elif [ -f /etc/asianux-release ]; then
            c10s_OSReleaseFile="/etc/asianux-release"
        elif [ -f /etc/oracle-release ]; then
            c10s_OSReleaseFile="/etc/oracle-release"
        elif [ -f /etc/neokylin-release ]; then
            c10s_OSReleaseFile="/etc/neokylin-release"
        elif [ -f /etc/redhat-release ] && [ ! -f /etc/asianux-release ] && [ ! -f /etc/oracle-release ]; then
            c10s_OSReleaseFile="/etc/redhat-release"
        elif [ -f /etc/linx-release ] && [ ! -f /etc/debian_version ]; then
            c10s_OSReleaseFile="/etc/linx-release"
        elif [ -f "/etc/debian_version" ]; then
            c10s_OSReleaseFile="/etc/debian_version"
        fi
    }
    
    function c10s_isModLoaded()
    {
        local modCount=0
        modCount=`lsmod | grep -c "nxup"`
        return ${modCount}
    }
fi