#!/bin/bash

MapHealthStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"  
            ;;
        1)
            echo "NORMAL" 
            ;;
        2)
            echo "FAULT"
            ;;
        3)
            echo "PRE_FAIL"
            ;;
        4)
            echo "PART_BROKEN"
            ;;
        5)
            echo "DEGRADE"
            ;;
        6)
            echo "HAS_BAD_BLOCK"
            ;;
        7)
            echo "HAS_ERROR_CODE"
            ;;
        8)
            echo "CONSISTENT"
            ;;
        9)
            echo "INCONSISTENT"
            ;;
        10)
            echo "BUSY"
            ;;
        11)
            echo "POWER_NO_INPUT"
            ;;    
        12)
            echo "POWER_NOT_ENOUGH"
            ;;
        13)
            echo "SINGLE_LINK_FAULT"
            ;;
         *)
            echo "No this type"
            ;;
    esac
}

MapRunningStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"  
            ;;
        1)
            echo "NORMAL" 
            ;;
        2)
            echo "RUNNING"
            ;;
        3)
            echo "NOT_RUNNING"
            ;;
        4)
            echo "NOT_EXIST"
            ;;
        5)
            echo "HIGH_TEMPERATURE_SLEEP"
            ;;
        6)
            echo "STARTING"
            ;;
        7)
            echo "POWER_FAILURE_PROTECTING"
            ;;
        8)
            echo "SLEEPING"
            ;;
        9)
            echo "SPINGUP"
            ;;
        10)
            echo "LINK_UP"
            ;;
        11)
            echo "LINK_DOWN"
            ;;    
        12)
            echo "POWER_ON"
            ;;
        13)
            echo "POWER_OFF"
            ;;
        14)
            echo "PRE_COPY"
            ;;
        15)
            echo "COPYBACK"
            ;;
        16)
            echo "RECONSTRUCTION"
            ;;
        17)
            echo "EXPANSION"
            ;;
        18)
            echo "NOT_FORMAT"
            ;;
        19)
            echo "FORMATTING"
            ;;
        20)
            echo "UNMAPPING"
            ;;
        21)
            echo "INITIAL_SYNCHRONIZING"
            ;;
        22)
            echo "CONSISTENT"
            ;;
        23)
            echo "SYNCHRONIZING"
            ;;
        24)
            echo "SYNCHRONIZED"
            ;;
        25)
            echo "NOT_SYNCHRONIZED"
            ;;
        26)
            echo "SPLIT"
            ;;
        27)
            echo "ONLINE"
            ;;
        28)
            echo "OFFLINE"
            ;;
        29)
            echo "LOCKED"
            ;;
        30)
            echo "ENABLE"
            ;;
        31)
            echo "DISABLED"
            ;;
        32)
            echo "LEVELING"
            ;;
        33)
            echo "TO_BE_RECOVERD"
            ;;
        34)
            echo "INTERRUPTED"
            ;;
        35)
            echo "INVALID"
            ;;
        36)
            echo "NOSTART"
            ;;
        37)
            echo "QUEUING"
            ;;
        38)
            echo "STOP"
            ;;
        39)
            echo "COPYING"
            ;;
        40)
            echo "COMPLETED"
            ;;
        41)
            echo "PAUSE"
            ;;
        42)
            echo "REVSYNCHRONIZING"
            ;;
        43)
            echo "ACTIVATED"
            ;;
        44)
            echo "ROLLBACK"
            ;;
        45)
            echo "INACTIVATED"
            ;;
        46)
            echo "IDLE"
            ;;
        47)
            echo "POWERING_OFF"
            ;;
        48)
            echo "CHARGING"
            ;;
        49)
            echo "CHARGED"
            ;;
        50)
            echo "DISCHARGING"
            ;;
        51)
            echo "UPGRADING"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapDeviceType()
{
    case $1 in
        33)
            echo "P Node"  
            ;;
        34)
            echo "C Node" 
            ;;    
        65)
            echo "M Node" 
            ;;    
        *)
            echo "No this node type"
            ;;
    esac
}

MapDiskType()
{
    case $1 in
        0)
            echo "FC"  
            ;;
        1)
            echo "SAS" 
            ;;
        2)
            echo "SATA" 
            ;;
        3)
            echo "SSD" 
            ;;
        4)
            echo "NL_SAS" 
            ;;
        5)
            echo "SLC_SSD" 
            ;;
        6)
            echo "MLC_SSD" 
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapPowerType()
{
    case $1 in
        0)
            echo "DC"  
            ;;
        1)
            echo "AC" 
            ;;
        *)
            echo "No this type"
            ;;
    esac
}