#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect_software.sh
# Description: ѲĿе״̬.
# Input: 
# Output: 
# Author: 
# Created: 2013-01-16
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile"
G_REMOTE_TMP_FILE="/tmp/tmpfile"
G_TMP_FILE2="$G_SCRIPT_PATH/tmpfile2"
G_REMOTE_TMP_FILE2="/tmp/tmpfile2"


IP_ROLE_FILE="/tmp/tmp_back_ip_role"


G_LINE_FILE="/tmp/lines.txt"
G_TOTALCAP_FILE="/tmp/totalcap.txt"
G_FREECAP_FILE="/tmp/freecap.txt"
G_INFO_FILE="/tmp/dsinfo.txt"

G_UNKNOWN_PROTO="Unknown protocol type"
G_CMD_FAILED="Execute command failed!"
LOG_FILE="/var/log/inspect.log"
 
VALID_IP_FILE="/tmp/tmp_valid_ip"
VALID_IP_FILE2="/tmp/tmp_valid_ip2"
VALID_IP_FILE3="/tmp/tmp_valid_ip3"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"

G_SEPARATOR="#############################################################################"

function LOG_Check
{
    if [ ! -f $LOG_FILE ]; then
        touch $LOG_FILE
        if [ $? -ne 0 ]; then
            echo "Create log file $LOG_FILE failed."
            return
        fi  
    fi 

    # delete log file bigger than 10M
    FILE_SIZE=`ls -l $LOG_FILE | cut -d' ' -f 5`
    if [ ! -z "$FILE_SIZE" ]; then
        # delete file when file bigger than 10M
        if [ $FILE_SIZE -gt 10485760 ]; then
            rm -rf $LOG_FILE
        fi  
    fi  
}

function LOG 
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid=$2
    local err_info=$3

    local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
    local iRet=$?
    LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,progress:$proresult"
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`
    
    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 3    #Զִʧ    
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME] exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid=$2
    local time_out=$3
    local cmd=$4
    
    /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
    local iRet=$?
    if [ $iRet -ne 0 ]; then
        return $iRet
    fi
    
    return 0
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command." 
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi  
    done
    
    return $ret
}
#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command." 
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi  
    done
    
    return $ret
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    
    /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
    local iRet=$?
    LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet)"
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi
    return $iRet
}
 
#ȡڵһIP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'`
    if [ "$subnet_id" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet" 
        return 1
    fi

    set_ifs
    for line in $subnet_id; do
        break
    done
    restore_ifs

    local IPAddress=`grep ipaddr_${line} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet IP" 
        return 1
    fi
    
    echo $IPAddress
    return 0
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 group by NID"
    if [ $? -ne 0 ]; then
        sleep 1
        sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 group by NID"
        if [ $? -ne 0 ]; then
            LOG "[$FUNCNAME]Failed to get back subnet IP of $nid from db" 
        fi
    fi
}

############################################################################################# 
 
#200. 鼯Ⱥ״̬
checkSystemInfo_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    
    while true; do
    
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi
         
        #ע
        set_ifs 
        
        #ִmml cm system
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]:mml_result:${Info}" 
            WRITE_XML_ERROR 0 "INFO:Failed to execute command(cm system)." 
            isPass=1
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
           
            if [ "$content" == "" ];then
                WRITE_XML_ERROR 0 "Can not get information." 
                isPass=1
            else
                ID=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_ID"|awk -F: '{print $2}'`
                Name=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Name"|awk -F: '{print $2}'`
                Health_Status=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Health_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")'`
                Running_Status=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Running_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")'`
                version=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Version"|awk -F: '{print $2}'`

                totalCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}'`
                usedCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}'`
                idleCap=`expr $totalCap \- $usedCap`        
                Percentage=`expr 100 \* $usedCap`
                Percentage=`expr $Percentage / $totalCap`
                echo $Health_Status
                echo $Running_Status
                Health_Status=`MapHealthStatus $Health_Status`
                Running_Status=`MapRunningStatus $Running_Status`
                Result="ID:$ID||Name:$Name||Health_Status:$Health_Status||Running_Status:$Running_Status||Version:$version||TotalCapacity(MB):$totalCap||UsedCapacity(MB):$usedCap||Percentage(%):$Percentage"
           
                Running_Status=$(echo ${Running_Status})

                if [ "$Running_Status" == "RUNNING" ] && [ "$Health_Status" == "NORMAL" ] && [ $Percentage -lt 75 ];then
                    LOG "[$FUNCNAME]Running_Status($Running_Status);Health_Status($Health_Status) check ok" 
                else
                    isPass=1
                    
                    #
                    cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                    LOG "[$FUNCNAME]Running_Status($Running_Status);Health_Status($Health_Status) check failed" 
                fi

                WRITE_XML_COMMON 0 "$Result"
            fi
        fi
        
        restore_ifs
        break
    done
    
    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#201.ļϵͳ򿪾CA45000
checkOpenFileCount_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
      
    local count=0
    local Result=""
    local isPass=0
    local TASK_ID=0
    
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"
    
    #Զ첽ִ
    remote_exec_async_batch_mml $TASK_ID 30 ShowOpenFileCount $FUNCNAME
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`
    LOG "ValidIP:$ValidIP"
    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        for Item in $ValidIP 
        do
            #Ƿִгɹ            
            remote_exec_checkfini $Item $TASK_ID "Can not get OpenFileCount information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to get information." 
                continue
            fi
            
            #
            dos2unix $G_TMP_FILE$Item
            count=`cat $G_TMP_FILE$Item|grep "Open File Count"|awk '{print $5}'`
            
            if [ "$count" == "" ];then
                LOG "[$FUNCNAME]$Item count($count)"
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                
                count="Can not get open file count."
                Result="Node:$Item||OpenFileCount:$count"
                WRITE_XML_COMMON 0 "$Result"
                isPass=1
                continue
            fi
            
            Result="Node:$Item||OpenFileCount:$count"
            WRITE_XML_COMMON 0 "$Result"
          
            if [ $count -lt 45000 ];then
                LOG "[$FUNCNAME]$Item count($count)"
            else
                LOG "[$FUNCNAME]$Item count($count) >= 45000"
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                
                isPass=1
            fi
            
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL       
}

#202. ڵ
checkNodeThroughput()
{
    WRITE_XML_SUBCMD_HEADER $1
    
    local errResult=""
    local isPass=0
    local CmdPort=4016
    local numCnt=1

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi
         
        $G_MML_FILE_PATH/ShowInspectMml $back_ip $CmdPort "cm nodeopsinfo"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]mml_result:($Info)"
            errResult="INFO: Failed to execute command."
            isPass=1
            break
        fi
        
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        
        #
        set_ifs
        nodeCount=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "nodeopsinfo:" | wc -l`
        if [ $nodeCount -le 0 ]; then
            errResult="INFO: No Node OPS INFO."
            LOG "[$FUNCNAME]:$errResult"
            
            isPass=1
            restore_ifs
            break
        fi
        
        while [ $numCnt -le $nodeCount ]; do
            NID=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $3}'`
            CifsOps=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $6}'`
            NfsOps=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $9}'`
            
            if [ "$NID" == "" ] || [ "$CifsOps" == "" ] || [ "$NfsOps" == "" ];then
                errResult="INFO: OPS INFO have errors."
                LOG "[$FUNCNAME]:$errResult"
                isPass=1
                continue
            fi
            
            if [ "$CifsOps" -gt 25000 ] || [ "$NfsOps" -gt 20000 ]; then
               isPass=1
            fi
            
            Nodeip=`get_node_backnet_ip $NID`
            LOG "[$FUNCNAME]:Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"
            WRITE_XML_COMMON 0 "Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"
            
            numCnt=$((numCnt+1))
        done
        
        restore_ifs
        break
    done
    
    if [ "$isPass" != "0" ];then
        
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
    
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    else
        WRITE_XML_JUDGE 0
    fi
    WRITE_XML_SUBCMD_TAIL
}

checkIOPerform()
{     
    rcount=`cat $G_TMP_FILE$Item |grep '<read count>' |sed "s/[^0-9]//g"`
    wcount=`cat $G_TMP_FILE$Item |grep '<write count>' |sed "s/[^0-9]//g"`
    ccount=`cat $G_TMP_FILE$Item |grep '<cmd count>' |sed "s/[^0-9]//g"`
    rbytes=`cat $G_TMP_FILE$Item |grep '<read bytes>' |sed "s/[^0-9]//g"`
    wbytes=`cat $G_TMP_FILE$Item |grep '<write bytes>' |sed "s/[^0-9]//g"`
    maxcalldelay=`cat $G_TMP_FILE$Item |grep '<max call delay(ms)>' |sed "s/[^0-9]//g"`
    maxreaddelay=`cat $G_TMP_FILE$Item |grep '<max read delay(ms)>' |sed "s/[^0-9]//g"`
    maxwritedelay=`cat $G_TMP_FILE$Item |grep '<max write delay(ms)>' |sed "s/[^0-9]//g"`
    totalcmddelay=`cat $G_TMP_FILE$Item |grep '<total cmd delay(ms)>' |sed "s/[^0-9]//g"`
    totalreaddelay=`cat $G_TMP_FILE$Item |grep '<total read delay(ms)>' |sed "s/[^0-9]//g"`
    totalwritedelay=`cat $G_TMP_FILE$Item |grep '<total write delay(ms)>' |sed "s/[^0-9]//g"`
    
    result="IP:$2||Protocol:$1||CheckType:IO perform||Read count:${rcount}||Write count:${wcount}||Cmd count:${ccount}"
    result=${result}"||Read bytes:${rbytes}||Write bytes:${wbytes}"
    result=${result}"||max call delay(ms):${maxcalldelay}||max read delay(ms):${maxreaddelay}||max write delay(ms):${maxwritedelay}"
    result=${result}"||total cmd delay(ms):${totalcmddelay}||total read delay(ms):${totalreaddelay}||total write delay(ms):${totalwritedelay}"
    echo $result
    
    if [[ ${maxreaddelay} -gt 50000 ||  ${maxwritedelay} -gt 50000 || ${maxcalldelay} -gt 50000 ]];then
        LOG "[$FUNCNAME]$1 $2 maxreaddelay($maxreaddelay) or maxwritedelay($maxwritedelay) or maxcalldelay(${maxcalldelay}) over 50 !"
        return 1
    fi
    
    return 0
}

#203. ڵIOͳϢ
checkNodeIOPerform()
{
    WRITE_XML_SUBCMD_HEADER $1
    
    local errResult=""
    
    #Զ첽ִвѯCIFSЭIOܣҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNodeIO > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?  

    ValidIp=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIp} != "" ]]
    do 
        > ${VALID_IP_FILE}
        for Item in $ValidIp 
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Node IO information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
            
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (ShowNodeIO) failed.iRet($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(get Node ioperform progress) failed.iRet($iRet),errno($errno)!"
                isPass=1
                continue;
            fi
            
            dos2unix $G_TMP_FILE$Item
            
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            
            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                   isPass=1
                fi
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"

            done < $G_TMP_FILE$Item
            restore_ifs
            
            WRITE_XML_COMMON 0 "${ret}"  
            
        done
        ValidIp=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL     
}

#204. 鿴Ź״̬
checkWatchdogStatus_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    InstallPath="/opt/huawei/deploy/bin/daemon"
    Result=""
    isPass=0

    ALLIp=`cat $IP_ROLE_FILE`
    
    >${VALID_IP_FILE}
    
    for Item in $ALLIp 
    do
        #ԶΪ첽ִ    
        /opt/huawei/deploy/script/localexec.py async $Item 0 30 true "ls /opt/huawei/deploy/bin/daemon > $G_REMOTE_TMP_FILE$Item 2>&1"
        iRet=$?
        
        /opt/huawei/deploy/script/localexec.py async $Item 1 30 true "ps -ef |grep /opt/huawei/deploy/bin/daemon|grep -v 'grep'| grep -v 'localexec' > $G_REMOTE_TMP_FILE2$Item 2>&1"
        iRet2=$?
        if [ $iRet -ne 0 ] || [ $iRet2 -ne 0 ]; then
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$Item
            Info=`cat $G_TMP_FILE$Item`
            errResult="Node: $Item||Error: ${Info}||$errResult"
            isPass=1
            
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$Item
            Info=`cat $G_TMP_FILE2$Item`
            errResult="Node: $Item||Error: ${Info}||$errResult"
            WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to execute command." 
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            proresult=`/opt/huawei/deploy/script/localexec.py progress $Item 0`
            iRet=$?
            LOG "[$FUNCNAME]:IP:$Item,proresult0:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`

            if [[ $iRet -eq 0 && "$process" != "" && "$process" != "100" ]];then
                echo  -n "$Item " >> ${VALID_IP_FILE}
                continue;
            elif [ $iRet -ne 0 ] || [ "$process" == "" ];then
                errResult="IP: $Item||Error: exec (get progress) failed.errno($errno)!||$errResult"
                LOG "[$FUNCNAME] exec(get progress0) INFO.iRet($iRet),$Item, process($process), errno($errno)"
                WRITE_XML_ERROR 0 "Node:$Item||Error:Can not get daemon information.\r\n"
                isPass=1;
                continue;
            fi    
            
            Result=""
            
            #errnoΪ0˵ļ
            if [ "$errno" == "0" ] ;then   
                Result="INFO:${InstallPath} is exsit."       
            else
                Result="INFO:${InstallPath} is not exsit or is not a regular file."
                LOG "[$FUNCNAME]$Item $Result"
                isPass=1  
            fi               
            
            #Ϊ100%֮ļأн
            proresult=`/opt/huawei/deploy/script/localexec.py progress $Item 1`
            iRet=$?
            LOG "[$FUNCNAME]:IP:$Item,proresult1:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`
            
            if [[ $iRet -eq 0 && "$process" != "" && "$process" != "100" ]];then
                echo "$Item" >> ${VALID_IP_FILE}
                continue;
            elif [ $iRet -ne 0 ] || [ "$process" == "" ];then
                errResult="IP: $Item||Error: exec (get progress) failed.errno($errno)! ||$errResult"
                LOG "[$FUNCNAME] exec(get progress1) INFO.iRet($iRet),$Item, process($process), errno($errno)"
                isPass=1;
                continue;
            fi    
            
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$Item
            ExecInfo=`cat $G_TMP_FILE2$Item`
            if [ "${ExecInfo}" == "" ]; then
                Result="${Result}||INFO:${InstallPath} is not running.\n"
                LOG "[$FUNCNAME]$Item ${InstallPath} is not running."
                isPass=1
            else
                Result="${Result}||INFO:${InstallPath} is running.\n"
            fi
            
            LOG "INFO:$Itemr\n$Result\r\n"
            WRITE_XML_COMMON 0 "INFO:${G_SEPARATOR}||INFO:$Item||$Result"
            
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
            
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_JUDGE 1
        WRITE_XML_ERROR 0 "${errResult}"
    fi
    WRITE_XML_SUBCMD_TAIL     
}

#205. MONϵͳ״̬: Ƿ״̬ͨMAPṩMMLӡmap
checkMonitorHeartbeat_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isOK=0
    local Info=""

    strNormal="Normal"
    len=${#strNormal}
    errResult=""
    
    #Զ첽ִҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/GetMapInfo 2>&1"
    isPass=$?  
 
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        for Item in $ValidIP 
        do
            remote_exec_checkfini $Item $TASK_ID "Can not get GetMapInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
             
            #Ϊ100%֮ļأн            
            file_DsMap="DsMap"
            remote_download $Item $G_TMP_FILE$file_DsMap $G_REMOTE_TMP_FILE$file_DsMap
            iRet0=$?
            
            file_MdsMap="MdsMap"
            remote_download $Item $G_TMP_FILE$file_MdsMap $G_REMOTE_TMP_FILE$file_MdsMap
            iRet1=$?
            
            file_CaMap="CaMap"
            remote_download $Item $G_TMP_FILE$file_CaMap $G_REMOTE_TMP_FILE$file_CaMap
            iRet2=$?
            
            file_PipMap="PipMap"
            remote_download $Item $G_TMP_FILE$file_PipMap $G_REMOTE_TMP_FILE$file_PipMap
            iRet3=$?
            
            if [ "$iRet0" != "0" ] || [ "$iRet1" != "0" ] || [ "$iRet2" != "0" ] || [ "$iRet3" != "0" ];then
                errResult="Node: $Item||Error: (get mapinfo) get progress failed.iRet0($iRet0),iRet1($iRet1),iRet2($iRet2),iRet3($iRet3)||${errResult}"
                LOG "[$FUNCNAME] (get mapinfo) iRet1($iRet1),iRet2($iRet2),iRet3($iRet3)"
                
                isPass=1
                continue
            fi
            
            #DS mapϢ #Ƿҵ 'ucState' ʶ #############################################
            isOK=0
            isFound=0
            set_ifs
            
            head_info="******************** DS Map *********************"
            WRITE_XML_COMMON 0 "Node:$Item||INFO:$head_info"
            
            while read line
            do
                tmp=`echo ${line} | grep 'ucState' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                ucstate=`echo ${line}  | grep 'ucState' | awk '{print $12}'`
                if [ "${ucstate:0:$len}" != "Normal" ];then        
                    LOG "[$FUNCNAME]$Item monc_dsmap ucstate($ucstate) is not Normal" 
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"
                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_DsMap
    
            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_dsmap isFound(${isFound})" 
                errResult="Node: $Item||Error: cat /proc/monc_dsmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All DS Map Normal"
            fi
            
            #mds mapϢ###################################################################
            isFound=0
            isOK=0
            head_info="**************** Active MDS Map *****************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"
            
            while read line
            do
                tmp=`echo ${line} | grep 'State' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                state=`echo ${line}  | grep 'State' | awk '{print $6}'`
                if [ "${state:0:$len}" != "Normal" ];then    
                    LOG "[$FUNCNAME]$Item monc_mdsmap state($state) is not Normal"      
                    
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"
                    
                    isPass=1                     
                    isOK=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_MdsMap 
    
            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_mdsmap isFound(${isFound}))" 
                errResult="Node: $Item||Error: cat /proc/monc_mdsmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All MDS Map Normal"
            fi
            
            #ca map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** CA Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"
            
            while read line
            do
                tmp=`echo ${line} | grep 'State' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                state=`echo ${line}  | grep 'State' | awk '{print $6}'`
                if [ "${state:0:$len}" != "Normal" ];then    
                    LOG "[$FUNCNAME]$Item monc_mdsmap state($state) is not Normal"   
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"
                     
                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_CaMap 
    
            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_mdsmap isFound(${isFound}))" 
                errResult="Node: $Item||Error: cat /proc/monc_mdsmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All CA Map Normal"
            fi

            #pip map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** PIP Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"
            
            while read line
            do
                tmp=`echo ${line} | grep 'State' `
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                state=`echo ${line}  | grep 'State' | awk '{print $6}'`
                if [ "${state:0:$len}" != "Normal" ];then    
                    LOG "[$FUNCNAME]$Item monc_pipmap state($state) is not Normal"   
                    WRITE_XML_COMMON 0 "Node: ||INFO:${line}"
                     
                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_CaMap 
    
            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_pipmap isFound(${isFound}))" 
                errResult="Node: $Item||Error: cat /proc/monc_pipmap ucState flag is not found or not Normal!||${errResult}"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All PIP Map Normal"
            fi
            
            
            restore_ifs
            
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    LOG "[$FUNCNAME]isPass($isPass)!" 
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    fi
    WRITE_XML_SUBCMD_TAIL     
}

#206. NTP״̬/server
checkNTPService_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0

    ALLIp=`cat $IP_ROLE_FILE`
    
    >${VALID_IP_FILE}
    
    for Item in $ALLIp 
    do
        #ԶΪ첽ִ    
        /opt/huawei/deploy/script/localexec.py async $Item 0 30 true "service ntp status > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        /opt/huawei/deploy/script/localexec.py async $Item 1 30 true "cat /etc/ntp.conf > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet2=$?
        if [ $iRet -ne 0 ] || [ $iRet2 -ne 0 ] ; then
            errResult="Node: $Item||Error: ${iRet}||$errResult"

            errResult="Node: $Item||Error: ${iRet2}||$errResult"
            WRITE_XML_ERROR 0 "Info:${G_SEPARATOR}\r\n$Item\r\nFailed to execute command."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            TASK_ID=0
            remote_exec_checkfini $Item $TASK_ID "Can not get service ntp status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
            
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi            

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            
            state=`cat $G_TMP_FILE$Item |grep 'NTPD' | awk -F : '{ print $2}' | sed "s/[^a-z]//g"`
            if [ $? -ne 0 ]; then
                isPass=1
                Status="Can not get NTP status."
                LOG "[$FUNCNAME]$Item $Status" 
            elif [ "${state}" != "running" ];then
                isPass=1
                Status="NTP service is NOT running."
                LOG "[$FUNCNAME]$Item $Status"
            else
                Status="NTP service is running."
            fi
            
            #Ϊ100%֮ļأн #########################################
            TASK_ID=1
            remote_exec_checkfini $Item $TASK_ID "Can not get /etc/ntp.conf information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
            
            remote_download $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi    
            
            #
            cat $G_TMP_FILE2$Item >> $LOG_FILE 2>&1
            
            server=`cat $G_TMP_FILE2$Item |grep server | grep prefer | sed '/#/d'|awk '{print $2}'`
            if [ $? -ne 0 ] || [ "$server" == "" ]; then
                isPass=1
                server="Can not get NTP server."
                connectState="--"
                LOG "[$FUNCNAME]$Item $server" 
            else
                LOG "[$FUNCNAME]$Item $server" 
                
                tempStr_ping=`ping -q -c 1 $server |grep "1 received" |wc -l`
                if [ "1" == "$tempStr_ping" ];then
                    connectState="OK"
                else 
                    connectState="Can not access."
                    isPass=1
                fi
            fi

            Result="RunningStatus:$Status||Server:$server||ConnectingStatus:$connectState"
            WRITE_XML_COMMON 0 "Node:$Item||$Result"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    WRITE_XML_JUDGE $isPass
     
    WRITE_XML_SUBCMD_TAIL     
}

#207. CMڵ
checkCMMaster()
{
    WRITE_XML_SUBCMD_HEADER $1
    local CMMasterNID=0
    local isPass=0
    local NID_before=""
    local TASK_ID=0
    local masterIP=""
   
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch_mml $TASK_ID 30 ShowCMMaster $FUNCNAME
    isPass=$?
        
    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
    >${VALID_IP_FILE}
    
        for Item in $ValidIP; do
    
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get cmmaster information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            dos2unix $G_TMP_FILE$Item
            
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            
            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    LOG "[$FUNCNAME] Error: $info"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"    
                    continue
                fi
                
                #ȡ
                masterNID=`cat $G_TMP_FILE$Item | grep CMMasterNID | awk '{print $2}'`
                LOG "[$FUNCNAME]:masterNID:$masterNID,NID_before:$NID_before"
                
                if [ "$masterNID" == "" ]; then
                    isPass=1
                    LOG "[$FUNCNAME] Error: No CM MasterNID info"
                    
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:No masterNID info"
                    continue
                fi

                masterIP=`get_node_backnet_ip $masterNID`
                Result="Node:$Item||CMMasterNID:$masterNID||CMMasterIP:$masterIP"
                
                if [ "$NID_before" != "" ];then
                    if [ "$NID_before" != $masterNID ];then
                        isPass=1
                    fi
                fi
                
                NID_before=$masterNID
                WRITE_XML_COMMON 0 "${Result}"
                    
            done < $G_TMP_FILE$Item
            restore_ifs
                         
        done                                     
        ValidIP=`cat ${VALID_IP_FILE}`           
    done  
    
    #Ѿ鵽ڵˣѲ½ľǸIPһжڵǲԼ
    myNid=`grep "NID=" /opt/huawei/snas/etc/cm.ini | sed 's/NID=//'`
    if [ "$myNid" != "$NID_before" ];then
        isPass=1
        WRITE_XML_ERROR 0 "INFO:float ip is not on master node!"    
    fi
    
    LOG "[$FUNCNAME]:myNid:$myNid,NID_before:$NID_before"
        
    WRITE_XML_JUDGE $isPass 
    WRITE_XML_SUBCMD_TAIL
}

#208. ISM״̬ISM/CM״̬
checkISMStatus_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Status=""
    local hbStatus=""
    local Result=""
    local process=""
    local isPass=0
    
    ALLIp=`cat $IP_ROLE_FILE`
    
    >${VALID_IP_FILE}
    
    for Item in $ALLIp 
    do
        #ԶΪ첽ִ    
        /opt/huawei/deploy/script/localexec.py async $Item 0 30 true "ps -ef|grep ismMonitor.sh |grep -v grep | grep -v 'localexec' > $G_REMOTE_TMP_FILE$Item 2>&1"
        iRet=$?
        
        /opt/huawei/deploy/script/localexec.py async $Item 1 30 true "lsof -i :8080|grep ESTABLISHED|grep java > $G_REMOTE_TMP_FILE2$Item 2>&1"
        iRet2=$?
        
        if [ $iRet -ne 0 ] || [ $iRet2 -ne 0 ] ; then
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$Item
            Info=`cat $G_TMP_FILE$Item`
            errResult="IP: $Item||Error: ${Info}||$errResult"
            isPass=1
            
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$Item
            Info=`cat $G_TMP_FILE2$Item`
            errResult="IP: $Item||Error: ${Info}||$errResult"
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            proresult=`/opt/huawei/deploy/script/localexec.py progress $Item 0`
            iRet=$?
            LOG "[$FUNCNAME]:IP:$Item,proresult:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`
            
            if [[ $iRet -eq 0 && "$process" != "" && "$process" != "100" ]];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue;
            elif [ $iRet -ne 0 ] || [ "$process" == "" ];then
                errResult="IP: $Item||Error: exec (get progress) failed.errno($iRet)!||$errResult"
                LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet)"
                isPass=1;
                continue;
            fi    
            
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$Item
            #ism״̬
            process=`cat $G_TMP_FILE$Item`
            
            if [ "$process" != "" ];then
                Status="ISM is running."
            else 
                Status="ISM is not running."
                LOG "[$FUNCNAME]$Item $Status, process($process)" 
                isPass=1
            fi
            
            #Ϊ100%֮ļأн
            proresult=`/opt/huawei/deploy/script/localexec.py progress $Item 1`
            iRet=$?
            LOG "[$FUNCNAME]:IP:$Item,proresult:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`
            
            if [[ $iRet -eq 0 && "$process" != "" && "$process" != "100" ]];then
                echo  -n "$Item " >> ${VALID_IP_FILE}
                continue;
            elif [ $iRet -ne 0 ] || [ "$process" == "" ];then
                errResult="IP: $Item||Error: exec (get progress) failed.errno($iRet)!||$errResult"
                LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet)"
                isPass=1;
                continue;
            fi    
            
            /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$Item
            #ismcm״̬
            hbStatus=`cat $G_TMP_FILE2$Item`
            
            if [ "$hbStatus" != "" ];then
                htbtStatus="Normal"
            else 
                htbtStatus="Abnormal"
                LOG "[$FUNCNAME]$Item htbtStatus($htbtStatus) not Normal" 
                isPass=1
            fi
    
            Result="IP:$Item||ISMStatus:$Status||HTBTStatus:$htbtStatus"
            WRITE_XML_COMMON 0 "$Result"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_JUDGE 1
        WRITE_XML_ERROR 0 "$errResult"
    fi
    WRITE_XML_SUBCMD_TAIL
}

#209. license״̬
checkLicenseStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0
    
    while true; do

        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME]:INFO: Can't get local ip"
            isPass=1
            WRITE_XML_COMMON 0 "INFO:Can't get local ip"
            break
        fi
      
        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]mml_result:$Info" 
            WRITE_XML_COMMON 0 "INFO:Failed to execute command(cm licensecfg)."
            isPass=1
            break
        fi
        
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
        
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail"`    
        if [ "$Info" != "" ];then
            #һжǷмlicenseļ
            WRITE_XML_ERROR 0 "INFO:License is not activated."
            break
        fi
        
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`
    
        if [ "$javaID" = "" ];then
            LOG "[$FUNCNAME]:$line,javaID is null"
            WRITE_XML_ERROR 0 "INFO:No license resource active." 
            break
        fi
        
        set_ifs
        for line in $javaID
        do
            if [ $line = "" ];then
                continue;
            fi
            #ʽacFeatureName : WiseQuota || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseLink || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseTier || acLicRunTime : 1375113600000 || uiResLKVal : 10.
 
            Feature=`echo $line |awk '{print $3}'`
            MaxNumber=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            Deadline=`echo $line |awk '{print $7}'`
            LOG "Deadline:$Deadline"
            date1=`expr $Deadline \/ 1000`
            Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            LOG "Deadline:$Deadline"
            date2=`date`

            t1=$date1
            t2=`date --date "$date2" +%s`  
            LOG "Deadline:$t1,CurrentTime:$t2"
                             
            LOG "[$FUNCNAME]:$line" 
                        
            if [ $t1 -gt $t2 ]; then 
                LOG "$Deadline > $date2" 
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_gt]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            elif [ $t1 -eq $t2 ]; then 
                LOG "$Deadline == $date2" 
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_eq]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            else 
                LOG "$Deadline < $date2"
                isPass=1
                LOG "isPass:$isPass"

                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_expired]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            fi 
        done
        restore_ifs
        
        break
    done
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#һΧڵ
function ProduceRandom() 
{
    min=$1
    max=$2-$1
    num=$(date +%s+%N)
    ((retnum=num%max+min))
    echo $retnum
}

#210. ļϵͳ    ֳ֧ļв    ضĿ¼ִдĿ¼/ļ//ӲӵȲ
checkFileOperation_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local Info=""
    
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowFileOperation > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not NIC information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue;
            fi

            set_ifs 
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1                    
                fi
                
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"
                
            done < $G_TMP_FILE$Item
            restore_ifs
            
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#NASЭ    ӵĿͻ    ͻIP/Э            NASЭ
#NASȺ״̬                            CM
#wiselink    ״̬                    NASЭ
#    OPS                            NASЭ

checkNASClient()
{
    client_ip=`cat $G_TMP_FILE |grep "ip_clnt"|sed 's/[^0-9\.]//g'`
    client_num=`cat $G_TMP_FILE |grep "ip_clnt"|sed 's/[^0-9\.]//g'|wc -l`
    client_protocal=`cat $G_TMP_FILE |grep "proto_type"| sed 's/[^A-Z]//g'`
    result="LocalIp:$1||client_num:${client_num}||client_type:$2"
    
    info=`cat $G_TMP_FILE`    
    LOG "[$FUNCNAME] $1 ,info:$info"
    LOG "client_num:$client_num"

    if [ ${client_num} -gt 400 ];then
        LOG "[$FUNCNAME]$1 ${client_protocal} client num(${client_num}) over 400!"
        echo $result
        return 1
    else 
        echo "LocalIp:$1||client_num:$client_num||client_type:$2"
    fi
}

#211. NASӵĿͻ
checkALLClient()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""

    local TASK_ID="getCifsNASClient"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "/usr/local/bin/nas_proto_status_cifs -t clntinfo > $G_REMOTE_TMP_FILE$FUNCNAME[CIFS] 2>&1"
    isPass=$?
       
    ValidIp=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIp} != "" ]]
    do 
        > ${VALID_IP_FILE}
        for Item in $ValidIp 
        do
            #Ϊ100%֮ļأн    
            remote_exec_checkfini $Item $TASK_ID "Can not get nas_proto_status_cifs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE $G_REMOTE_TMP_FILE$FUNCNAME[CIFS]
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            #
            ret=`checkNASClient $Item "CIFS"`
            if [ $? -ne 0 ];then
                LOG "[$FUNCNAME]check $Item cifs client failed!"
                isPass=1
            fi
            WRITE_XML_COMMON 0 "${ret}"    
        done
        ValidIp=`cat ${VALID_IP_FILE}`
    done
    
    #ȡnfsͻ
    TASK_ID="getNfsNASClient"
    remote_exec_async_batch $TASK_ID 30 "/usr/local/bin/nas_proto_status_nfs -t clntinfo  > $G_REMOTE_TMP_FILE$FUNCNAME[NFS] 2>&1"
    if [ "${isPass}" -eq "0" ];then
        isPass=$?
    fi
    
    ValidIp=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIp} != "" ]]
    do 
        > ${VALID_IP_FILE}
        for Item in $ValidIp 
        do
            #Ϊ100%֮ļأн    
            remote_exec_checkfini $Item $TASK_ID "Can not get nas_proto_status_nfs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE $G_REMOTE_TMP_FILE$FUNCNAME[NFS]
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            ret=`checkNASClient $Item "NFS"`
            if [ $? -ne 0 ] ;then
                LOG "[$FUNCNAME]check $Item nfs client failed!"
                isPass=1
            fi
            WRITE_XML_COMMON 0 "${ret}"    
        done
        ValidIp=`cat ${VALID_IP_FILE}`
    done    

    WRITE_XML_JUDGE $isPass

    WRITE_XML_SUBCMD_TAIL     
}


#212. NASȺ״̬InfoEqualizer״̬
checkNASClusterStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    
    local isPass=0
    local NASStatus=""
    local AbnormalInfo=""
    local unusedInfo=""
    
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ȡnascifsϢ  
    local TASK_ID="getNASStatus"
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNasState > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`
    
    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        for Item in $ValidIP 
        do        
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get nascifs status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            dos2unix $G_TMP_FILE
            
            set_ifs
            Result=""
            NASStatus=`cat $G_TMP_FILE`
            if [ "$NASStatus" == "" ];then
                isPass=1 
                echo "faile0:$isPass no 0"
                Result="Node:$Item||InfoEqualizer_Status:Unknown||CIFS_Status:Unknown||NFS_Status:Unknown"
            else
                AbnormalInfo=`echo $NASStatus | grep "Abnormal"`
                unusedInfo=`echo $NASStatus | grep "unused"`
                Result="$NASStatus"
                if [ "$AbnormalInfo" != "" ] || [ "$unusedInfo" != "" ];then
                    isPass=1 
                    echo "faile1:$isPass no 0"
                fi        
            fi
                        
            restore_ifs
            WRITE_XML_COMMON 0 "Node:$Item||$Result"                    
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
     
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#213. ̿ռʹ    DSṩ̿ռʹ
checkDSUsage()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
        
    cat /proc/monc_dsmap > $G_TMP_FILE 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="INFO:exec(cat /proc/monc_dsmap) failed!errno($iRet)||Error:$Info"
        LOG "[$FUNCNAME]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isOK=1
        WRITE_XML_ERROR 0 "$Result"
    else
        #ȡк
        set_ifs
        awk '/IpAddr/{print NR}' $G_TMP_FILE > $G_LINE_FILE

        count=1
        nodesNum=`cat $G_LINE_FILE|wc -l`
        while [ $count -le $nodesNum ]
        do
            line1=`cat $G_LINE_FILE|sed -n $count'p'`
            count=`expr $count \+ 1`
            if [ $count -le $nodesNum ];then
                line2=`cat $G_LINE_FILE|sed -n $count'p'`
            else 
                line2=`cat $G_TMP_FILE|wc -l`
            fi
            line2=`expr $line2 \- 1`

            sed -n $line1,$line2'p' $G_TMP_FILE > $G_INFO_FILE
    
            IPAddress=`cat $G_INFO_FILE|grep "IpAddr"|awk '{print $14}'`
            #ȡһڵTotalCap
                  
            cat $G_INFO_FILE | grep "TotalCap" > $G_TOTALCAP_FILE
            javaID=`cat $G_TOTALCAP_FILE|sed 's/^ *//g'|sed "/^$/d"`  
            sumTotal=0
            sumFree=0
            for line in $javaID
            do
                totalCap=`echo $line|awk '{print $10}'`
                freeCap=`echo $line|awk '{print $12}'`

                #λֽתGB
                totalCap=`expr $totalCap / 1073741824`
                freeCap=`expr $freeCap / 1073741824`
    
                sumTotal=`expr $sumTotal \+ $totalCap`
                sumFree=`expr $sumFree \+ $freeCap`
            done
            
            #ʹ
            LOG "[$FUNCNAME]total(GB):$sumTotal free(GB):$sumFree"
            sumUsed=`expr $sumTotal \- $sumFree`
            LOG "[$FUNCNAME]total(GB):$sumTotal free(GB):$sumFree used(GB):$sumUsed"
            if [ $sumTotal -eq 0 ];then
                percentage=0
            else
                sumUsedtemp=`expr $sumUsed \* 100`
                percentage=`expr $sumUsedtemp \/ $sumTotal`
            fi
    
            if [ $percentage -lt 75 ];then
                LOG "[$FUNCNAME]percentage:$percentage"
            else
                isPass=1        
            fi 
            
            Result="IP:$IPAddress||TotalCap(GB):$sumTotal||FreeCap(GB):$sumFree||UsedCap(GB):$sumUsed||Percentage(%):$percentage"
            WRITE_XML_COMMON 0 "$Result"
        done
        
        restore_ifs 
    fi
                
    WRITE_XML_JUDGE $isPass
    
    WRITE_XML_SUBCMD_TAIL     
}

#214. ڵϵͨѶ·
checkCommuLink()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
 
    remote_exec_async_batch $TASK_ID 30 "cat /proc/sys/lnet/peers > $G_REMOTE_TMP_FILE$FUNCNAME;sleep 3;cat /proc/sys/lnet/peers >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get /proc/sys/lnet/peers information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi   

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            
            dos2unix $G_TMP_FILE$Item
            set_ifs
            if [ $iRet -ne 0 ]; then
                errResult="Node: $Item||Error: exec(cat /proc/sys/lnet/peers) failed!iRet($iRet)!||${errResult}"
                LOG "[$FUNCNAME]$Item ,iRet($iRet)"
                isPass=1
            else
                Result=""
                while read row
                do       
                    rowinfo=`echo $row | awk '{print $2}' | grep '4004\|4020\|4016\|988\|peernid'`
                    if [ "${rowinfo}" != "" ];then
                        if [ "" != "${Result}" ];then
                            Result="${Result}||INFO:${row}"
                        else
                            Result="INFO:${row}"
                        fi    
                       
                        status=`echo $row | awk '{print $4}'|sed 's/^ *//g'|sed "/^$/d"`
                        status_info=`echo $status | grep down`              
                                                
                        if [ "$status" == "down" ] || [ "${status_info}" != "" ];then
                           LOG "[$FUNCNAME]status:$status,status_info:$status_info"
                           isPass=1
                        fi        
                    fi
                done   <  $G_TMP_FILE$Item
            fi
                        
            if [ "" != ${Result} ];then
                WRITE_XML_COMMON 0 "INFO:${G_SEPARATOR}||INFO:$Item||${Result}"
            fi
            
            restore_ifs  

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else 
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    fi
    
    WRITE_XML_SUBCMD_TAIL     
}

#λȡpoolname
MemPoolUsage_GetPollName()
{
      case $1 in
        1)
            echo "Pool[mds.$i]"  
            ;;
        2)
            echo "Pool[ds.$2]" 
            ;;    
        3)
            echo "Pool[ca.$2]" 
            ;;    
        4)
            echo "Pool[monc.$2]" 
            ;;   
        5)
            echo "Pool[mons.$2]"  
            ;;
        6)
            echo "Pool[base.$2]" 
            ;;    
        7)
            echo "Pool[cm.$2]" 
            ;;    
        8)
            echo "Pool[unk.$2]" 
            ;;               
        *)
            echo "Pool[UNKNOWN]"
            ;;
    esac
}

#215. ڴʹ
checkMemPoolUsage_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local Remote_filename="MemPoolUsage"
    local TASK_ID=0
    local isPass=0
    local isflag=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local Info=""
    local Info_one=""
    local PoolName=""
    
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 120 GetMemPoolUsageInfo $FUNCNAME
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get GetMemPoolUsageInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi    
            
            for i in {1..8};
            do 
                /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE$Item$i $G_REMOTE_TMP_FILE$Remote_filename$i
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME]:Node:$Item||INFO:download pool($i) info fail,iRet($iRet)"
                    Result="Node:$Item||INFO:download pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result" 
                    isPass=1
                    continue
                fi
                
                Info=""
                Info_one=""
                Total_Count=0
                
                Info=`cat $G_TMP_FILE$Item$i | grep "total size"`
                if [ "$Info" == "" ];then
                    Info=`cat $G_TMP_FILE$Item$i | grep "alloc client_id"`
                    cat $G_TMP_FILE$Item$i  >> $LOG_FILE
                    LOG "[$FUNCNAME]:Node:$Item||INFO:get pool($i) info fail,Info($Info)"
                    
                    Result="Node:$Item||INFO:get pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                   
                    isPass=1
                    continue
                fi
                
                set_ifs
                
                #ȡ
                Total_Count=`cat $G_TMP_FILE$Item$i | grep "total size" | wc -l`
                numCnt=1
                while [ $numCnt -le $Total_Count ]; do
                    #ȡݣ
                    Pool=""
                    Info_one=`cat $G_TMP_FILE$Item$i | grep "total size" |  awk NR==$numCnt`
                    
                    isflag=`echo $Info_one |grep ">>>"`
                    if [ "$isflag" == "" ];then
                        PoolName=`cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt | awk -F'Pool' '{print $2}' | awk -F'[' '{print $2}' | awk -F']' '{print $1}'`
                        if [ "$PoolName" == "" ];then
                            numCnt_new=numCnt=$((numCnt-1))
                            Pool=`NvdimmPool_GetPollName $i $numCnt_new`
                        else
                            Pool="Pool[$PoolName]"
                        fi
                    else
                        numCnt_new=numCnt=$((numCnt-1))
                        Pool=`MemPoolUsage_GetPollName $i $numCnt_new`
                    fi
                    
                    totalsize=`echo $Info_one|awk '{print $4}'`
                    freesize=`echo $Info_one|awk '{print $11}'`
                        
                    usedSize=`expr $totalsize \- $freesize`
                    usedSize_temp=`expr $usedSize \* 100`
                    percentage=`expr $usedSize_temp \/ $totalsize`
                    Result="Node:$Item||INFO: get pool info ok||Pool:$Pool||TotalSize(MB):$totalsize||FreeSize(MB):$freesize||UsedSize(MB):$usedSize||Percentage(%):$percentage"
                    LOG "[$FUNCNAME]:$Result"
                    WRITE_XML_COMMON 0 "$Result"
                    #ģڴռҲģڴռ85%
                    if [ $percentage -ge 85 ];then
                    
                        LOG "[$FUNCNAME]percentage:$percentage"
                        isPass=1
                    fi

                    #¼
                    numCnt=$((numCnt+1))
                done
                restore_ifs
            
            #end for i in {1..8}
            done
            
        #end for Item in $ValidIP 
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done        
     
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    fi
    WRITE_XML_SUBCMD_TAIL     
}

#216. ؼһУ
checkDataConsistent_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    
    local TASK_ID="getinfo"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ڱڵִmds objid show
    while true; do
                            
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO:can't get local ip"
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
            break
        fi
        
        LOG "[$FUNCNAME]back_ip:$back_ip"
        
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "mds objid show" > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            errResult="INFO:Failed to execute command(mds objid show)."
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
            break
        fi
        
        #עrestore_ifs
        set_ifs
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        
        #ȡ
        root_dir1=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "ROOT_DIR"|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $1}'`
        root_dir2=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "ROOT_DIR"|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"| awk -F/ '{print $2}'`
        echo "[$FUNCNAME]root_dir1:$root_dir1 ,root_dir2:$root_dir2"
        
        fs_sblock1=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "FS_SBLOCK" |awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $1}'`
        fs_sblock2=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "FS_SBLOCK" |awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $2}'`
        echo "[$FUNCNAME]fs_sblock1:$fs_sblock1,fs_sblock2: $fs_sblock2"

        #nlun map
        if [ "root_dir1" == "" ] || [ "root_dir1" == "" ] || [ "fs_sblock1" == "" ] || [ "fs_sblock2" == "" ]; then
            errResult="INFO:Failed to get obiid (root_dir1:$root_dir1 ,root_dir2:$root_dir2, fs_sblock1:$fs_sblock1, fs_sblock2: $fs_sblock2)."
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
            restore_ifs
            break
        fi
        
        LOG "[$FUNCNAME]get obiid (root_dir1:$root_dir1 ,root_dir2:$root_dir2,fs_sblock1:$fs_sblock1,fs_sblock2: $fs_sblock2)ok"        
    
        checknlun_Reault=`grep $root_dir1 /proc/monc_nlunmap`
        if [ "$checknlun_Reault" == "" ]; then
            LOG "[$FUNCNAME]checknlun_Reault is Null"
            errResult="INFO:Failed to get nluninfo by $root_dir1."
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
            restore_ifs
            break
        fi
        
        Primary_id=`echo "$checknlun_Reault" | grep Primary| awk '{print $15}'`
        echo "[$FUNCNAME]Primary_id:$Primary_id"
        LOG "[$FUNCNAME]Primary_id:$Primary_id"
        
        Primary_id_new=`expr  2 \* $Primary_id + 3`
        echo "[$FUNCNAME]Primary_id_new:$Primary_id_new"
        LOG "[$FUNCNAME]Primary_id_new:$Primary_id_new"

        DS_ID=`echo "$checknlun_Reault" | awk NR==2 | awk "{print $ $Primary_id_new}" | awk -F"(" '{print $2}' `
        echo "[$FUNCNAME]DS_ID:$DS_ID"
        LOG "[$FUNCNAME]DS_ID:$DS_ID"
        
        #ȡDS_IDӦIPַ
        DS_ID_Address=`grep "DS $DS_ID" /proc/monc_dsmap | awk '{print $14}'`
        echo "[$FUNCNAME]DS_ID_Address:$DS_ID_Address"
        LOG "[$FUNCNAME]DS_ID_Address:$DS_ID_Address"
        
        if [ "$DS_ID_Address" == "" ]; then
            LOG "DS_ID_Address is Null"
            errResult="INFO:Failed to get DS Address fail."
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
            restore_ifs
            break
        fi
        
        #Ƚroot_dirһ
        rootdir_result=`remote_exec $DS_ID_Address 30 "$G_MML_FILE_PATH/ShowDataConsistent $DS_ID_Address 'check consfile $root_dir1 $root_dir2' ROOT_DIR 2>&1"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="INFO:Failed to execute($DS_ID_Address,check consfile $root_dir1 $root_dir2),iRet($iRet),errinfo($rootdir_result)"
            LOG "[$FUNCNAME]Failed to execute($DS_ID_Address,check consfile $root_dir1 $root_dir2),iRet($iRet),errinfo($rootdir_result)"
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
        else
            WRITE_XML_COMMON 0 "$rootdir_result"            
        fi
                
        #ȽFS_SBLOCKһ
        fssblock_result=`remote_exec $DS_ID_Address 30 "$G_MML_FILE_PATH/ShowDataConsistent $DS_ID_Address 'check consfile $fs_sblock1 $fs_sblock2' FS_SBLOCK 2>&1"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="INFO:Failed to execute($DS_ID_Address,check consfile $fs_sblock1 $fs_sblock2),iRet($iRet),errinfo($fssblock_result)"
            LOG "[$FUNCNAME] Failed to execute($DS_ID_Address,check consfile $fs_sblock1 $fs_sblock2),iRet($iRet),errinfo($fssblock_result)"
            
            WRITE_XML_COMMON 0 "$errResult"
            isPass=1
        else
            WRITE_XML_COMMON 0 "$fssblock_result"       
        fi
            
        restore_ifs
        break
    done  
  
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL     
}

hextoip() {
    hex=$1
    printf "%d." 0x${hex:0:2}
    printf "%d." 0x${hex:2:2}
    printf "%d." 0x${hex:4:2}
    printf "%d" 0x${hex:6:2}
}

#217. ȫϵͳinode
checkFileInode()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local faildInfo=""
    local exe_result=""
    local MDSMaster=""
        
    while true; do
        
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            Result="INFO:Can't get local ip"
            LOG "[$FUNCNAME]:$Result"
            isPass=1
            break
        fi
        
        #ִmml mds info show
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "mds info show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="INFO: Failed to execute command(mds info show)."
            isPass=1
            break
        fi

        MDSMaster=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`    
        if [ "$MDSMaster" == "" ];then
            isPass=1
            
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            
            Result="INFO:Failed to get MDS master."
            break
        fi
        
        #16ƵַʽתΪipv4͵ַ
        mdsMastertmp=$MDSMaster
        mdsMasterIP=`hextoip "${mdsMastertmp}"`
        LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
            
        #MDSִMMLinode, ִmml mds info show
        remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"        
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "[$FUNCNAME]:iRet($iRet)"
            Result="INFO:Failed to execute command($mdsMasterIP 988 'mds info show')."
            isPass=1
            break
        fi

        #
        remote_download $mdsMasterIP $G_TMP_FILE $G_REMOTE_TMP_FILE2$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]download inode infp from $mdsMasterIP fail"
            WRITE_XML_COMMON 0 "INFO:download inode infp from $mdsMasterIP fail"
            break       
        fi

        exe_result=`cat $G_TMP_FILE | grep 'Sys Inode Count'` 
        LOG "[$FUNCNAME]exe_result:$exe_result"
        if [ "$exe_result" == "" ];then
           Result="INFO:Failed to get Inode Count." 
           isPass=1
           
           #
           cat $G_TMP_FILE >> $LOG_FILE 2>&1
        else
            
            inodeCount=`echo $exe_result | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            nodeCount=`cat $IP_ROLE_FILE| awk '{print NF}' `

            value=50000000
            rate=`echo $nodeCount*$value*0.8|bc -l`
            
            Result="nodeCount:$nodeCount||InodeCount:$inodeCount"
            LOG "[$FUNCNAME],nodeCount:$nodeCount||InodeCount:$inodeCount||rate: $rate"
                 
            if [ `echo "$inodeCount > $rate" | bc` -eq 1 ];then 
                isPass=1
                
                #
                cat $G_TMP_FILE >> $LOG_FILE 2>&1
            fi
        fi
        
        break
    done
       
    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass

    WRITE_XML_SUBCMD_TAIL     
}

#219. Ŀ¼ļֵѲȡֵĿ¼б,Ĭ10000
checkBigDir()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch_mml $TASK_ID 30 ShowBigFile $FUNCNAME
    isPass=$?
        
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}

        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ShowBigFile information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi           
            
            dos2unix $G_TMP_FILE$Item
            set_ifs
            
            dirnum=`cat $G_TMP_FILE$Item | grep "dir ino" | wc -l`        
            LOG "[$FUNCNAME]:dirnum:$dirnum"
            if [ "$dirnum" == 0 ] ; then
                WRITE_XML_COMMON 0 "Node:$Item||INFO:Number of directories with excessive files:0" 
                
                restore_ifs
                continue
            fi
            
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            
            isPass=1
            WRITE_XML_COMMON 0 "Node:$Item||INFO:Number of directories with excessive files:$dirnum"
            restore_ifs
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else 
        WRITE_XML_ERROR 0 "$errResult"
        WRITE_XML_JUDGE 1
    fi
 
    WRITE_XML_SUBCMD_TAIL     
}


#220. linuxϵͳ򿪵ļ
checkSystemFileOpened()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID 30 "cat /proc/sys/fs/file-nr > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?
   
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #ؽ/proc/sys/fs/file-nr
            remote_exec_checkfini $Item $TASK_ID "Can not get /proc/sys/fs/file-nr information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi        
            
            usedunm=`cat $G_TMP_FILE$Item|awk '{print $1}'`
            unusedunm=`cat $G_TMP_FILE$Item|awk '{print $2}'`
            maxCount=`cat $G_TMP_FILE$Item|awk '{print $3}'`
            fileCount=`expr $usedunm + $unusedunm`
            
            LOG "[$FUNCNAME]:usedunm:$usedunm,unusedunm:$unusedunm,fileCount:$fileCount,maxCount:$maxCount"
            
            percentage=`echo $fileCount*100/$maxCount|bc -l`
            
            Result="Node:$Item||FileCount:$fileCount||MaxFileCount:$maxCount||Percentage(%):$percentage"
            if [ `echo "$percentage > 95" | bc` -eq 1  ];then
                isPass=1
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            fi
            
            WRITE_XML_COMMON 0 "$Result"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    WRITE_XML_JUDGE $isPass
    
    WRITE_XML_SUBCMD_TAIL     
}

#221. NIS
checkNIS()
{
    WRITE_XML_SUBCMD_HEADER $1    
    local isPass=0
    local NisInfo=0
    local isExistFlag=0;
    local ypwhichinfo=""
    local errinfo=""
    
    while true; do
        $G_MML_FILE_PATH/ShowNisServer  > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        
        set_ifs 
        while read line; do
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                isPass=1
            fi
            
            WRITE_XML_COMMON 0 "nis_server info:$info"
            
            #жǷnis server
            NisInfo=`echo $info | grep "no nis_server"`
            if [ "$NisInfo" != "" ];then
                isExistFlag=1
            fi
            
        done < $G_REMOTE_TMP_FILE$FUNCNAME
        restore_ifs

        break
    done

    #
    LOG "[$FUNCNAME]:isPass:$isPass,isExistFlag:$isExistFlag"
    cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1 
    
    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then
        
        #Զִypwhich鿴    
        ValidIP=`cat $IP_ROLE_FILE`

        while [[ ${ValidIP} != "" ]]
        do     
            for Item in $ValidIP 
            do
                    
            #鿴ÿڵ
            ypwhichinfo=`remote_exec $Item 10 "ypwhich"`
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME] $Item Failed to execute(free) command.iRet($iRet)"
                isPass=1
                
                Result="Node:$Item||nis_server status:Failed to execute(ypwhich) command.iRet($iRet)"
                WRITE_XML_ERROR 0 "$Result"
                continue
            fi
        
            
            errinfo=""
            errinfo=`echo $ypwhichinfo | grep "Can't communicate with ypbind"`
            if [ "$errinfo" != "" ]; then
                
                LOG "[$FUNCNAME]errinfo:$errinfo"
                Result="Node:$Item||nis_server status:Can't communicate with ypbind"
                WRITE_XML_ERROR 0 "$Result"
                isPass=1
            else
                Result="Node:$Item||nis_server status:ok"
                WRITE_XML_ERROR 0 "$Result"
            fi
                
            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done        
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL     
}

#222 ⲿDNSǷͨ
checkExtDnsConn()
{    
    WRITE_XML_SUBCMD_HEADER $1
 
    local TASK_ID=0
    local isPass=0
    local AllDnsService=""
    local DnsNum=0
    local errResult=""
    local Result=""
    local Item=""
    local ValidIP=""
    local extDnsServe=""
    local serverConn=""
    lcoal numCnt=1
    
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    while true; do
    
        #ȡⲿDNSûΪͨ
        AllDnsService=`cat /etc/resolv.conf | grep ^nameserver | awk '{print $2}'`
        DnsNum=`echo "$AllDnsService" | wc -l`
        
        LOG "[$FUNCNAME]:AllDnsService:$AllDnsService,DnsNum:$DnsNum"
        if [ "$DnsNum" -le "0" ] || [ "$AllDnsService" == "" ] ;then
           
            Result="DNS_server: -- ||INFO: DNS server does not exist"
            
            WRITE_XML_COMMON 0 "$Result"
            cat /etc/resolv.conf >>  $LOG_FILE
           
            break
        fi
        
        extDnsServe=""
        serverConn=""
        numCnt=1
        while [ $numCnt -le $DnsNum ]; do 
        
            extDnsServe=` echo $AllDnsService | awk '{print $ '$numCnt'}'`

            #״̬
            if [ "$extDnsServe" == "" ];then
                LOG "[$FUNCNAME]:failed numCnt:$numCnt,NS server is NULL"
                
                numCnt=$((numCnt+1))
                continue
            fi

            #ڵжdns############################################################################
            >${VALID_IP_FILE}
            TASK_ID=$numCnt
            
            remote_exec_async_batch $TASK_ID 30 "/usr/bin/host test $extDnsServe > $G_REMOTE_TMP_FILE$FUNCNAME$numCnt  2>&1; exit 0"            
            isPass=$?

            ValidIP=`cat ${VALID_IP_FILE}`
            while [ "${ValidIP}" != "" ]; do
                >${VALID_IP_FILE}
                
                for Item in $ValidIP; do
                    #ѯ
                    remote_exec_checkfini $Item $TASK_ID "Can not DNS($extDnsServe) link status"
                    iRet=$?

                    if [ $iRet -eq 0 ];then
                        echo -n "$Item " >> ${VALID_IP_FILE}
                        continue
                    elif [ $iRet -ne 2 ];then
                        LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd(/usr/bin/host test $extDnsServe) failed."
                        isPass=1
                        continue
                    fi

                    remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME$numCnt
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        isPass=1
                        errResult="Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME$numCnt) failed."
                        WRITE_XML_ERROR 0 "$errResult"
                        continue
                    fi

                    #жǷͨ
                    serverConn=`cat $G_TMP_FILE$Item|grep "Using domain server"|wc -l`
                    if [ $serverConn -eq 0 ]
                    then
                        isPass=1
                        Result="DNS_server: $extDnsServe||INFO: DNS server is not connectable."
                        WRITE_XML_COMMON 0 "Node:$Item||$Result"
                        
                        #
                        LOG "[$FUNCNAME]:/usr/bin/host test $extDnsServe result:"
                        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                        
                    else
                        Result="DNS_server: $extDnsServe||INFO: DNS server is connectable."
                        WRITE_XML_COMMON 0 "Node:$Item||$Result"
                    fi
                done
                ValidIP=`cat ${VALID_IP_FILE}`
            done

            ######################################################################################
        
            numCnt=$((numCnt+1)) 
        done
        
        #˳while
        break
    done
   
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL       
}

#223. LDAP
checkLDAP()
{
     WRITE_XML_SUBCMD_HEADER $1    
    local isPass=0
    
    while true; do
        $G_MML_FILE_PATH/ShowLdapServer  > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                
        set_ifs 
        while read line; do
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                isPass=1
            fi
             
            WRITE_XML_COMMON 0 "$info"
            
        done < $G_REMOTE_TMP_FILE$FUNCNAME
        restore_ifs

        break
    done
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL 
}

#224. ڵIPMIַ
checkIPMI()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isFlag=1
    local filename="checkIPMI"
    local TASK_ID=0
    local isPass=0
    
    set_ifs    
    #ȡصomip
    OMIPAddress=`cat /opt/huawei/snas/etc/cm.ini|grep omip|awk -F= '{print $2}'`
    LOG "[$FUNCNAME]omip: $OMIPAddress"
    restore_ifs
    
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetIPMIAddress  2>&1"
    isPass=$? 
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get GetIPMIAddress information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            #ű̶ѽд$G_REMOTE_TMP_FILE$Item
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$filename
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #IPMIַ
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            
            connectState=""
            ipmi_ip=`cat $G_TMP_FILE$Item |grep "IP Address"|grep -v Source|awk -F: '{print $2}'`
            if [ "$ipmi_ip" == "" ];then
                ipmi_ip="--"
                connectState="no IPMI"
                errResult="Node: $Item||Error: can not get IPMI address!||$errResult"
                LOG "[$FUNCNAME] $Item:can not get IPMI address!"
                isPass=1
            else            
                #ͨomip ping ipmi 
                tempStr_ping=`ping -q -c 2 $ipmi_ip -I $OMIPAddress | grep received | awk '{print $4}'`
                LOG "Node:$Item, ipmi:$ipmi_ip,omip:$OMIPAddress,tempStr_ping:$tempStr_ping"
                if [ 0 != $tempStr_ping ];then
                    connectState="OK"
                else 
                    connectState="Can not access."
                    isPass=1
                fi                     
            fi
            
            Result="Node:$Item||IPMI:$ipmi_ip||ConnectingStatus:$connectState"
            LOG "[$FUNCNAME]Node:$Item||$Result"
            WRITE_XML_COMMON 0 "$Result"
            
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else 
        WRITE_XML_ERROR 0 "$errResult"
        WRITE_XML_JUDGE 1
    fi
    
    WRITE_XML_SUBCMD_TAIL    
}

#DiskPoolֵ
Checkdiskpoolcap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local PoolType=""
    local PoolTypeindex=0
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0
    
    dos2unix $G_TMP_FILE$Item
    
    TierInfoCount=`cat $G_TMP_FILE$Item | grep "DiskPool"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"
    
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep DiskPool | awk NR==$index` 
    
        PoolTypeindex=`cat $G_TMP_FILE$Item | grep -A5 "$HeadInfo" | grep PoolType | awk -F: '{print $2}'`
        PoolType="SSD"
        if [ "$PoolTypeindex" == "1" ]; then
            PoolType="HDD"    
        fi
        
        TotalCap=`cat $G_TMP_FILE$Item | grep -A5 "$HeadInfo" | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A5 "$HeadInfo" | grep LeftCap | awk -F: '{print $2}'`
        
        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        
        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ]; then 
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi
        
        index=$((index + 1 ))
    done
      
    return $isok
}

#NodePoolֵ
CheckNodePoolCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0
    
    dos2unix $G_TMP_FILE$Item
    
    TierInfoCount=`cat $G_TMP_FILE$Item | grep "NodePool"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"
  
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep NodePool | awk NR==$index` 
       
        TotalCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep LeftCap | awk -F: '{print $2}'`
        
        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        
        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ];then 
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi
       
        index=$((index + 1 ))
    done
      
    return $isok
}

#Tiercapֵ
CheckTierCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0
    
    dos2unix $G_TMP_FILE$Item
    
    TierInfoCount=`cat $G_TMP_FILE$Item | grep "Tier"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep Tier | awk NR==$index` 
       
        TotalCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep LeftCap | awk -F: '{print $2}'`
        
        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        
        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ];then 
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi
   
        index=$((index + 1 ))
    done
      
    return $isok
}

#225.ּ
checkTier()
{
    WRITE_XML_SUBCMD_HEADER $1
    local count=0
    local Result=""
    local isPass=0
    local Item=""
    
    while true; do
        #ȡmonĵַ
        set_ifs
        
        Item=`cat /proc/monc_leader | grep "Mon leader" |awk '{print $3}'`
        LOG "[$FUNCNAME]:MonMasterIP:$Item"
        
        #ִmon tiercap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon tiercap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1" 
        remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[Tier]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get TierCap info"
            WRITE_XML_COMMON 0 "MonMaster:$Item||INFO: can't get TierCap info"
        else
            #
            CheckTierCap
            if [ $? -ne 0 ]; then
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi       
        fi
        
        #ִmon nodepoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon nodepoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[NODE] 2>&1" 
        remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[NODE]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get nodepoolcap info"
            WRITE_XML_COMMON 0 "MonMaster:$Item||INFO: can't get nodepoolcap info"
        else
            #
            CheckNodePoolCap 
            if [ $? -ne 0 ]; then
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi    
                
        #ִmon diskpoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon diskpoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[DISK] 2>&1" 
        remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[DISK]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get diskpoolcap info"
            WRITE_XML_COMMON 0 "MonMaster:$Item||INFO: can't get diskpoolcap info"
        else
            #
            Checkdiskpoolcap 
            if [ $? -ne 0 ]; then
            
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi    
        
        restore_ifs
        break
    done
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL        
}

#227Ƿδĸ澯
checkLeftAlarm_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local IPAddress=""
   
    while true; do
         
        IPAddress=`get_backnet_ip`
        if [ "$IPAddress" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi
        
        set_ifs
        $G_MML_FILE_PATH/ShowInspectMml $IPAddress 4016  "cm clearalarm show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            errResult="Node:$IPAddress||INFO: can't get information,exec(cm clearalarm show) failed!"
            LOG "[$FUNCNAME]$IPAddress:can't get information,exec(cm clearalarm show) failed!." 
            isPass=1
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep uiUnClearAlarmCount | sed 's/^ *//g'|sed "/^$/d"`
        
            if [ "$javaID" == "" ];then
                errResult="Node:$IPAddress||INFO: get Fiber_Count failed!"
                LOG "[$FUNCNAME]$IPAddress:get Fiber_Count failed!" 
                isPass=1
                
                #
                cat $G_REMOTE_TMP_FILE$FUNCNAME >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            fi 
             
            LOG "[$FUNCNAME]javaID:$javaID"
            exe_status=`echo $javaID|grep 'success'`
            count=`echo $javaID|awk '{print $6}'`
            isexist="yes"
            
            #ִн
            if [ "$exe_status" != "" ];then
                exe_result="success"
            else
                exe_result="fail"
                isPass=1
            fi        
                   
            LOG "[$FUNCNAME]exe_status:($exe_status),exe_result:($exe_result), count:($count)"         
            if [ "$count" == "0" ];then
                isexist="no"
                Result="execution_result:$exe_result||Any uncleared alarm exists:$isexist"
            else        
                Result="execution_result:$exe_result||Any uncleared alarm exists:$isexist"
                isPass=1
            fi
            
            LOG "[$FUNCNAME]:Result:$Result"
            WRITE_XML_COMMON 0 "$Result"    
        fi
                
        restore_ifs
        break
    done
    
    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"     
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}  
            
#228 ҵڵ
checkMasterStatus()
{
    WRITE_XML_SUBCMD_HEADER $1 
    local isPass=0
    local errResult=""
    local Result=""
    local TASK_ID=0
    
    set_ifs
    #ȡcmϢΪ׼    
    mon_base=`cat /proc/monc_leader | grep Mon | awk '{print $3}'`
    mds_base=`cat /proc/monc_leader | grep Mds | awk '{print $3}'`
    pip_base=`cat /proc/monc_leader | grep Pip | awk '{print $3}'`
    restore_ifs

    LOG "[$FUNCNAME]:mon_base:$mon_base||mds_base:$mds_base||pip_leader:$pip_base"
    
    if [ "$mon_base" == "" ] || [ "$mds_base" == "" ] || [ "$pip_base" == "" ]; then             
       isPass=1
       errResult="Node:$Item||INFO:Failed to get monc_leader info form cm master"
    else     
        REMOTE_IP_S=`cat $IP_ROLE_FILE`

        remote_exec_async_batch $TASK_ID 30 "cat /proc/monc_leader > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        isPass=$?
        
        ValidIP=`cat ${VALID_IP_FILE}`

        while [ "${ValidIP}" != "" ]; do
            >${VALID_IP_FILE}
            
            for Item in $ValidIP; do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not monc_leader information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    errResult="Node:$Item||INFO:Failed to get monc_leader info||$errResult"
                    isPass=1
                    continue
                fi
             
                mon_leader=`cat $G_TMP_FILE$Item | grep Mon | awk '{print $3}'`
                mds_leader=`cat $G_TMP_FILE$Item | grep Mds | awk '{print $3}'`
                pip_leader=`cat $G_TMP_FILE$Item | grep Pip | awk '{print $3}'`
                
                Result="Node:$Item||mon_leader:$mon_leader||mds_leader:$mds_leader||pip_leader:$pip_leader"
                restore_ifs
                LOG "[$FUNCNAME]:Result:$Result"
                WRITE_XML_ERROR 0 "$Result"
       
                if [ "$mon_leader" == "" ] || [ "$mds_leader" == "" ] || [ "$pip_leader" == "" ] || [ "$mon_leader" != "$mon_base" ] || [ "$mds_leader" != "$mds_base" ] || [ "$pip_leader" != "$pip_base" ]; then             
                    isPass=1
                fi
                
                >$G_TMP_FILE$Item
                
            done

            ValidIP=`cat ${VALID_IP_FILE}`
        done
    fi
    
    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL 
 }
 
#229 mon server 
checkMonServer()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    
    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowMonServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not mon Server information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue;
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:$Item||INFO:$info||${errResult}"
                else
                    MonServer_NUM=`cat $G_TMP_FILE$Item | grep "Server_num" | awk -F= '{print $2}'`
                    MonServer_IP=`cat $G_TMP_FILE$Item | grep "Server_IP" | awk -F= '{print $2}'`
                    WRITE_XML_COMMON 0 "Node:$Item||MonServer_NUM:$MonServer_NUM||MonServer_IP:$MonServer_IP"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL 
 }

#λȡpoolname
NvdimmPool_GetPollName()
{
    case $1 in
        5)
            echo "Pool[nvcache.0]"  
            ;;
        6)
            echo "Pool[trns.0]" 
            ;;    
        7)
            echo "Pool[ds.0]" 
            ;;    
        8)
            echo "Pool[quota.0]" 
            ;;    
        *)
            echo "Pool[UNKNOWN]"
            ;;
    esac
}

#230 Nvdimmڴصʹ 
checkNvdimmPool()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local fimename="NvdimmPool"
    local TASK_ID="getinfo"
    local isPass=0
    local isflag=""
    local Info=""
    local Info_one=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local PoolName=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch_mml $TASK_ID 120 GetNvdimmPoolUsage $FUNCNAME
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get NvdimmPool information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi    
            
            for i in {5..8};
            do 
                Info=""
                /opt/huawei/deploy/script/localexec.py download $Item $G_TMP_FILE$Item$i $G_REMOTE_TMP_FILE$fimename$i
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME]:Node:$Item||INFO:download pool($i) info fail,iRet($iRet)"
                    Result="Node:$Item||INFO:download pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result" 
                    isPass=1
                    continue
                fi
                
                #жǷΪûnvdimmµ 
                isNvdimm=`cat $G_TMP_FILE$Item$i | grep "no nvdimm, no need to get"`
                if [ "$isNvdimm" != "" ] ;then
                    Result="Node:$Item||INFO: no nvdimm, no need to get"
                    WRITE_XML_COMMON 0 "$Result"
                    continue
                fi
                
                Info=`cat $G_TMP_FILE$Item$i | grep "total size"`
                if [ "$Info" == "" ];then
                    Info=`cat $G_TMP_FILE$Item$i`
                    LOG "[$FUNCNAME]:Node:$Item||INFO:get pool($i) info fail,Info($Info)"
                    
                    Result="Node:$Item||INFO:get Nvdimm pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                   
                    isPass=1
                    continue
                fi
                
                set_ifs
                
                #ȡ
                Total_Count=`cat $G_TMP_FILE$Item$i | grep "total size" | wc -l`
                numCnt=1
                while [ $numCnt -le $Total_Count ]; do
                    #ȡݣ
                    Info_one=`cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt`
                    
                    isflag=`echo $Info_one |grep ">>>"`
                    if [ "$isflag" == "" ];then
                        PoolName=`cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt | awk -F'Pool' '{print $2}' | awk -F'[' '{print $2}' | awk -F']' '{print $1}'`
                        if [ "$PoolName" == "" ];then
                            Pool=`NvdimmPool_GetPollName $i`
                        else
                            Pool="Pool[$PoolName]"
                        fi
                    else
                        Pool=`NvdimmPool_GetPollName $i`
                    fi
                    
                    totalsize=`echo $Info_one|awk '{print $4}'`
                    freesize=`echo $Info_one|awk '{print $11}'`
                        
                    usedSize=`expr $totalsize \- $freesize`
                        
                    usedSize_temp=`expr $usedSize \* 100`
                    percentage=`expr $usedSize_temp \/ $totalsize`
                    Result="Node:$Item||INFO: get pool info ok||Pool:$Pool||TotalSize(MB):$totalsize||FreeSize(MB):$freesize||UsedSize(MB):$usedSize||Percentage(%):$percentage"
                    LOG "[$FUNCNAME]:$Result"
                    
                    WRITE_XML_COMMON 0 "$Result"
                    #ģڴռҲģڴռ85%
                    if [ $percentage -ge 90 ];then
                        isPass=1
                    fi

                    #¼
                    numCnt=$((numCnt+1))
                done
                restore_ifs

            done 
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done        
     
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    fi
    WRITE_XML_SUBCMD_TAIL   
}

#231ݻָ״̬
checkDataRestore()
{ 
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local fimename="NvMem"
    local TASK_ID="getinfo"
    local isPass=0
    
    #mapǷݻָ
    recover_task_num=`cat /proc/monc_recoverymap  | egrep "RTask|epoch" | wc -l`
    if [ "$recover_task_num" -ne 1 ]; then
       LOG "[$FUNCNAME]the number of recover task:$recover_task_num"
       let recover_task_num=$recover_task_num-1
       
       isPass=1
       
       Result="the number of recover task:$recover_task_num"
       WRITE_XML_COMMON 0 "${Result}"
       
    else
        #ûݻָ£鿴ÿڵҪָnlunĸ        
        REMOTE_IP_S=`cat $IP_ROLE_FILE`    
        remote_exec_async_batch_mml $TASK_ID 60 ShowDataRestore $FUNCNAME
        isPass=$?
        
        ValidIP=`cat ${VALID_IP_FILE}`

        while [[ ${ValidIP} != "" ]]
        do     
            >${VALID_IP_FILE}
            
            for Item in $ValidIP 
            do
                Result=""

                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get Data Recover information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 ];then
                    isPass=1
                    continue
                fi    
                           
                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    isPass=1
                    continue;
                fi
                
                set_ifs 
                while read line; do
                    info=`handle_remote_result "$line"`
                    if [ $? -ne 0 ]; then
                        isPass=1
                    fi
                    
                    WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"
                    
                done < $G_TMP_FILE$Item
                restore_ifs                

            done
            ValidIP=`cat ${VALID_IP_FILE}`
        done    
    
    fi           
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL  
} 
  
#232 ѯǷڵݻָ
getDataRcvrTask()
{ 
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
  
    if [ -f /opt/huawei/snas/etc/cm_task.db ]
    then
        #ʱmsdateȡʱ룬Ҫת
        taskFiTime=`sqlite3 /opt/huawei/snas/etc/cm_task.db 'select FINISHTIME from CM_TASK_T  where OPTID=4;'`
        taskStartTime=`sqlite3 /opt/huawei/snas/etc/cm_task.db 'select STARTTIME from CM_TASK_T  where OPTID=4;'`
        currTime=`date +%s`
        #ʱ3ڵ
        for task in $taskFiTime
        do
            if [ $((task+259200000)) -gt $((currTime*1000)) ]
            then
                errResult="There are data recovery tasks in recent 3 days."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                break;
            fi
        done
        #鿪ʼʱ3ڵ
        for task in $taskStartTime
        do
            if [ $((task+259200000)) -gt $((currTime*1000)) ]
            then
                errResult="There are data recovery tasks in recent 3 days."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                break;
            fi
        done
    fi
    
    if [ $isPass -eq 0 ]
    then
        errResult="There is no data recovery task in recent 3 days."
        WRITE_XML_COMMON 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#233 nlun״̬
getNlunStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local TASK_ID=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID 30 "cat /proc/monc_nlunmap > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get monc_nlunmap information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi    

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            dos2unix $G_TMP_FILE$Item
            
            set_ifs
            
            cat $G_TMP_FILE$Item | grep State  | grep -v 'State 0' > $G_TMP_FILE2$Item
            
            lineNum=`cat $G_TMP_FILE2$Item|wc -l`
            
            Result="Nlun State:--------------------------------------------------||Nlun State:Node:$Item||Nlun State:The number of State is not 0:$lineNum"
            WRITE_XML_COMMON 0 "$Result"        
            
            if [ "$lineNum" != 0 ]; then 
                isPass=1
                top_20=`cat $G_TMP_FILE2$Item | head -20| sed 's/</(lt)/g'`
                 
                Result=""
                for line in $top_20; do
                    if [ "" != "${Result}" ];then
                        Result="$Result||Nlun State:$line"
                    else
                        Result="Nlun State:$line"
                    fi
                done           

                Result="Nlun State:--------------detail--------------||${Result}"
                WRITE_XML_COMMON 0 "$Result"
            fi
        
            restore_ifs
        
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done        
     
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL   
}
#234 MONǷƵѡ 
 checkMonHealth()
 {
     WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    
    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch_mml $TASK_ID 30 ShowMonitorHealth $FUNCNAME
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Cann't get MonHealth "
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue;
            fi 
            dos2unix $G_TMP_FILE$Item
            
            Ret=`cat $G_TMP_FILE$Item | grep bootstrap | tr -d " "| awk -F: '{printf $2}'`
            Ret1=`cat $G_TMP_FILE$Item | grep elec | tr -d " " | awk -F: '{printf $2}'`
            if [ "$Ret" != "OK" ] || [ $Ret1 != "OK" ];then
                cat $G_TMP_FILE$Item >> $LOG_FILE
                isPass=1 
            fi 
            
            Result="NodeIp:$Item||Bootstrap:$Ret||Elec:$Ret1"
            WRITE_XML_COMMON 0 "$Result" 
            
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL 
 }
 
#235 MDSһ
checkMdsSubTreeStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    
    #Զ첽ִҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch_mml $TASK_ID 30 CheckMdsSubTree $FUNCNAME
    isPass=$?  
 
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        for Item in $ValidIP 
        do
            remote_exec_checkfini $Item $TASK_ID "Can not get mds SubTree information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi
             
            #Ϊ100%֮ļأн            
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi
            
            #ǷokSubtree checkup OK.Subtree checkup failed
            checkRst=`cat $G_TMP_FILE$Item|grep "checkup OK"`
            if [ "$checkRst" == "" ]
            then
                errResult="Node: $Item||INFO: mds subtree is not accordant."
                WRITE_XML_ERROR 0 "$errResult"
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                
                isPass=1
            else
                errResult="Node: $Item||INFO: mds subtree is accordant."
                WRITE_XML_COMMON 0 "$errResult"
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# 236 ǷCOREļ
checkCoreFile()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    #ֱ/var/log/kbox/crash/corefileĿ¼вǷн30ļ
    remote_exec_async_batch $TASK_ID 120 "find /var/log/kbox/crash -mtime -30 ! -type d -print > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;find /corefile -mtime -30 ! -type d -print >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;exit 0"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get core information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi

            #ǷcoreļȣļмУоcoreļблļٻһ
            corefile=`cat $G_TMP_FILE$Item|awk 'END {print NR}'`
            if [ $corefile -ge 2 ]
            then
                isPass=1
                errResult="Node: $Item||INFO: node has corefile or crash file."
                WRITE_XML_ERROR 0 "$errResult"
            else
                errResult="Node: $Item||INFO: node has no corefile or crash file."
                WRITE_XML_COMMON 0 "$errResult"
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#237 NTP״̬
checkNtpConn()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    #DNSڣжǷͨ
    remote_exec_async_batch $TASK_ID 120 "ntpq -p > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get verify information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi

            #״̬
            serverConn=`cat $G_TMP_FILE$Item|grep offset|wc -l`
            if [ $serverConn -eq 0 ]
            then
                isPass=1
                errResult="Node: $Item||INFO: ntp is unreachable."
                WRITE_XML_ERROR 0 "$errResult"
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                                
            else
                #offsetƫ
                curntp=`cat dongtest | grep "*"`
                if [ "$curntp" == "" ];then
                    offset=`tac $G_TMP_FILE$Item|awk '{print $9}'|sed -n '1p'`
                else    
                    offset=`echo $curntp |awk '{print $9}'|sed -n '1p'`
                fi
                
                LOG "[$FUNCNAME]:offset:$offset"
                if [ `echo "$offset < 7200000"|bc` -eq 1 ] && [ `echo "$offset > -7200000"|bc` -eq 1 ] ;then
                    errResult="Node: $Item||INFO: ntp is normal."
                    WRITE_XML_COMMON 0 "$errResult"
                else
                    isPass=1
                    errResult="Node: $Item||INFO: ntp offset is more than 7200000."
                    WRITE_XML_ERROR 0 "$errResult"
                    
                    #
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                fi
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#нڵĵĺIP
function GetBackIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    
    > $IP_ROLE_FILE
    #ݿȡнڵĺIP
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do 

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`
         
        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        if [ "$localNID" == "$lastNID" ];then
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))
            
            continue
        fi
        
        #pingһ¼Ƿͨ
        tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`

        #
        numCnt=$((numCnt+1))
        lastNID=$localNID
        
        if [ "$tempStr_ping" -le 0 ];then
            LOG "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"
            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`    
            
            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                LOG "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"
                
                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    LOG "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi
    
        #жϽڵǷúͶ        
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then 
            Status_value=`echo $Status_info | awk -F= '{print $2}'`
            if [ "$Status_value" == "0" ];then  
                echo -n "$ItemIp " >> $IP_ROLE_FILE
            fi                     
        fi
        
    done    
        
}

# **************************************************************************** #
# Function Name: checkSoftwareStatus
# Description: Software м.
# Parameter: $1 cmditemID
# Return: 
# **************************************************************************** #
checkSoftwareStatus()
{
    WRITE_XML_CMD_HEADER $1
  
    GetBackIPAndRoleFromDB  
    LOG_Check
    
    LOG "[$FUNCNAME] param = ($1)"
    case $1 in
        200)
            #1.Check System Information
            checkSystemInfo_MML "0"  
            ;;
        201)
            #2.Check Open File Count
            checkOpenFileCount_Async "0"
            ;;
        202)#ڵ
            #3.Check Node Throughput 
            checkNodeThroughput  "0"
            ;;
        203)
            #4.Check Node IO Perform 
            checkNodeIOPerform  "0"
            ;;
        204)
            #4.Check Watchdog Status
            checkWatchdogStatus_Async "0"
            ;;
        205)
            #5.Check Monitor's Map status(monϵͳ״̬ mds ds ca pip mapϢ)
            checkMonitorHeartbeat_Async "0"
            ;;
        206)
            #6.Check NTP Service
            checkNTPService_Async "0"
            ;;
        207)
            #7.Check CM master
            checkCMMaster "0"
            ;;
        208)
            #8.Check ISM status
            checkISMStatus_Async "0"
            ;;
        209)
            #9.Check License status
            checkLicenseStatus_MML "0"
            ;;
        210)
            #10.Check File operationļ
            checkFileOperation_Async "0"
            ;;
        211)
            #11.Check NAS client
            checkALLClient "0"
            ;;    
        212)
            #12.Check NAS Cluster Status
            checkNASClusterStatus "0"
            ;;
        213)
            #13.Check DS Usage
            checkDSUsage "0"
            ;;
        214)
            #14.Check Communication Link (ڵϵͨѶ·)
            checkCommuLink "0"
            ;;
        215)#ڴصʹ
            #14.Check memory pool usage
            checkMemPoolUsage_Async "0"
            ;;
        216)
            #Check data consistentһ
            checkDataConsistent_Async "0"
            ;;
        217)
            #Check System inode(ȫϵͳinode)
            checkFileInode "0"
            ;;
        219)
            #Check Big file
            checkBigDir "0"
            ;;
        220)#linuxϵͳ򿪵ļ
            #Check system file opened
            checkSystemFileOpened "0"
            ;;
        221)
            #Check NIS ط״̬
            checkNIS "0"
            ;;
        222)
            #Check external DNS
            checkExtDnsConn "0"
            ;;
        223)
            #Check LDAP ط״̬
            checkLDAP "0"
            ;;
        224)
            #Check IPMIַǷ
            checkIPMI "0"
            ;;
        225)
            #Check Tierּ
            checkTier "0"
            ;;           
        227)
            #Ƿδĸ澯
            checkLeftAlarm_MML "0"
            ;;           
        228)
            #ҵڵ״̬  mon mds pip
            checkMasterStatus "0"
            ;;
        229)
            #MON Serverڵ
            checkMonServer "0"
            ;;
        230)
            #Nvdimmڴصʹ
            checkNvdimmPool "0"
            ;;
        231)
            #ݻָ״̬
            checkDataRestore "0"
            ;;
        232)
            #ѯǷڵݻָ
            getDataRcvrTask "0"
            ;;
        233)
            #nlun״̬
            getNlunStatus "0"
            ;;
        234)
            #MONǷƵѡ 
            checkMonHealth "0"
            ;;
        235)
            #mdsһ
            checkMdsSubTreeStatus "0"
            ;;            
        236)
           #Ƿcoreļ
            checkCoreFile "0"
            ;;
        237)
           #ntp״̬
            checkNtpConn "0"
            ;;
            *)
            echo "No this type"
            ;;
    esac

    WRITE_XML_CMD_TAIL
}

