#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect.sh
# Description: Ѳ칤. 
# Input: 
# Output: 
# Author: 
# Created: 
# Function:
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #


G_SCRIPT_PATH=""
L_TMP=$0


G_SCRIPT_PATH=`echo "$L_TMP" |sed "s/inspect.sh//g"`

G_CHECK_RESULT_FILE=/tmp/check_result

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_hardware.sh
. $G_SCRIPT_PATH/inspect_software.sh

cd $G_SCRIPT_PATH 1>/dev/null

execWithTimeout()
{
    #timeout error code
    local err_timeout=125
    #command to be executed
    local command=$1
    #timeout for executing
    local timeout=$2
    #checking interval
    local interval=$3
    #delay for kill -SIGKILL
    local delay=$4
    #execute command
    eval "${command} &"
    sub_pid=$!
    #check sub-process
    local t=$timeout
    while ((t > 0)); do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        ((t -= interval))
        sleep $interval
    done
    #kill sub-process
    kill -15 $sub_pid 2>/dev/null && kill -0 $sub_pid 2>/dev/null || return $err_timeout
    sleep $delay
    kill -0 $sub_pid 2>/dev/null && kill -9 $sub_pid 2>/dev/null
    return $err_timeout
}
echo "[`date`][$2]" >> /tmp/inspect_tmp_bak

rm -rf "$G_CHECK_RESULT_FILE"

WRITE_XML_HEADER
if [ "$2" != "" ]; then
    command=""
    case "$2" in
        1*)
        command="checkHardwareStatus $2"
        ;;
        2*)
        command="checkSoftwareStatus $2"
        ;;
        *)
        echo "There is no appointted item."
        ;;
    esac
    if [ "$command" != "" ];then    
        execWithTimeout "$command" 590 2 2 2>/dev/null    
        if [ "$?" -eq 125 ];then        
           
            WRITE_XML_ERROR 0 "The item is over time and The result does not complete,Please check again!"
            WRITE_XML_JUDGE 1
            WRITE_XML_SUBCMD_TAIL
            WRITE_XML_CMD_TAIL
        fi  
    fi
fi
WRITE_XML_TAIL 

cd - 1>/dev/null
cat $G_CHECK_RESULT_FILE    