#!/bin/bash

# *************************************************************************** #
# File Name: inspect_hardware.sh
# Description: ѲĿеӲ. 
# Input: 
# Output: 
# Author:
# Created:
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile"
G_REMOTE_TMP_FILE="/tmp/tmpfile"

VALID_IP_FILE="/tmp/tmp_valid_ip"

IP_ROLE_FILE="/tmp/tmp_ip_role"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"

LOG_FILE="/var/log/inspect.log"
G_SEPARATOR="#############################################################################"

CMD_IPMI_TIMEOUT=120

function LOG_Check
{
    #create or change log file
    touch $LOG_FILE
    if [ $? -ne 0 ]; then
        echo "Create log file $LOG_FILE failed." 1>&2
        return
    fi

    # delete log file bigger than 10M
    FILE_SIZE=`ls -l $LOG_FILE | cut -d' ' -f 5`
    if [ ! -z "$FILE_SIZE" ]; then
        # delete file when file bigger than 10M
        if [ $FILE_SIZE -gt 10485760 ]; then
            rm -rf $LOG_FILE
        fi
    fi

}

function LOG 
{
    echo [`date`][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ȡڵһIP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'`
    if [ "$subnet_id" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet" 
        return 1
    fi

    set_ifs
    for line in $subnet_id; do
        break
    done
    restore_ifs

    local IPAddress=`grep ipaddr_${line} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet IP" 
        return 1
    fi
    
    echo $IPAddress
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 group by NID"
    if [ $? -ne 0 ]; then
        sleep 1
        sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 group by NID"
        if [ $? -ne 0 ]; then
            LOG "[$FUNCNAME]Failed to get back subnet IP of $nid from db" 
        fi
    fi
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid=$2
    local time_out=$3
    local cmd=$4
    
    /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
    local iRet=$?
    if [ $iRet -ne 0 ]; then
        return $iRet
    fi
    
    return 0
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid=$2
    local err_info=$3

    local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
    local iRet=$?
    LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,progress:$proresult"
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`
    
    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 3    #Զִʧ        
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME] exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command." 
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done
    
    return $ret
}

#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command." 
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi  
    done
    
    return $ret
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
    local iRet=$?
    LOG "[$FUNCNAME] download $remote_file from $remote_ip return:$iRet"
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi
    return $iRet
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

##############################################################################

#100. 
checkDiskUsage()
{
    #df -h
    #ʽFilesystem            Size  Used Avail Use% Mounted on
    #ʽ/dev/sda2             145G   39G  100G  28% /
    #ʽdevtmpfs              936M  100K  936M   1% /dev
    #ʽtmpfs                 936M     0  936M   0% /dev/shm
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "df -hl -x cafs > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get disk information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            javaId=`grep -v Filesystem $G_TMP_FILE$Item | sed 's/^ *//g'|sed "/^$/d"`

            set_ifs
            for line in $javaId; do
                if [ "$line" = "" ];then
                    continue;
                fi

                FileSystem=`echo $line |awk '{print $1}'`
                Size=`echo $line |awk '{print $2}'`
                Used=`echo $line |awk '{print $3}'`
                Avail=`echo $line |awk '{print $4}'`
                Percentage=`echo $line |awk '{print $5}'|sed 's/.$//'`
                Mounted=`echo $line |awk '{print $6}'`

                Result="Node:$Item||FileSystem:$FileSystem||Size:$Size||Used:$Used||Avail:$Avail||Percentage(%):$Percentage||Mounted:$Mounted"
                WRITE_XML_COMMON 0 "$Result"           
                if [ $Percentage -gt 75 ];then
                    isPass=1

                fi
            done
            restore_ifs
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#101. CPU
checkCPUUsage()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowCpu > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get CPU information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
            
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            userUsage=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $2}'`
            sysUsage=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $3}'`
            Percentage=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $4}'`
			crazyTask=`grep "CPU_Usage:" $G_TMP_FILE$Item |awk '{print $5}'`
            #ռcpu5̵Ϣ
            info=`cat $G_TMP_FILE$Item |head -2|tail -1`
            i=0
            Result=""
            while read line; do
                i=$[ $i + 1 ]
                #ǰ
                if [ $i -le 2 ]; then
                    continue
                fi
                if [ "" != "${Result}" ]; then
                    Result="$Result||CPU Usage:$line"
                else
                    Result="CPU Usage:$line"
                fi
            done < $G_TMP_FILE$Item
            

            #ıʶͬӰ칤߽ʾ
            Result="CPU Usage:${G_SEPARATOR}||CPU Usage:$Item||CPU Usage:user(%)-$userUsage
                    ||CPU Usage:system(%)-$sysUsage||CPU Usage:Percentage(%)-$Percentage
                    ||CPU Usage:--------------detail--------------||CPU Usage:$info||${Result}"
	        #ڵǷ߳ռCPU 100% 1
		    if [ $crazyTask -ne 0 ];then
                isPass=1
				Result="$Result||CPU Usage:--------------warning--------------||CPU Usage:Task (PID:$crazyTask) hold CPU over 100% up to 1 min"
            fi
            WRITE_XML_COMMON 0 "$Result"
        
            if [ $(echo "$Percentage < 80"|bc) -ne 1 ];then
                isPass=1
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#102. ڴ
checkMemUsage()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S; do
       
        set_ifs
        free_result=`remote_exec $Item 30 "free"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:$Item||INFO:Failed to execute(free) command.iRet($iRet).||${errResult}"
            LOG "[$FUNCNAME] $Item Failed to execute(free) command.iRet($iRet)"
            isPass=1
            restore_ifs
            continue
        fi
        
        MemTotal=`echo "$free_result" |grep "Mem:"|awk '{print $2}'`
        MemUsed=`echo "$free_result" |grep "-"|awk '{print $3}'`
        Percentage=`expr 100 \* $MemUsed`
        Percentage=`expr $Percentage / $MemTotal`
        
        #ռڴ5̵Ϣ
        info=`remote_exec $Item 30 "ps aux|head -1"`
        top_5=`remote_exec $Item 30 "ps ww aux | sort -k 4nr | head -5|sed 's/</(lt)/g'"`
        top_rss=`echo "$top_5" | head -n 1 | awk '{print $6}'`

        Result=""
        
        for line in $top_5; do
            if [ "" != "${Result}" ];then
                Result="$Result||Memory Usage:$line"
            else
                Result="Memory Usage:$line"
            fi
        done
        restore_ifs

        Result="Memory Usage:${G_SEPARATOR}||Memory Usage:$Item||Memory Usage:TotalMem-$MemTotal
                ||Memory Usage:UsedMem-$MemUsed||Memory Usage:Percentage(%)-$Percentage
                ||Memory Usage:--------------detail--------------||Memory Usage:$info||${Result}"

        WRITE_XML_COMMON 0 "$Result"

        if [ $Percentage -gt 95 ];then
            isPass=1
            errResult="Node:$Item||INFO:Node Memory Usage Is Too High.||${errResult}"
        elif [ $top_rss -gt 1048576 ];then
            isPass=1
            errResult="Node:$Item||INFO:Some Processes Occupy Too Much Physical Memory.||${errResult}"
        fi
        
    done
    
    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#103. ״̬
checkDiskStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local errResult=""
    local isPass=0
    local filenamebase=""
    local filename=""
    local allDiskName=""
    local allDiskInfo=""

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi

        #ִmml cm diskinfo
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm diskinfo show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="INFO: Failed to execute command."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Disk_ID"|sed 's/^ *//g'|sed "/^$/d"`
        filenamebase=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep '/tmp/snas_debug*' |xargs basename|sed 's/^ *//g'|sed "/^$/d"`
        filename="/tmp/$filenamebase"
        
        if [ "$javaID" == "" ];then
            if [ "$filenamebase" == "" ];then
                errResult="INFO:Can not get disk information."
                isPass=1
                
                LOG "[$FUNCNAME]:$errResult"
                cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                break 
            else
                javaID=`cat $filename|grep "Disk_ID"|sed 's/^ *//g'|sed "/^$/d"`
                LOG "[$FUNCNAME]:filename:$filename,filenamebase:$filenamebase"
            fi
        fi 
       
        if [ "$javaID" == "" ];then
            errResult="INFO:Can not get disk information." 
            isPass=1
            
            LOG "[$FUNCNAME]:$errResult"
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break 
        fi        
        
        set_ifs
        for line in $javaID; do
            if [ "$line" = "" ];then
                continue;
            fi
            #ʽDisk_ID: 743808 || parent_ID: 15496 || location: 00 || Health_Status: 2 || Running_Status: 27 || Disk_type: 1 || BandWidth: 0 || Speed: 0 || Tempreature: 0 || Model:  || Version:  || Manufacture:  || SN:  || Size: 0 || RunTime: 0
            #ʽDisk_ID: 123600 || parent_ID: 2575 || location: 00 || Health_Status: 2 || Running_Status: 27 || Disk_type: 1 || BandWidth: 0 || Speed: 0 || Tempreature: 0 || Model:  || Version:  || Manufacture:  || SN:  || Size: 0 || RunTime: 0
            #ʽDisk_ID: 123606 || parent_ID: 2575 || location: 06 || Health_Status: 1 || Running_Status: 27 || Disk_type: 2 || BandWidth: 0 || Speed: 7200 || Tempreature: 31 || Model: WDC WD1003FBYX-01Y7B0 || Version: 01.01V01 || Manufacture: Western Digital || SN: WD-WCAW30712454 || Size: 1000204886016 || RunTime: 3
            
            ID=`echo $line |awk '{print $2}'`

            parentID=`echo $line |awk '{print $5}'`
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`
            
            location=`echo $line |awk '{print $8}'`
            healthStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`
            
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`
               
            diskType=`echo $line |awk '{print $17}'`
            diskType=`MapDiskType $diskType`
            
            bandwidth=`echo $line |awk '{print $20}'`
            speed=`echo $line |awk '{print $23}'`
            Temperature=`echo $line |awk '{print $26}'`

            model=`echo $line |awk -F: '{print $11}'|sed 's/|| Version//'`

            version=`echo $line |awk -F: '{print $12}'|sed 's/|| Manufacture//'`
            manu=`echo $line |awk -F: '{print $13}'|sed 's/|| SN//'`
            SN=`echo $line |awk -F: '{print $14}'|sed 's/|| Size//'`
            size=`echo $line |awk -F: '{print $15}'|sed 's/|| RunTime//'`
            runTime=`echo $line |awk -F: '{print $16}'`

            if [ "$runningStatus" != "NOT_EXIST" ];then            
                Result="ID:$ID||parentID:$parentID||nodeIP:$parentIP||location:$location||healthStatus:$healthStatus||runningStatus:$runningStatus||diskType:$diskType||bandwidth:$bandwidth||speed:$speed||Temperature(degrees):$Temperature||model:$model||version:$version||manu:$manu||SN:$SN||size(bytes):$size||runTime(days):$runTime"
                WRITE_XML_COMMON 0 "$Result"

                if [ "$runningStatus" != "ONLINE" ] || [ "$healthStatus" != "NORMAL" ] || [ "$Temperature" -gt 55 ];then
                    LOG "[$FUNCNAME]:Error, $Result"
                    isPass=1
                fi
            fi
        done
        restore_ifs
        break
    done

    if [ "$errResult" != "" ]; then
        WRITE_XML_ERROR 0 "$errResult"
    fi

	local TASK_ID=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    G_REMOTE_TMP_FILENAME=${G_REMOTE_TMP_FILE}${FUNCNAME}_ex1
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowDiskOnposition >  $G_REMOTE_TMP_FILENAME 2>&1"
	if [ 0 -ne $? ];then
		isPass=1
	fi
    
    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get disk position information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
            Itemfile=${G_TMP_FILE}${Item}_ex1
            remote_download $Item $Itemfile $G_REMOTE_TMP_FILENAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            haserr=`cat $Itemfile| wc -l`
            allDiskName=""
            allDiskInfo=$(cat $Itemfile)
            if [ 0 -ne $haserr ]; then 
                isPass=1
                for singleDisk in ${allDiskInfo[@]}
                do
                    if [ -z "${allDiskName}" ]; then
                        allDiskName="/dev/${singleDisk}"
                    else
                        allDiskName="${allDiskName}, /dev/${singleDisk}"
                    fi 
                done
                errResult="INFO:Node($Item), ${allDiskName} does not joined the system."
                WRITE_XML_ERROR 0 "$errResult"
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
	
	#׷ӼӲλδ
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#104. Դ״̬
checkPowerStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    
    #ʽPower_ID: %s || parent_ID: %s || Health_Status: %d || Running_Status: %d || Power_type: %d || Vendor: %s || Model: %s || Version: %s || ProduceDate: %s || SN: %s
    #ʽPower_Count:2
    
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        #ִmml cm power
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm power show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info" 
            errResult="Node:-||INFO:Failed to execute cm power." 
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_ID"|sed 's/^ *//g'|sed "/^$/d"`
        
        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO:Can not get information,Please try again." 
            isPass=1
            
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi 

        set_ifs
        for line in $javaID; do
            if [ "$line" = "" ];then
                continue;
            fi
            
            ID=`echo $line |awk '{print $2}'`
            parentID=`echo $line |awk '{print $5}'`
            parentIP=`get_node_backnet_ip $parentID`
            
            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            powerType=`echo $line |awk '{print $14}'`
            powerType=`MapPowerType $powerType`

            if [ "$runningStatus" = "NOT_EXIST" ];then
                powerType="--"
            fi

            vendor=`echo $line | awk -F: '{print $7}'|sed 's/|| Model//'`
            echo "$vendor"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                vendor="--"
            fi
            model=`echo $line |awk -F: '{print $8}'|sed 's/|| Version//'`
            echo "$model"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                model="--"
            fi
            version=`echo $line |awk -F: '{print $9}'|sed 's/|| ProduceDate//'`
            echo "$version"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                version="--"
            fi
            produceDate=`echo $line |awk -F\| '{print $17}'|awk '{print $2,$3,$4,$5,$6,$7 }'`  #`echo $line |awk -F: '{print $10}'|sed 's/|| SN//'`
            echo "$produceDate"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                produceDate="--"
            fi
            SN=`echo $line |awk -F\| '{print $19}' |awk '{print $2}'`
            echo "$SN"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                SN="--"
            fi

            Result="ID:$ID||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||powerType:$powerType||vendor:$vendor||model:$model||version:$version||produceDate:$produceDate||SN:$SN"
            WRITE_XML_COMMON 0 "$Result"

            if [ "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
            fi
        done
    
        #жϱ׼нڵ붼˫Դ
        #жÿڵĵԴǷ2
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_Count"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID; do
            if [ $line = "" ];then
                continue;
            fi
            
            count=`echo $line |awk -F: '{print $2}'`
            if [ "$count" != "2" ];then
                isPass=1
            fi
        done
        
        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#105. ״̬
checkFanStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local FirstString=""
    local line=""
    local new_line=""
    
    #ʽFan_ID: 15496.1 || Fan_Name: FAN1 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5029
    #ʽFan_ID: 15496.2 || Fan_Name: FAN2 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5076
    #ʽFan_Count:2
    
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        #ִmmlcm fan
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fan show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info" 
            errResult="Node:-||INFO:Failed to execute cm fan." 
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d"`
        
        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO:Can not get information." 
            isPass=1
            
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi 
        
        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue;
            fi
            
            #жϵһַǲǡFan_IDstart/time:08:13:35.277086 | clock:58435.277136Fan_ID: 14087.1 || Fan_Name:
            FirstString=`echo $line | awk '{print $1}'`
            if [ "$FirstString" != "Fan_ID:" ]; then
               new_line=`echo $line | awk -F"Fan_ID" '{print $2}'`
               LOG "[$FUNCNAME]:old_line:($line), new_line:($new_line)"
               line=$new_line
            fi
                        
            ID=`echo $line |awk '{print $2}'`
            NAME=`echo $line |awk '{print $5}'`
            parentID=`echo $line |awk '{print $8}'`
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`
            
            healthStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`
            
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`
            
            level=`echo $line |awk '{print $17}'`
            elabel=`echo $line |awk '{print $20}'`
            speed=`echo $line |awk '{print $23}'`
                                    
            Result="ID:$ID||name:$NAME||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||level:$level||elabel:$elabel||speed(RPM):$speed"
                          
            if [ "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                errResult="Item:${parentIP}-$ID||INFO: RunningStatus(${runningStatus}) or healthStatus{$healthStatus} not NORMAL!||${errResult}"
                LOG "[$FUNCNAME] ${parentIP}-$ID runningStatus(${runningStatus}) or healthStatus{$healthStatus} not NORMAL!" 
                isPass=1
            else
                WRITE_XML_COMMON 0 "$Result" 
            fi
            
        done

        #жÿڵķǷ5
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_Count"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID; do
            if [ $line = "" ];then
                continue;
            fi
            
            count=`echo $line |awk -F: '{print $2}'`
            if [ "$count" != "5" ] && [ "$count" != "11" ]; then
                errResult="Item:--||INFO: FAN number($count) is not 5 or 11!||${errResult}"
                LOG "[$FUNCNAME] $back_ip Error: FAN number($count) is not 5 or 11!" 
                isPass=1
            fi
        done
        
        restore_ifs
        break
    done

    #жϱ׼ȫȣ511λ
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#106. ڵ״̬״̬
checkNetportStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    
    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNIC > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not NIC information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue;
            fi

            set_ifs 
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$line"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
            
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
  
#107. CPU״̬
checkCPUStatus()
{
    #ipmitool sdr|grep CPU
    #ʽCPU0_Core_temp   | -55 degrees C     | ok
    #ʽCPU1_Core_temp   | -50 degrees C     | ok
    #ʽCPU0_Status      | 0x80              | ok
    #ʽCPU1_Status      | 0x80              | ok
    #ʽVTT_CPU0         | 1.05 Volts        | ok
    #ʽVTT_CPU1         | 1.06 Volts        | ok
    #ʽVDDQ_DDR_CPU0    | 1.51 Volts        | ok
    #ʽVDDQ_DDR_CPU1    | 1.51 Volts        | ok
    #ʽVCCP_CPU0        | 0.85 Volts        | ok
    #ʽVCCP_CPU1        | 0.94 Volts        | ok
    
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 60 "$G_MML_FILE_PATH/ShowCpuState > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get ipmi cpu information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
            
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#108. ڵ״̬
checkNodeStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
    
    #ʽNode_ID: 15425 || Node_Name: node65 || Health_Status: 1 || Running_Status: 2 || Frame: a1 || Slot: 1 || SN: 210235G78PZ0C8000011 || Device_Type: 33 || Manufacture: Huawei Technologies Co., Ltd. || Firmware_Version: V100R001C00 || Bussiness_IP: ["xx.xx.xx.xx","xx.xx.xx.xx"] || Manage_IP: xx.xx.xx.xx || Function_Type: 0 || Time: 0 || Time_zone:  || DevMgrIP: xx.xx.xx.xx || Tier_ID: 1
    
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi

        #ִmmlcm node
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm node show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            errResult="Node:-||INFO:Can not get information.exec(cm node) failed!"
            LOG "[$FUNCNAME] $back_ip:Can not get information.exec(cm node) failed!Info($Info)" 

            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`
        
        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO: Can not get information!||${errResult}"
            LOG "[$FUNCNAME] $back_ip get javaID(javaID) failed!" 
            isPass=1
            
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi 

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue;
            fi
            
            ID=`echo $line |awk '{print $2}'`
            NAME=`echo $line |awk '{print $5}'`
            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`
            
            frame=`echo $line |awk '{print $14}'`
            slot=`echo $line |awk '{print $17}'`
            SN=`echo $line |awk '{print $20}'`
            typeid=`echo $line |awk '{print $23}'`
            type=`MapDeviceType $typeid`
          
            Result="ID:$ID||name:$NAME||healthStatus:$healthStatus||runningStatus:$runningStatus||Frame:$frame||Slot:$slot||SN:$SN||Type:$type"           
            LOG "[$FUNCNAME] $Result||typeid:$typeid" 
            
            WRITE_XML_COMMON 0 "$Result"               
            if [ "$runningStatus" != "ONLINE" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
                errResult="Item:$ID||INFO:HealthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE.||${errResult}"
                LOG "[$FUNCNAME] $ID healthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE."
            fi
        done
        
        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}
  
#109.Verify
checkDiskVerify()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
	local readErr=0
	local writeErr=0
	local verifyErr=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    #todo: Ĵܵ¼鲻
    remote_exec_async_batch $TASK_ID 360 "/usr/local/bin/disktool -f A |grep \"Total uncorrected errors\" > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get verify information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            set_ifs
                
            javaId=`cat $G_TMP_FILE$Item | awk '{print $5}'|sed 's/^ *//g'|sed "/^$/d"`

            #ͳ
            lineNum=`cat $G_TMP_FILE$Item|wc -l`
			tmpIndex=0;
			for line in $javaId; do
				if [ $tmpIndex -eq 0 ];then
					readErr=$line
				elif [ $tmpIndex -eq 1 ]; then
					writeErr=$line
				else 
					verifyErr=$line
				fi	
				tmpIndex=`expr $tmpIndex + 1`
            done

			if [ $readErr -gt 600 ] || [ $writeErr -gt 30 ] || [ $verifyErr -gt 600 ]; then
				isPass=1
			fi
            
			Result="IP:$Item||Errors:ReadError:$readErr, WriteErr:$writeErr, VerifyErrorNumber:$verifyErr"
            WRITE_XML_COMMON 0 "$Result"
			
			restore_ifs

        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#110. ڵ¶
checkCardTemp()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID $CMD_IPMI_TIMEOUT "ipmitool sensor > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ipmitool sensor information"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi            
  
            #豸¶
            TempEAR=`cat $G_TMP_FILE$Item |grep TEMP_EAR|awk '{print $3}'`
            TempEAR_Alarm=`cat $G_TMP_FILE$Item |grep TEMP_EAR|awk '{print $18}'`
            
            #¶
            TempIN=`cat $G_TMP_FILE$Item |grep TEMP_CARDIN|awk '{print $3}'`
            #ڸ澯ֵ
            TempIN_Alarm=`cat $G_TMP_FILE$Item |grep TEMP_CARDIN|awk '{print $18}'`
            #¶
            TempOUT=`cat $G_TMP_FILE$Item |grep TEMP_CARDOUT|awk '{print $3}'`
            #ڸ澯ֵ
            TempOUT_Alarm=`cat $G_TMP_FILE$Item |grep TEMP_CARDOUT|awk '{print $18}'`
            
            if [ `echo "$TempEAR > $TempEAR_Alarm" | bc` -eq 1 ] || [ `echo "$TempIN > $TempIN_Alarm" | bc` -eq 1 ] || [ `echo "$TempOUT > $TempOUT_Alarm" | bc` -eq 1 ];then 
                errResult="Node: $Item||Error:The Temperature exceeds the threshold!||$errResult"
                LOG "[$FUNCNAME] The Temperature exceeds the threshold!"
                isPass=1
            fi
            
            Result="Node:$Item||TempEAR(degrees):$TempEAR||TempEAR_Alarm(degrees):$TempEAR_Alarm||TempIN(degrees):$TempIN||TempIN_Alarm(degrees):$TempIN_Alarm||TempOUT(degrees):$TempOUT||TempOUT_Alarm(degrees):$TempOUT_Alarm"
           
            LOG "[$FUNCNAME]:$Result"
        
            WRITE_XML_COMMON 0 "$Result"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    if [ "${isPass}" == "0" ];then    
        WRITE_XML_JUDGE 0
    else 
        WRITE_XML_ERROR 0 "$errResult"
        WRITE_XML_JUDGE 1
    fi
    
    WRITE_XML_SUBCMD_TAIL    
}

#111. Э̵˫Ѳ,GEȫ˫1000M10GEںIBֻҪLinkUp
#todo: 10GEΪʲô
checkNetNegotiate()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNicState > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get NIC information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="Node: $Item||INFO:Can not get information of NIC.errno($iRet)!||${errResult}"
                LOG "[$FUNCNAME] $Item exec(ShowNIC) failed.iRet($iRet),errno($errno),process(&process)"
                isPass=1
                continue;
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$line"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
   
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#112. ģ״̬⹦쳣㲻ͨʵֲμ澯
checkFiber_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local errResult=""
    local isPass=0
    local javaID=""

    #ʽFiber_ID: %s || parent_ID: %s || location: %s || Health_Status: %d || Running_Status: %d || ModeType: %d || WaveLen: %d || RX_Power: %d || TX_Power: %d || Speed: %d || Temperature: %d || Voltage: %d || Vendor: %s || Model: %s || SN: %s
    #ʽFiber_Count:2
    
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi
        
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fiberinfo show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            errResult="Node:-||INFO: Can't get information,exec(cm fiberinfo show) failed!||${errResult}"
            LOG "[$FUNCNAME]$back_ip:can't get information,exec(cm fiberinfo show) failed!Info($Info)." 
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #Fiber_Count:0
        javaID=`grep "Fiber_Count" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`
        
        if [ "$javaID" = "" ];then
            errResult="Node:-||INFO: Get Fiber_Count failed!|${errResult}"
            LOG "[$FUNCNAME]$back_ip:get Fiber_Count failed!" 
            isPass=1
            
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            
            break
        fi 
        
        set_ifs
        for line in $javaID; do
            if [ "$line" = "" ];then
                continue;
            fi
            count=`echo $line |awk -F: '{print $2}'`
            if [ "$count" = "0" ];then
                errResult="Node:-||INFO: No Fiber exists!count($count).||${errResult}"
                LOG "[$FUNCNAME]-:no Fiber exists!count($count)."        
            fi
        done

        javaID=`grep "Fiber_ID" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        for line in $javaID; do
            if [ "$line" = "" ];then
                continue;
            fi
            
            ID=`echo $line |awk '{print $2}'`
            parentID=`echo $line |awk '{print $5}'`
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`
            
            location=`echo $line |awk '{print $8}'`
            healthStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`
            
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`
            
            modeType=`echo $line |awk '{print $17}'`
            waveLen=`echo $line |awk '{print $20}'`
            RX_Power=`echo $line |awk '{print $23}'`
            TX_Power=`echo $line |awk '{print $26}'`
            Speed=`echo $line |awk '{print $29}'`
            Temperature=`echo $line |awk '{print $32}'`
            Voltage=`echo $line |awk '{print $35}'`
            Vendor=`echo $line |awk '{print $38}'`
            Model=`echo $line | awk -F'Model' '{print $2}'|awk '{print $2}'`
            SN=`echo $line | awk -F'SN' '{print $2}'|awk '{print $2}'`
            
            Result="ID:$ID||parentID:$parentID||nodeIP:$parentIP||location:$location||healthStatus:$healthStatus||runningStatus:$runningStatus||modeType:$modeType||waveLen:$waveLen||RX_Power:$RX_Power||TX_Power:$TX_Power||Speed:$Speed||Temperature:$Temperature||Voltage:$Voltage||Vendor:$Vendor||Model:$Model||SN:$SN"
            
            WRITE_XML_COMMON 0 "$Result"               
            if [ "$runningStatus" != "NORMAL" ] ||[ "$healthStatus" != "NORMAL" ];then
                isPass=1
            fi
        done
        
        restore_ifs
        break
    done
    
    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#113. SSDһλSSD,ΪNOFS
checkSSD()
{
    WRITE_XML_SUBCMD_HEADER $1
    local errResult=""
    local isPass=0
    local isSlotOk=1

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
  
    for Item in $REMOTE_IP_S; do
        Info=""
        Info=`remote_exec $Item 30 "grep -w SSD /proc/mpt2sas/mpt2sas0-drives 2>&1"`
        if [ "$Info" == "" ]; then
            LOG "Node: $Item||Failed to get sdd info, $Info"
            errResult="Node: $Item||INFO: No SSD information||$errResult"
        else
            isSlotOk=1
           
            javaId=`echo "$Info" |sed 's/^ *//g'|sed "/^$/d"`
            set_ifs
            for line in $javaId; do
                slot=`echo $line|awk '{print $1}'`
                INOUT=`echo $line|awk '{print $2}'`
                PHY=`echo $line|awk '{print $3}'`
                POWER=`echo $line|awk '{print $4}'`
                LED=`echo $line|awk '{print $5}'`
                OS_IN=`echo $line|awk '{print $6}'`
                OS_STAT=`echo $line|awk '{print $7}'`
                SN=`echo $line|awk '{print $8}'`
                VENDOR=`echo $line|awk '{print $9}'`
                FW_VER=`echo $line|awk '{print $10}'`
                MODEL=`echo $line|awk '{print $11}'`
                LINK=`echo $line|awk '{print $12}'`
                DISK_SIZE=`echo $line|awk '{print $13}'`

                TEMP=`echo $line|awk '{print $15}'`
                TYPE=`echo $line|awk '{print $16}'`

                #SSD LED    OS_IN    OS_STAT ֶ
                if [ "$LED" != "0" ] || [ "$OS_IN" != "1" ] || [ "$OS_STAT" != "running" ];then
                    isPass=1
                fi

                #0λǷSSD
                if [ "$slot" == "0" ]; then
                    isSlotOk=0
                fi
                
                #״̬Сдתɴд
                OS_STAT=`echo $OS_STAT|tr "[:lower:]" "[:upper:]"`

                Result="Node:$Item||SLOT:$slot||INOUT:$INOUT||PHY:$PHY||POWER:$POWER||LED:$LED||OS_IN:$OS_IN||OS_STAT:$OS_STAT||SN:$SN||VENDOR:$VENDOR||FW_VER:$FW_VER||MODEL:$MODEL||LINK:$LINK||DISK_SIZE:$DISK_SIZE||TEMP(degrees):$TEMP||TYPE:$TYPE"
                WRITE_XML_COMMON 0 "$Result"
            done
            
            if [ "$isSlotOk" -ne 0 ];then
                isPass=1
            fi
            
            restore_ifs
        fi

    done

    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 "${errResult}"
    fi 

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#114. ϵͳRAID״̬˫ϵͳ̣ϵͳжͨ
checkSysRAID()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    for Item in $REMOTE_IP_S; do
        info=`remote_exec $Item 30 "grep SYSTEMDISK /proc/mpt2sas/mpt2sas0-drives 2>&1"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node: $Item||INFO: ${Info}||$errResult"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get sysdisk info from /proc/mpt2sas/mpt2sas0-drives." 
            isPass=1
            continue
        fi

        javaId=`echo "$info"|sed 's/^ *//g'|sed "/^$/d"`
        count=`echo "$info"|wc -l`

        if [ "$count" != "2" ];then
            isPass=1
        fi

        set_ifs
        for line in $javaId; do
            slot=`echo $line|awk '{print $1}'`
            INOUT=`echo $line|awk '{print $2}'`
            PHY=`echo $line|awk '{print $3}'`
            POWER=`echo $line|awk '{print $4}'`
            LED=`echo $line|awk '{print $5}'`
            OS_IN=`echo $line|awk '{print $6}'`
            OS_STAT=`echo $line|awk '{print $7}'`
            SN=`echo $line|awk '{print $8}'`
            VENDOR=`echo $line|awk '{print $9}'`
            FW_VER=`echo $line|awk '{print $10}'`
            MODEL=`echo $line|awk '{print $11}'`
            LINK=`echo $line|awk '{print $12}'`
            DISK_SIZE=`echo $line|awk '{print $13}'`
            SPEED=`echo $line|awk '{print $14}'`
            TEMP=`echo $line|awk '{print $15}'`
            TYPE=`echo $line|awk '{print $16}'`

            #ж״̬ LED    OS_IN    OS_STAT 
            if  [ "$LED" != "0" ] || [ "$OS_IN" != "1" ] || [ "$OS_STAT" != "running" ];then
                isPass=1
            fi
            
            #״̬Сдתɴд
            OS_STAT=`echo $OS_STAT|tr "[:lower:]" "[:upper:]"`
            Result="Node:$Item||SLOT:$slot||INOUT:$INOUT||PHY:$PHY||POWER:$POWER||LED:$LED||OS_IN:$OS_IN||OS_STAT:$OS_STAT||SN:$SN||VENDOR:$VENDOR||FW_VER:$FW_VER||MODEL:$MODEL||LINK:$LINK||DISK_SIZE:$DISK_SIZE||SPEED:$SPEED||TEMP(degrees):$TEMP||TYPE:$TYPE"
            WRITE_XML_COMMON 0 "$Result"
        done
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL        
}

#115nvdimm״̬
checkNvdimmStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/nvdimm_status_record > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get nvdimm information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            NoNvdimmInfo=`cat $G_TMP_FILE$Item | grep "NO NVDIMM FOUND"`    
            if [ "$NoNvdimmInfo" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:There is no Nvdimm."   
                continue
            fi            
            
            ErrInfo=`cat $G_TMP_FILE$Item | grep "some wrong during Recording NVDIMM Status"`
            if [ "$ErrInfo" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get Nvdimm Info Fail"   
                
                #
                cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                
                continue
            fi

            #ȡnvdimmĸ
            set_ifs
            Nvdimm_NUM=`cat $G_TMP_FILE$Item | grep "There are" | grep "found under system" |  awk '{print $3}'`
            if [ "$Nvdimm_NUM" -le 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:the NUM of Nvdimm is $Nvdimm_NUM"   
                
                restore_ifs
                
                #
                cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                
                continue
            fi
            
            #ѭʾnvdimmϢ
            index=1
            while [[ "$index" -le "$Nvdimm_NUM" ]]
            do
                echo "$index"
                
                #ȡNAME
                NVDIMM_NAME=`cat $G_TMP_FILE$Item | grep "NVDIMM NAME" | awk NR==$index | awk '{print $3}'`

                #ȡģʽ
                SAVE_MODE=`cat $G_TMP_FILE$Item | grep "SAVE MODE" | awk NR==$index | awk '{print $3}'`

                #ȡ¶
                TEMPERATUER=`cat $G_TMP_FILE$Item | grep "CAP TEMPERATUER" | awk NR==$index | awk '{print $3}'`

                #ȡǷλ
                PRESENCE=`cat $G_TMP_FILE$Item | grep "CAP PRESENCE" | awk NR==$index | awk '{print $3}'`

                #FLASH״̬
                FLASH_STATUS=`cat $G_TMP_FILE$Item | grep "FLASH STATUS OK" | awk NR==$index | awk '{print $3}'| awk -F: '{print $2}'`            

                #Ƿ
                FULL_CHARGE=`cat $G_TMP_FILE$Item | grep "CAP FULL CHARGE" | awk NR==$index | awk '{print $4}'`

                #Ƿﵽʹ
                LIFE_END=`cat $G_TMP_FILE$Item | grep "CAP LIFE END" | awk NR==$index | awk '{print $3}' | awk -F: '{print $2}'`

                if [ "$SAVE_MODE" != "CKE_MODE" ] || [ "$TEMPERATUER" -gt "60" ] || [ "$PRESENCE" != "TRUE" ] || [ "$FLASH_STATUS" != "TRUE" ] || [ "$FULL_CHARGE" != "TRUE" ] || [ "$LIFE_END" != "FALSE" ]; then 
                    NVDIMM_STAT="FAULT"
                    isPass=1            
                else
                    NVDIMM_STAT="NORMAL"            
                fi 

                Result="Node:$Item||NVDIMM NAME:$NVDIMM_NAME||NVDIMM_STATUS:$NVDIMM_STAT||SAVE MODE:$SAVE_MODE||CAP TEMPERATUER(centigrade):$TEMPERATUER||CAP PRESENCE:$PRESENCE||FLASH_STATUS:$FLASH_STATUS||CAP FULL CHARGE:$FULL_CHARGE||CAP LIFE END:$LIFE_END"

                LOG "[$FUNCNAME]:Result:$Result" 

                WRITE_XML_COMMON 0 "$Result"                      
                 
                #һѭ
                index=$((index + 1 ))
            done
                
            restore_ifs
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL   
}

#ÿڵECCϢ
function checkEcc_result()
{
    local isOK=0
    local ip=$1
    local info=$2

    LOG "ecc IP:$ip||$info"

    if [ "$info" = "" ];then
        #ʾ
        Result="Info:No Ecc errors"
        #Itemֱⲿֵ
        WRITE_XML_COMMON 0 "Node:$ip||${Result}"
        return 0
    fi

    # get DIMM countȡDIMMĸ
    uiDiMMCnt=`echo "$info" | grep "DIMM" | wc -l`
    LOG "bit ecc Dimm num:$uiDiMMCnt" 
    
    #parse 
    uiLine=0
    uiErrCount=0
    uiLoop=0
    Result="Info:bit ecc ok"
    while [ $uiLoop -lt $uiDiMMCnt ]; do 
        uiLine=`echo "5+$uiLoop*8"|bc`
        LOG "bit ecc: $uiLoop,line: $uiLine"

        uiErrCount=`echo "$info" | awk NR==$uiLine| awk '{print $1}'`
        LOG "bit ecc:out $uiErrCount"

        #threshold ֵΪ 25K
        if [ $uiErrCount -gt 25000 ];then
            isOK=1
            Result="Info:bit ecc too much"                     
        fi

        #uiLoop++ ȡһ
        uiLoop=$((uiLoop+1))
    done    
    WRITE_XML_COMMON 0 "Node:$ip||${Result}"
     
    #ݽϸϢӡ 
    Result=""
    set_ifs
    WRITE_XML_COMMON 0 "Node: ||Info:--------------detail-------------- "
    for line in $info; do
        Result="Info:${line}"        
        WRITE_XML_COMMON 0 "Node: ||${Result}"
    done
    restore_ifs
    
    return $isOK
}

#116 Bit ECCĴ mcelog --client 
function checkBitEcc()
{
    WRITE_XML_SUBCMD_HEADER $1 
    local isPass=0
    local errResult=""
    ALLIp=`cat $IP_ROLE_FILE`

    for Item in $ALLIp; do
        info=`remote_exec $Item 30 "mcelog --client"`

        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node: $Item||INFO: Failed to execute mcelog||$errResult"
            isPass=1
            continue
        fi
        
        checkEcc_result $Item "$info"
        if [ $? -ne 0 ]; then
            isPass=1
        fi
    done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#117. ARP
checkArpErr_MML()
{
   WRITE_XML_SUBCMD_HEADER $1
    local arpinfo=""
    local Result=""
    
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    LOG "[checkArpErr_MML] start"
    remote_exec_async_batch_mml $TASK_ID 30 ShowArpErr $FUNCNAME
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    
    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ShowArpErr information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi
             
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            set_ifs
            dos2unix $G_TMP_FILE$Item
            
            #      
            arpinfo=""            
            arpinfo=`cat $G_TMP_FILE$Item|grep 'ArpErrPort'|sed 's/^ *//g'|sed "/^$/d"`
            LOG "[$FUNCNAME]Node:$Item||$arpinfo"
            
            arperrport=""
            arperrname=""
            
            #ûݴ
            if [ "$arpinfo" == "" ];then
            
                #ʾ
                Result="Node:$Item||arp err port:no data"
                LOG "[$FUNCNAME]:$Result"
                WRITE_XML_COMMON 0 "$Result"          
                
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                
                isPass=1          
            else
               #ûڽ    
               arperrport=`echo $arpinfo | grep no`
               if [ "$arperrport" != "" ];then
            
                    #ʾ
                    Result="Node:$Item||arp err port:no port error"
                    LOG "[$FUNCNAME]no port err:$Result"
                    WRITE_XML_COMMON 0 "$Result"
               else
               #дĶ˿ڽ˿ʾ
                    arperrname=`echo $arpinfo | awk '{print $2}'`
                    
                    #ʾ
                    Result="Node:$Item||arp err port:$arperrname"
                    LOG "[$FUNCNAME] have err port:$Result"
                    WRITE_XML_COMMON 0 "$Result"
                    isPass=1
                    
                    #
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
               fi             
            fi
            
            restore_ifs
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    LOG "[$FUNCNAME] over"
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL    
}

#118. BMC״̬
checkBMCstatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    
    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID $CMD_IPMI_TIMEOUT "$G_MML_FILE_PATH/ShowBMCstatus > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not BMC information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue;
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                fi
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"
                
            done < $G_TMP_FILE$Item
            restore_ifs
            
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
 
function check_key()
{
    file_checked=$1
    input_key=$2
    input_value=$3

    while read line
    do
        key=$(echo $line | awk -F':' '{print $1}')
        value=$(echo $line | awk -F':' '{print $2}')
        [ "X${key}X" == "X${input_key}X" ] && [ "X${value}X" == "X${input_value}X" ] && return 0
        [ "X${key}X" == "X${input_key}X" ] && [ "X${value}X" != "X${input_value}X" ] && LOG "KEY:${key} not the same, remote:${input_value}, base:${value}"&& return 1
    done < ${file_checked}

    echo "${input_key}:${input_value}" >> "${file_checked}"
    return 0
}

#һ
function file_diff()
{
	file_compare=$1
	file_base=$2

	while read line
	do
			key=$(echo $line | awk -F':' '{print $1}')
			value=$(echo $line | awk -F':' '{print $2}')
			if [ "XX" != "X${key}X" ]; then
					check_key "${file_base}" "${key}" "${value}"
					if [ $? != 0 ]; then
						return 1
					fi
			fi
	done < ${file_compare}
	return 0
}

 #119 汾һ
 checkNodeVersion()
 {
    WRITE_XML_SUBCMD_HEADER $1 
    local isPass=0
    local errResult=""
    local Result=""
	local TASK_ID=0
    ALLIp=`cat $IP_ROLE_FILE`

    #ȡڵİ汾
   	master_version_file=/tmp/tmpcmmaster_version
	$G_MML_FILE_PATH/GetNodeVersion > $master_version_file
	filecontent="`cat $master_version_file | sed 's/&/&amp;/'`"
	#LOG "$filecontent"
	Result="NodeID:master|| Version:$filecontent"
	#`cat $master_version_file` 
	WRITE_XML_COMMON 0 "$Result"
	LOG "$Result"
	
	REMOTE_IP_S=`cat $IP_ROLE_FILE`
	remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetNodeVersion > $G_REMOTE_TMP_FILE$FUNCNAME"
	if [ 0 -ne $? ];then 
		isPass=1
	fi
	ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get node version"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue;
            fi

            #diff $master_version_file $G_TMP_FILE$Item > /dev/null
			file_diff $G_TMP_FILE$Item $master_version_file > /dev/null
			if [ 0 -ne $? ];then 
				isPass=1
				filecontent="`cat $G_TMP_FILE$Item | sed 's/&/&amp;/'`"
				Result="NodeID:$Item || Version:$filecontent"
				##`cat $G_TMP_FILE$Item`
				WRITE_XML_COMMON 0 "$Result"
				LOG "$Result"
			fi
            
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL 
 }
 
#120. Modmem״̬
checkModmemtatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:-||INFO: can't get local ip"
            isPass=1
            break
        fi
        
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm modemstat show" |sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then                                  
            errResult="Node:-||INFO:Failed to execute 'cm modemstat'." 
            isPass=1                             
            break                                
        fi                                       
                                                 
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME                     
                                                 
        NodeIDs=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep NodeID |awk '{print $1}'|sed 's/NodeID://g'|tr -d " "`
        for nodeid in $NodeIDs                   
        do                                       
            errResult=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep -w $nodeid|grep Abnormal`
            if [ $? -eq 0 ];then                 
               isPass=1                          
               Status="Abnormal"                 
            else                                 
               Status="Normal or not exist"      
            fi                                   
            Result="NodeID:$nodeid||Status:$Status"
            WRITE_XML_COMMON 0 "$Result"         
        done                                     
        break                                    
                                                 
    done        

    if [ "$isPass" != "0" ];then
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
    fi    
                                                 
    WRITE_XML_JUDGE $isPass                      
    WRITE_XML_SUBCMD_TAIL                        
}                                                
                                                 
#121. ڵʱͬ                          
checkNodeTime()                                  
{                                                
     WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    local tmpMax=0
    local tmpMin=0
    local tmpdiff=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    index=0;

    for Item in $REMOTE_IP_S; do

        localTime=`date +%s`
        set_ifs
        remoteResult=`remote_exec $Item 30 "date +%s"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] $Item Failed to execute(checkNodeTime) command.iRet($iRet)"
            isPass=1
            Result="Node:$Item||INFO:Failed to execute to check node time command"
        else

            timeDelta=`expr $remoteResult - $localTime`
            if [ ${timeDelta} -gt 10 ];then
				isPass=1
            fi
            if [ ${timeDelta} -lt -10 ];then
				isPass=1
            fi				
            #get the biggest $diff
            if [ ${timeDelta} -gt ${tmpMax} ];then
                tmpMax=${timeDelta}
            fi
            #get the smallest $diff
            if [ ${timeDelta} -lt ${tmpMin} ];then
                tmpMin=${timeDelta}
            fi

            timeResult=`date -d "$timeDelta sec" "+%Y-%-m-%-d %H:%M:%S"`
            Result="NodeIp:$Item||Currenttime:$timeResult||DiffTime(Abs(S)):$timeDelta"
        fi

        restore_ifs
        WRITE_XML_COMMON 0 "$Result"
    done
	
    tmpdiff=`expr ${tmpMax} - ${tmpMin}`
    if [ ${tmpdiff} -gt 10 ];then
            isPass=1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL                        
}                                                
#122 syslog״̬                            
checkSysLog()                                    
{                                                
    WRITE_XML_SUBCMD_HEADER $1                 
    local isPass=0
    local errResult=""
    
    ALLIp=`cat $IP_ROLE_FILE`                    
                                                 
    for Item in $ALLIp; do                       
        info=`remote_exec $Item 30 "service syslog status | grep running | wc -l"`
                                                 
        iRet=$?                                  
        if [ $iRet -ne 0 ]; then                 
            errResult="Node: $Item||INFO: Failed to execute syslog"
            WRITE_XML_ERROR 0 "$errResult"       
            isPass=1
            continue
        fi
        
        if [ $info -ne 1 ]; then
            errResult="Node: $Item||INFO: service syslog is not running"
            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
        else
            errResult="Node: $Item||INFO: service syslog is running"
            WRITE_XML_COMMON 0 "$errResult"
        fi
        
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#123 diskpoolʹǷ
checkDiskPoolUsage()
{  
    local totalCap=0
    local freeCap=0
    local Result=""
    local MaxOnePercentage=0
    local MinOnePercentage=0
    local diskPoolAll=""
    local iRet=0
 
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local diskpool_rc=""

    #ȡеdiskPoolId
    diskPoolAll=`cat /proc/monc_dsmap|grep DiskPool|awk '{print $6}'|sort|uniq`
    iRet=$?
    if [ "$iRet" -ne 0 ] || [ "$diskPoolAll" == "" ];then
        
        WRITE_XML_COMMON 0 "monc_dsmap is null"
        
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        
        LOG "[$FUNCNAME]:err out,iRet($iRet),diskPoolAll($diskPoolAll)."
        return 0
    fi
    
    set_ifs
    for poolId in $diskPoolAll
    do
        diskSize=`cat /proc/monc_dsmap | grep "DiskPool $poolId"`
        allDiskSize=0
        allFreeSize=0
        AllDiskUsed=0
        AvePercentage=0
                
        #ƽʹ
        for line in $diskSize
        do
            totalCap=`echo $line|awk '{print $10}'`
            freeCap=`echo $line|awk '{print $12}'`
            
            #λֽתGB expr $totalCap / 1073741824   
            allDiskSize=`expr $allDiskSize \+ $totalCap`
            allFreeSize=`expr $allFreeSize \+ $freeCap`

            LOG "[$FUNCNAME]:allDiskSize:$allDiskSize,allFreeSize:$allFreeSize,totalCap:$totalCap,freeCap:$freeCap"
            
        done
        
        #ȡʹʵİٷֱ AvePercentage         
        AllDiskUsed=`expr $allDiskSize \- $allFreeSize`
        
        if [ $allDiskSize -eq 0 ];then
            AvePercentage=0
            continue
        else
            AvePercentage=`echo "scale=2;$AllDiskUsed*100/$allDiskSize"|bc -l`
        fi
        
        LOG "$FUNCNAME]allDiskSize(BYTE):$allDiskSize,allFreeSize(BYTE):$allFreeSize,AllDiskUsed(BYTE):$AllDiskUsed,AvePercentage:$AvePercentage"
        Result=
                
        #Ƚÿһİٷֱ,ȡСʹ
        MaxOnePercentage=0
        MinOnePercentage=100
        ratio=0
        ratio_min=100
        ratio_max=0
        ratio_diff=0
        
        for line in $diskSize
        do
            OneTotalCap=`echo $line|awk '{print $10}'`
            OneFreeCap=`echo $line|awk '{print $12}'`
            OneUserCap=`expr $OneTotalCap \- $OneFreeCap`
            
            if [ $OneTotalCap -eq 0 ];then
                OnePercentage=0
                continue
            else
                OnePercentage=`echo "scale=2;$OneUserCap*100/$OneTotalCap"|bc -l`
                ratio=$(($OneUserCap*100/$OneTotalCap))
            fi
            
            if [ $(echo "$OnePercentage > $MaxOnePercentage"|bc) -eq 1 ];then
                MaxOnePercentage=$OnePercentage;             
            fi
            
            if [ $(echo "$MinOnePercentage > $OnePercentage"|bc) -eq 1 ];then
                MinOnePercentage=$OnePercentage;             
            fi
            
            if [ $ratio -gt $ratio_max ]; then
                ratio_max=$ratio
            fi
            
            if [ $ratio -lt $ratio_min ]; then
                ratio_min=$ratio
            fi

            LOG "[$FUNCNAME]:OneTotalCap:$OneTotalCap,OneFreeCap:$OneFreeCap,OneUserCap:$OneUserCap,OnePercentage:$OnePercentage,MaxOnePercentage:$MaxOnePercentage,MinOnePercentage:$MinOnePercentage."            
            LOG "[$FUNCNAME]:ratio($ratio), ratio_min($ratio_min), ratio_max($ratio_max)"              
        done
        
        ratio_diff=$(($ratio_max-$ratio_min))
        if [ $ratio_diff -gt 10 ]; then
            LOG "DiskPool(ID):$poolId || diskpool($poolId) max ratio is larger than min ratio 10%"
            diskpool_rc="fail"
            isPass=1
        else
            diskpool_rc="pass"
        fi
        
        errResult="DiskPool(ID):$poolId || AvePercentage:$AvePercentage || MaxPercentage:$MaxOnePercentage || MinPercentage:$MinOnePercentage || Result:$diskpool_rc" 
        WRITE_XML_COMMON 0 "${errResult}"
    done
    
    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#124. ӲǷй
checkDiskFailed()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowDiskFailed > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get remote disk info."
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi
            
            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                fi
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"
                
            done < $G_TMP_FILE$Item
            restore_ifs
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#нڵĺIP
function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    
    > $IP_ROLE_FILE
    #ݿȡнڵĺIP
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do 

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`
         
        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`
        
        if [ "$localNID" == "$lastNID" ];then
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))
            
            continue
        fi
        
        #pingһ¼Ƿͨ
        tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
        
        #
        numCnt=$((numCnt+1))
        lastNID=$localNID
        
        if [ "$tempStr_ping" -le 0 ];then
 
            LOG "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"
            
            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`    
            
            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                LOG "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"
                
                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    LOG "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi
    
        #жϽڵǷúͶ        
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then 
            Status_value=`echo $Status_info | awk -F= '{print $2}'`
            if [ "$Status_value" == "0" ];then  
                echo -n "$ItemIp " >> $IP_ROLE_FILE
                LOG "[$FUNCNAME]add $ItemIp"
            fi                     
        fi
        
    done    

}

checkNodePhysicalMemIn()
{
    local l_in=`echo -e "$*" | sort | uniq`
    local l_pool=''
    local l_mem=''
    local l_pool_last=''
    local l_a=( )

    set_ifs
    for line in $l_in; do
        l_pool=`echo $line |cut -d' ' -f1`
        l_mem=`echo $line |cut -d' ' -f2`
        if [ "$l_pool_last" != "$l_pool" ];then
            l_pool_last=$l_pool
            unset l_a
            l_a=($l_mem)
            continue
        fi
        
        for ((j=0; j<${#l_a[@]}; j++ )); do
            if [ $[ $l_mem - ${l_a[$j]} ] -gt 20480 ] || [ $[ ${l_a[$j]} - $l_mem ] -gt 20480 ]; then
                echo $l_pool
                break
            fi
        done
        
        l_a[${#l_a[@]}]=$l_mem
    done

    restore_ifs
}

#125 check node memory equally
#ڵнڵڴǷһ
checkNodePhysicalMemEqually()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
	declare -a arPhyMem
	index=0

	
    remote_exec_async_batch $TASK_ID 60 "$G_MML_FILE_PATH/GetPoolNameAndPhysicalMem > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get information about pool name and physical memory"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                errResult="Node: $Item||INFO: excute check cmd failed.||$errResult"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed.||$errResult"
				isPass=1
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
				    PoolName=`echo $info | awk '{printf $1}'`
                    PhyMem=`echo $info | awk '{printf $2}'`
					if [ -z "$tempResult" ]; then
						tempResult="$info"
					else
						tempResult="$tempResult\n$info"
					fi
					arInfo[${#arInfo[@]}]="$Item $info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
            
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

	#Get pool name which phyiscal memory of nodes are not the same
	arDiffPool=(`checkNodePhysicalMemIn "$tempResult" | sort | uniq`)
	#arDiffPool=($(echo -e $tempResult | sort | uniq |  cut -d' ' -f1 |
	#awk '{count[$0]++;}
	#END \
	#{
	#    for(i in count)
	#    { 
	#		if (count[i] > 1){ print i; }
	#    }
	#}'))

	if [ ${#arDiffPool[*]} -lt 1 ] && [ $isPass -eq 0 ]; then
		WRITE_XML_COMMON 0 "Physical memory of all nodes are the same"
	else
		isPass=1
	fi

	#Get different node infomation by "different pool name"
	for i in ${arDiffPool[*]}
	do
		for ((j=0; j<${#arInfo[@]}; j++ ))
		do
			tPool=`echo ${arInfo[$j]} | awk '{print $2}'`
			if [ "$i" == "$tPool" ];then
        		WRITE_XML_COMMON 0 "info: ${arInfo[$j]}"
			fi
		done
	done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#126. 鵱ǰʱԴǷȷ
checkCurrentClockSource()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 30 "cat /sys/devices/system/clocksource/clocksource0/current_clocksource > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get current clock source"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

			TempCurClkSrc=`cat $G_TMP_FILE$Item`
            TempCurIsTsc=`grep tsc $G_TMP_FILE$Item`
			if [ -z $TempCurIsTsc ] ; then
				isPass=1
			fi

			WRITE_XML_COMMON 0 "Node:$Item||CurrentClockSource:$TempCurClkSrc"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#127. 豸ڵǷʱԴ쳣
checkClockSourceRisk()
{
	#201308֮ǰ豸tscʱԴ쳣
	#ipmitool fruѯBoard Serial910λֱΪꡢ
    
	WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    
    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID $CMD_IPMI_TIMEOUT "ipmitool fru > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?
    
    ValidIP=`cat ${VALID_IP_FILE}`

    while [[ ${ValidIP} != "" ]]
    do     
        >${VALID_IP_FILE}
        
        for Item in $ValidIP 
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ipmitool fru information"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi            
  
            #豸
            TempBoardSerial=`cat $G_TMP_FILE$Item |grep "Board Serial" |awk '{print $4}'`
			
			#豸н
			TempProductYear=`echo ${TempBoardSerial:8:1}`
			TempProductMonth=`echo ${TempBoardSerial:9:1}`
			
			#WRITE_XML_COMMON 0 "Node:$Item||BoardSerail:$TempBoardSerial"
			
			if [ -z "$TempProductYear" ] || [ -z "$TempProductMonth" ] ; then
				continue
			fi
			
            #ֻ201308֮ǰ豸ʾѲ챨
			if [ "$TempProductYear" \< "D" ] ; then
				#echo "year less than 2013"
				WRITE_XML_COMMON 0 "Node:$Item||BoardSerail:$TempBoardSerial"
				continue
			fi
			
			if [ "$TempProductYear" = "D" ] && [ "$TempProductMonth" \< "8" ] ; then
				#echo "date less than 201308"
				WRITE_XML_COMMON 0 "Node:$Item||BoardSerail:$TempBoardSerial"
			fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL    
}

#PHY
checkPhyStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/phy_status_record > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=`cat ${VALID_IP_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        
        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get phy information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            
            ErrInfo=`cat $G_TMP_FILE$Item | grep "The return value of PHY is unauthentic"`    
            if [ "$ErrInfo" != "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:PHY info unauthentic."   
                cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
				continue
            fi            

            #ȡЧĸ
            set_ifs
            PhyNum=`cat $G_TMP_FILE$Item | grep "VALID COUNT" | awk '{print $3}'`
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Valid Phy Count is $PhyNum"               
            if [ "$PhyNum" -ne 5 ];then
                isPass=1
                restore_ifs       
                #
                cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1          
            fi
            
            #ѭʾphyϢ
            index=1
			TotalNum=5
            while [[ "$index" -le "$TotalNum" ]]
            do
                echo "$index"
                
                #ȡNAME
				PHY_NUM=`cat $G_TMP_FILE$Item | grep "PHY NUM" | awk NR==$index | awk '{print $3}'`
                PHY_RESULT=`cat $G_TMP_FILE$Item | grep "PHY RESULT" | awk NR==$index | awk '{print $3}'`

                Result="Node:$Item||PHY:$PHY_NUM||RESULT:$PHY_RESULT"

                LOG "[$FUNCNAME]:Result:$Result" 

                WRITE_XML_COMMON 0 "$Result"                      
                 
                #һѭ
                index=$((index + 1 ))
            done
                
            restore_ifs
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    WRITE_XML_JUDGE $isPass    
    WRITE_XML_SUBCMD_TAIL   
}
# **************************************************************************** #
# Function Name: checkHardwareStatus
# Description: Ӳ״̬ м.
# Parameter: $1 cmditemID
# Return: 
# **************************************************************************** #
checkHardwareStatus()
{
    LOG_Check

    WRITE_XML_CMD_HEADER $1
    GetIPAndRoleFromDB
    
    LOG "[$FUNCNAME] param = ($1)"
    
    case $1 in
        100)
        #1.Check Disk Usage
        checkDiskUsage "0"
        ;;
        101)
        #2.Check CPU Usage
        checkCPUUsage "0"
        ;;
        102)
        #3.Check Memory Usage
        checkMemUsage "0"
        ;;
        103)
        #4.Check Disk Status
        checkDiskStatus_MML "0"  
        ;;
        104)
        #5.Check Power Status
        checkPowerStatus_MML "0"
        ;;
        105)
        #6.Check Fan Status
        checkFanStatus_MML "0"
        ;;
        106)
        #7.Check Netport Status
        checkNetportStatus "0"
        ;;
        107)
        #8.Check CPU Status
        checkCPUStatus "0"
        ;;
        108)
        #9.Check Node Status
        checkNodeStatus_MML "0"
        ;;
        109)
        #10.Check disk verify error
        checkDiskVerify "0"
        ;;
        110)
        #ڵ()¶
        checkCardTemp "0"
        ;; 
        111)
        #ڵ˫Ѳ
        checkNetNegotiate "0"
        ;;
        112)
        #ģ
        checkFiber_MML "0"
        ;;
        113)
        #check SSD
        checkSSD "0"
        ;;
        114)
        #check RAID
        checkSysRAID "0"
        ;;
        115)
        #check nvdimm
        checkNvdimmStatus "0"
        ;;
        116)
        #bit ECC
        checkBitEcc "0"
        ;;
        117)
        #check ARP
        checkArpErr_MML "0"
        ;; 
        118)
        #check BMC״̬
        checkBMCstatus "0"
        ;; 
        119)
        #汾һ¼
        checkNodeVersion "0"
        ;;
        120)
        #è״̬
        checkModmemtatus "0"
        ;;    
        121)
        #ѯ豸ʱ
        checkNodeTime "0"
        ;; 
        122)
        #syslog״̬
        checkSysLog "0"
        ;;
        123)
        # diskpoolʹǷ
        checkDiskPoolUsage "0"
         ;;
        124)
        #DiskǷй
        checkDiskFailed "0"
        ;;
        125)
        #Check Memory Usage
        checkNodePhysicalMemEqually "0"
        ;;
        126)
        #鵱ǰʱԴǷȷ
        checkCurrentClockSource "0"
        ;;
        127)
        #豸ڵǷʱԴ쳣
        checkClockSourceRisk "0"
        ;;
        128)
        #PHY
        checkPhyStatus "0"
        ;;
        *)
        echo "No this type"
        ;;
    esac

    WRITE_XML_CMD_TAIL         
}
