#!/bin/bash
export G_SCRIPT_PATH=.
export G_CHECK_RESULT_FILE=t.xml
PROGRAM=`basename $0`

function usage()
{
cat << INPUT

    usage:           ${PROGRAM} <software|hardware> [taskid]
    exsample1:        ${PROGRAM} software
    exsample2:        ${PROGRAM} hardware 100
INPUT
}

#main

time=`date "+%Y%m%d%H%M%S"`
case $1 in
    software)
        . $G_SCRIPT_PATH/inspect_software.sh
        taskids=`cat inspect_software.sh |grep "2[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
        checkStatus=checkSoftwareStatus
        checklog=checkSoftware.log
        break
        ;;
    hardware)
        . $G_SCRIPT_PATH/inspect_hardware.sh
        taskids=`cat inspect_hardware.sh |grep "1[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
        checkStatus=checkHardwareStatus
        checklog=checkHardware$time.log
        break
        ;;
    *)
         usage
         exit 0
        ;;
esac
if [ "$2" == "" ];then 
    for taskid in $taskids
    do
        $checkStatus $taskid >$checklog
    done
else
    echo #########################################
    $checkStatus $2 >$checklog
fi
exit 0
