#!/bin/bash
MOUNT_PATH="/home/mountinfo.txt"

#ini_file
# share_dir_0=/nfs
# mnt_dir_0=/mnt/nfs
# mount_type_0=nfs
# mount_args_0=noatime,async,nodiratime,nordirplus,noacl,nocto,nfsvers=3,tcp,rw,hard,intr,timeo=600,retrans=2,wsize=1048576,rsize=1048576
# user_0=user
# pwd_0=passwd

function mount_nfs()
{
    server_ip=$1
    share_dir=$2
    MNTDIR=$3
    args=$4
    default_mount_args="noexec,nosuid"  # mount挂载时未加入安全选项，有提权等风险

    if [ ! -d $MNTDIR ]; then
        echo "Mount path $MNTDIR does not exist."
        exit 1
    fi

    umount $MNTDIR 2>/dev/null
    
    if [ "$args" = "" ]; then
        mount -t nfs -o ${default_mount_args} $server_ip:$share_dir $MNTDIR > /dev/null
    else
        mount -t nfs -o $args -o ${default_mount_args} $server_ip:$share_dir $MNTDIR > /dev/null
    fi      

    if [ $? -ne 0 ];then
        echo "mount $server_ip:$share_dir on $MNTDIR $args failed. No such share or address."
        exit 1
    else
        echo "success mount $server_ip:$share_dir on $MNTDIR $args"
    fi
}

function mount_cifs()
{
    server_ip=$1
    share_dir=$2
    MNTDIR=$3
    LOGIN_USER=$4
    password=$5
    default_mount_args="noexec,nosuid"  # mount挂载时未加入安全选项，有提权等风险

    umount $MNTDIR 2>/dev/null
    mount -t cifs -o username=$LOGIN_USER,password=${password} -o ${default_mount_args} //$server_ip$share_dir $MNTDIR > /dev/null
    if [ $? -ne 0 ];then
        echo "mount $server_ip:$share_dir on $MNTDIR failed. No such share or address."
        exit 1
    else
        echo "success mount $server_ip:$share_dir on $MNTDIR"
    fi
}

function mount_by_file()
{
    local i=0
    for((;;)); do
        server_ip=`grep "server_ip_${i}=" $MOUNT_PATH | awk -F= '{print $2}'`
        share_dir=`grep "share_dir_${i}=" $MOUNT_PATH | awk -F= '{print $2}'`
        mnt_dir=`grep "mnt_dir_${i}=" $MOUNT_PATH | awk -F= '{print $2}'`
        mount_type=`grep "mount_type_${i}=" $MOUNT_PATH | awk -F= '{print $2}'`
        mount_args=`grep "mount_args_${i}=" $MOUNT_PATH | awk -F"_${i}=" '{print $2}'`
        user=`grep "user_${i}=" $MOUNT_PATH | awk -F= '{print $2}'`
        pwd=`grep "pwd_${i}=" $MOUNT_PATH | awk -F= '{print $2}'`
        i=$(($i+1))
        if [ "$server_ip" = "" ]; then
            break
        fi
               
        if [ "$mount_type" = "nfs" ]; then
            mount_nfs $server_ip $share_dir $mnt_dir $mount_args 
        elif [ "$mount_type" = "cifs" ]; then
            mount_cifs $server_ip $share_dir $mnt_dir $user $pwd
        else
            echo "Invalid mount_type $mount_type"
        fi
    done
}

mount_by_file

function mount_share()
{
    default_mount_args="noexec,nosuid"  # mount挂载时未加入安全选项，有提权等风险
    
    if [ ! -f $MOUNT_PATH ];then
         echo "file $MOUNT_PATH is not exist."
         echo "isFirst=0" >> $MOUNT_PATH
         exit 1
    fi
    isFirst=`cat $MOUNT_PATH|grep isFirst|awk -F= '{for (i=2;i<NF;i++) {printf $i;printf "@";}printf $NF}'`
    echo "isFirst=$isFirst"
    # 第一次调用这个脚本
    if [ "$isFirst" == "0" ];then
    
        echo "Please input serverIP:"
        read -r server_ip
        echo "Please input sharePath:"
        read -r share_dir
        echo "Please input mountPath:"
        read -r MNTDIR
        echo "Please input shareType:(nfs or cifs)"
        read -r mount_type
    
        if [ ! -d $MNTDIR ]; then
            echo "Mount path is not exist."
            exit 1
        fi
        
        umount $MNTDIR
        if [ "$mount_type" == "nfs" ];then
            mount -t nfs -o ${default_mount_args} $server_ip:$share_dir $MNTDIR > /dev/null 2> /dev/null
            if [ $? -ne 0 ];then
                echo "mount $server_ip:$share_dir on $MNTDIR failed. No such share or address."
                exit 1
            else
                echo "success"
            fi
        elif [ "$mount_type" == "cifs" ];then 
            echo "Please input username:"
            read -r LOGIN_USER
            echo "Please input password:"
            read -s -r password
            mount -t cifs -o username=$LOGIN_USER,password=${password} -o ${default_mount_args} //$server_ip$share_dir $MNTDIR > /dev/null 2> /dev/null
            if [ $? -ne 0 ];then
                echo "mount $server_ip:$share_dir on $MNTDIR failed. No such share or address."
                exit 1
            else
                echo "success"
            fi

        fi
        # 用户输入记录文件
        echo "server_ip=$server_ip" > $MOUNT_PATH
        echo "share_dir=$share_dir" >> $MOUNT_PATH
        echo "MNTDIR=$MNTDIR" >> $MOUNT_PATH
        echo "mount_type=$mount_type" >> $MOUNT_PATH
        echo "LOGIN_USER=$LOGIN_USER" >> $MOUNT_PATH
        isFirst=1
        echo "isFirst=$isFirst" >> $MOUNT_PATH
    else
        # 之前有mount过，从文件中读配置然后执行mount
        server_ip=`cat $MOUNT_PATH|grep server_ip|awk -F= '{for (i=2;i<NF;i++) {printf $i;printf "@";}printf $NF}'`
        share_dir=`cat $MOUNT_PATH|grep share_dir|awk -F= '{for (i=2;i<NF;i++) {printf $i;printf "@";}printf $NF}'`
        MNTDIR=`cat $MOUNT_PATH|grep MNTDIR|awk -F= '{for (i=2;i<NF;i++) {printf $i;printf "@";}printf $NF}'`
        mount_type=`cat $MOUNT_PATH|grep mount_type|awk -F= '{for (i=2;i<NF;i++) {printf $i;printf "@";}printf $NF}'`
            umount $MNTDIR
            if [ "$mount_type" == "nfs" ];then
            mount -t nfs -o ${default_mount_args} $server_ip:$share_dir $MNTDIR > /dev/null 2> /dev/null
            if [ $? -ne 0 ];then
                echo "mount $server_ip:$share_dir on $MNTDIR failed. No such share or address."
                exit 1
            else
                echo "success"
            fi
        elif [ "$mount_type" == "cifs" ];then 
            LOGIN_USER=`cat $MOUNT_PATH|grep LOGIN_USER|awk -F= '{for (i=2;i<NF;i++) {printf $i;printf "@";}printf $NF}'`
            echo "Please input password:"
            read -s -r password
            mount -t cifs -o username=$LOGIN_USER,password=${password} -o ${default_mount_args} //$server_ip$share_dir $MNTDIR > /dev/null 2> /dev/null
            if [ $? -ne 0 ];then
                echo "mount $server_ip:$share_dir on $MNTDIR failed. No such share or address."
                exit 1
            else
                echo "success"
            fi

        fi
    
    fi
}
