
#!/bin/bash

# *************************************************************************** #
# File Name: inspect_expand.sh
# Description: ѲĿеչ.
# Input:
# Output:
# Author:
# Created:
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile"
G_REMOTE_TMP_FILE="/tmp/tmpfile"

VALID_IP_FILE="/tmp/tmp_valid_ip"

IP_ROLE_FILE="/tmp/tmp_ip_role"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"

EXPAND_CONFIG_FILE="$G_SCRIPT_PATH/expand_config.conf"
PACKAGE_VERSION_FILE="/opt/huawei/deploy/package/version"
LOG_FILE="/var/log/inspect.log"

RepeatTimes=(1 2 3)

G_SEPARATOR="#############################################################################"

function LOG_Check
{
    #create or change log file
    touch $LOG_FILE
    if [ $? -ne 0 ]; then
        echo "Create log file $LOG_FILE failed." 1>&2
        return
    fi

    # delete log file bigger than 10M
    FILE_SIZE=`ls -l $LOG_FILE | cut -d' ' -f 5`
    if [ ! -z "$FILE_SIZE" ]; then
        # delete file when file bigger than 10M
        if [ $FILE_SIZE -gt 10485760 ]; then
            rm -rf $LOG_FILE
        fi
    fi

}

function LOG
{
    echo [`date`][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ȡڵһIP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'`
    if [ "$subnet_id" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet"
        return 1
    fi

    set_ifs
    for line in $subnet_id; do
        break
    done
    restore_ifs

    local IPAddress=`grep ipaddr_${line} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet IP"
        return 1
    fi

    echo $IPAddress
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 group by NID"
    if [ $? -ne 0 ]; then
        sleep 1
        sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 group by NID"
        if [ $? -ne 0 ]; then
            LOG "[$FUNCNAME]Failed to get back subnet IP of $nid from db"
        fi
    fi
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid=$2
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid=$2
    local err_info=$3
    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done

    LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,progress:$proresult"
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.process(null), ip not accessed"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME] exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command."
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        local iRet=$?
        LOG "[$FUNCNAME] download $remote_file from $remote_ip return:$iRet time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi
    return $iRet
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#нڵĺIP
function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0

    > $IP_ROLE_FILE
    #ݿȡнڵĺIP
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`

        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        if [ "$localNID" == "$lastNID" ];then
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))

            continue
        fi

        #pingһ¼Ƿͨ
        for time in ${RepeatTimes[*]};do
            tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done

        #
        numCnt=$((numCnt+1))
        lastNID=$localNID

        if [ "$tempStr_ping" -le 0 ];then

            LOG "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"

            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`

            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                for time in ${RepeatTimes[*]};do
                    tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                    local iRet=$?
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done

                LOG "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"

                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    LOG "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi

        #жϽڵǷúͶ
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then
            Status_values=`echo $Status_info | awk -F= '{print $2}'`
            Status_value=`echo $Status_values | awk '{print $1}'`
            if [ "$Status_value" == "0" ];then
                echo -n "$ItemIp " >> $IP_ROLE_FILE
                LOG "[$FUNCNAME]add $ItemIp"
            fi
        fi

    done

}

##############################################################################
# ڴչѲ
#ӶѲȥ˺ֻ֤׮
#105
checkFanStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    LOG "[$FUNCNAME][$LINENO] Test ExpandItem FanStatus"
    local isPass=0
    local Result=""

    Result="checkFanStatus_MML is supported expand"
    if [ "$Result" != "" ];then
        WRITE_XML_COMMON 0 "${Result}"
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#199. ӲѲ
customizableHardware()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0

    LOG "[$FUNCNAME][$LINENO]start!"

    WRITE_XML_COMMON 0 "Customizable check item is ok."

    LOG "[$FUNCNAME][$LINENO]finish! errResult=$errResult"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#299. Ѳ
customizableSoftware()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0

    LOG "[$FUNCNAME][$LINENO]start!"

    WRITE_XML_COMMON 0 "Customizable check item is ok."

    LOG "[$FUNCNAME][$LINENO]finish! errResult=$errResult"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

function getItemArrayIndex()
{
    rec=$1

    local index=0

    for item in ${checkItemArray[@]}
    do
        if [ "$rec" = "$item" ]; then
            break
        else
            index=$((index+1))
        fi
    done

    return $index
}

function isExpandSupported()
{
    checkItem=$1

    #жչѲ麯Ƿִ֧Ѳ
    taskid=`cat $G_SCRIPT_PATH/inspect_expand.sh |grep "$checkItem)"|awk -F\) '{print $1}'|tr -d " "`
    if [ "$taskid" != "$checkItem" ]; then
        LOG "[$FUNCNAME][$LINENO]checkid($checkItem) is not supported in checkExpandItemStatus!"
        return 1
    fi

    #չѲİ汾ļǷִ֧Ѳ
    productVersionInfo=`cat $PACKAGE_VERSION_FILE | grep "ProductVersion="`
    productVersionValue=$(echo $productVersionInfo | awk -F '=' '{printf $2}')
    LOG "[$FUNCNAME][$LINENO]ProductVersion=$productVersionValue"

    checkItemInfo=`cat $EXPAND_CONFIG_FILE | grep "ProductVer"`
    if [ "$checkItemInfo" = "" ]; then
        LOG "[$FUNCNAME][$LINENO]file $EXPAND_CONFIG_FILE error!"
        return 1
    fi

    checkItemArray=($checkItemInfo)
    getItemArrayIndex $checkItem
    itemIndex=$?

    checkItemValueInfo=`cat $EXPAND_CONFIG_FILE | grep "$productVersionValue"`
    if [ "$checkItemValueInfo" = "" ]; then
        LOG "[$FUNCNAME][$LINENO]not support $productVersionValue in $EXPAND_CONFIG_FILE"
        return 1
    fi

    LOG "[$FUNCNAME][$LINENO]support $productVersionValue in $EXPAND_CONFIG_FILE"
    checkItemValueArray=($checkItemValueInfo)
    if [ "1" != "${checkItemValueArray[$itemIndex]}" ]; then
        LOG "[$FUNCNAME][$LINENO]checkId($checkItem) is not supported in $EXPAND_CONFIG_FILE,$productVersionValue"
        return 1
    fi

    LOG "[$FUNCNAME][$LINENO]checkId($checkItem) is supported in $EXPAND_CONFIG_FILE,$productVersionValue"

    return 0
}

# **************************************************************************** #
# Function Name: checkExpandItemStatus
# Description: չѲ м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkExpandItemStatus()
{
    LOG_Check

    WRITE_XML_CMD_HEADER $1
    GetIPAndRoleFromDB

    rm -rf /opt/inspect/tmpfile*

    LOG "[$FUNCNAME] param = ($1)"
    case $1 in
        199)
        #Ѳɶƹܲ׮
        customizableHardware "0"
        ;;
        299)
        #Ѳ
        customizableSoftware "0"
        ;;
        *)
        #չѲвʱ, ع̶, ӲѲѲ
        return 555
        ;;
    esac
    chmod 640 $LOG_FILE
    WRITE_XML_CMD_TAIL
}

