# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 关于存储产品控制器间通信计数翻转导致控制器复位
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""
    
    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3', '6900 V3']
    bugVersionList = ['V300R001C00', 'V300R001C10']

    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)
            
        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])
        
        #检查当前软件版本是否在属于风险版本
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if result == True:
            #获取当前环境soft version
            SoftVersionDict = currentVersionDictList[0]
            softCurrentVersion = SoftVersionDict.get("Current Version")
            sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
            return (flag, cliRet, common.getMsg(LANG, "current.version", sotfStandardVersion))
        
        flag = True
        LOGGER.logPass()
        
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
    