# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 存储产品硬盘后台扫描时引用计数翻转导致控制器复位
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""
    
    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionList = ['V200R002C00','V200R002C00SPC100','V200R002C00SPC200','V200R002C00SPC300','V200R002C00SPC400','V200R002C10','V200R002C20','V200R002C20SPC200']
        #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)
            
        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])
        
        #检查当前软件版本是否在属于风险版本
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if result != True:
            flag = True
            return (flag, cliRet, errMsg)
        
        #获取当前环境soft version
        SoftVersionDict = currentVersionDictList[0]
        softCurrentVersion = SoftVersionDict.get("Current Version")
        sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
        errMsg = common.getMsg(LANG, "current.version", sotfStandardVersion)
        
        #查看后台扫描是否开启
        result = checkMediaScan(cli)
        cliRet += '\n' + result[1]
        
        if result[0] != True:
            flag = True
            return (flag, cliRet,errMsg)
        
        errMsg += common.getMsg(LANG, "open.media.scan")

        #查看当前版本是否为V200R002C00SPC400，且是否打了V200R002C20SPC200及之后的补丁&&查看当前版本是否为V200R002C20SPC200，且是否打了V200R002C20SPH202及之后的补丁		
        hotPatchDict = {"V200R002C00SPC400":"V200R002C00SPH403","V200R002C20SPC200":"V200R002C20SPH202"}
        
        if sotfStandardVersion in hotPatchDict:
            #预设每个控制器的补丁都是ok的
            flag = True

            #循环获取每个控制器的补丁信息
            for hotPatchVersion in hotPatchVersionList:
                hotPatchCurrentVersion = hotPatchVersion.get("Current Version")
                contrllerID = hotPatchVersion.get("Name")

                if hotPatchCurrentVersion == "--" or hotPatchCurrentVersion == "":
                    errMsg += common.getMsg(LANG, "contrller.not.install.pacth", contrllerID)
                    flag = False
                elif hotPatchCurrentVersion >= hotPatchDict[sotfStandardVersion]:
                    continue
                else:
                    errMsg += common.getMsg(LANG, "contrller.pacth.too.low", (contrllerID, hotPatchCurrentVersion, hotPatchDict[sotfStandardVersion]))
                    flag = False
    
        return(flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
def checkMediaScan(cli):
    '''
    @summary: 查看后台扫描策略是否开启
    @param cli: CLI链接
    @return: 
        True/False:开启 /关闭
        cliRet：命令回显
    '''
    cmd = "show system media_scan"
    key = "Execute Status"
    value = "Start"
    flag = False
    try:
        cliRet = cli.execCmd(cmd)
        
        for line in cliRet.splitlines():
            if len(line.split(':')) < 2:
                continue
            if line.split(':')[0].strip() == key and line.split(':')[1].strip() == value:
                flag = True
                return(flag, cliRet)
        
        return(flag, cliRet)
                     
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))


    