# -*- coding: UTF-8 -*-
import cliUtil
import common
from macpath import split

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
paswd = py_java_env.get("devPwd").get("developer")

def execute(cli):
    '''
    @summary: 存储产品主控制器恢复上电失败问题
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""
    
    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionList = ['V200R002C00', 'V200R002C00SPC100', 'V200R002C00SPC200', 'V200R002C00SPC300', 'V200R002C00SPC400', 'V200R002C10', 'V200R002C20', 'V200R002C20SPC100', 'V200R002C20SPC200']

    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)
        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet, checkRet[2])
        
        #检查当前软件版本是否在属于风险版本
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if result == False:
            flag = True
            return (flag, cliRet, errMsg)
        
        #获取当前环境soft version
        SoftVersionDict = currentVersionDictList[0]
        softCurrentVersion = SoftVersionDict.get("Current Version")
        sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
        errMsg = common.getMsg(LANG, "current.version", sotfStandardVersion)
        
        #查看当前版本是否为V200R002C00SPC400，且是否打了V200R002C00SPH403及之后的补丁
        softVersion = 'V200R002C00SPC400'
        patchVersion = 'V200R002C00SPH403'
        
        if sotfStandardVersion == softVersion:
            #预设每个控制器的补丁都是ok的
            flag = True
            
            #循环获取每个控制器的补丁信息
            for hotPatchVersion in hotPatchVersionList:
                hotPatchCurrentVersion = hotPatchVersion.get("Current Version")
                contrllerID = hotPatchVersion.get("Name")
                
                if hotPatchCurrentVersion == "--" or hotPatchCurrentVersion == "":
                    errMsg += common.getMsg(LANG, "contrller.not.install.pacth", contrllerID)
                    flag = False
                elif hotPatchCurrentVersion >= patchVersion:
                    continue
                else:
                    errMsg += common.getMsg(LANG, "contrller.pacth.too.low", (contrllerID, hotPatchCurrentVersion, patchVersion))
                    flag = False
            if flag:
                return(flag, cliRet, errMsg)
        #若当前版本是风险版本,则进一步查询位图信息
        cmd = "ld show var"
        result = cliUtil.excuteCmdInDiagnoseMode(cli, cmd, True, LANG, LOGGER, paswd)
        cliRet += '\n' + result[1]
        if result[0] != True:
            errMsg = result[2]
            return (result[0], cliRet, errMsg)
        
        #查看当前位图信息是否一致
        Disk_Over_Nid = "Disk Over Nid"
        Online_Node_Bitmap = "Online Node Bitmap"
        Disk_Over_Nid_value = ""
        Online_Node_Bitmap_value = ""
        
        ldShowVarinfo = result[1].splitlines()
        for line in ldShowVarinfo:
            if len(line.split(':')) < 2:
                continue
            if line.split(':')[0].strip() == Disk_Over_Nid:
                Disk_Over_Nid_value = line.split(':')[1].strip()
            if line.split(':')[0].strip() == Online_Node_Bitmap:
                Online_Node_Bitmap_value = line.split(':')[1].strip()
            if Disk_Over_Nid_value != "" and Online_Node_Bitmap_value != "":
                break
        
        if not Disk_Over_Nid_value or not Online_Node_Bitmap_value:
            return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
        
        if Disk_Over_Nid_value != Online_Node_Bitmap_value:
            errMsg += common.getMsg(LANG, "Disk.Over.Nid.not.equal.Online.Node.Bitmap")
            return (flag, cliRet, errMsg)
        else:
            flag = True
            errMsg = ""
            return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
    