# -*- coding: UTF-8 -*-
import cliUtil
import common
from macpath import split

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

MAST_CONFIGURATION_CAPACITY = 1024 #允许配置的最大容量

def execute(cli):
    '''
    @summary: 存储产品Thin LUN空间回收耗时过长导致业务中断
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""
    
    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3', '6900 V3']
    bugVersionList = ['V300R001C00', 'V300R001C10', 'V300R001C10SPC100', 'V300R002C00']

    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)
            
        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])
        
        #检查当前软件版本是否在属于风险版本
        result = common.checkRiskVersion(currentVersionDictList, bugVersionList, LANG)
        if result == False:
            flag = True
            return (flag, cliRet, errMsg)
        
        #获取当前环境soft version
        SoftVersionDict = currentVersionDictList[0]
        softCurrentVersion = SoftVersionDict.get("Current Version")
        sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
        errMsg = common.getMsg(LANG, "current.version", sotfStandardVersion)
        
        #查询thin LUN ID列表
        result = common.getThinLUNIDList(cli, LANG)
        cliRet += '\n' + result[1]
        thinLunIdList = result[0]
    
        #遍历所有的thin lun
        hasGreaterThanOneTB = False
        for thinLunId in thinLunIdList:
            result = getSubscribedCapacityValue(cli, LANG, thinLunId)
            cliRet += '\n' + result[1]
            if result[0] == False:
                return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
            
            #判断容量是否大于1TB
            SubscribedCapacityValue = result[2]
            result = common.changeUnit2GB(SubscribedCapacityValue)
            if result[0] == False:
                errMsg = common.getMsg(LANG, "change.unit.failed")
                return(flag, cliRet, errMsg)
            
            SubscribedCapacityNum = result[1]
            if SubscribedCapacityNum > MAST_CONFIGURATION_CAPACITY:
                errMsg += common.getMsg(LANG, "Subscribed.Capacity.greater.than.1TB", (thinLunId, SubscribedCapacityValue))
                hasGreaterThanOneTB = True
        
        if hasGreaterThanOneTB == True:
            return(flag, cliRet, errMsg)
        
        flag = True
        errMsg = ""
        return(flag, cliRet, errMsg)
                
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
    
def getSubscribedCapacityValue(cli, lang, thinLunId):
    '''
    @summary: 获取Subscribed Capacity值
    @param
        cli:CLI
        lang:语言
        thinLunId:thin LUN ID
    @return: 
        flag:True/False 获取成功/失败
        cliRet:命令回文
        SubscribedCapacityValue:Subscribed Capacity字符串形式的值
        errMsg:错误信息
    '''    
    cliRet = ""
    errMsg = ""
    SubscribedCapacity = "Subscribed Capacity"
    SubscribedCapacityValue = ""
    
    try:
        cmd = "show lun general lun_id=" + thinLunId
        cmdRet =  cli.execCmd(cmd)
        cliRet += cmdRet
        thinLUNInfo = cmdRet.splitlines()
       
        #获取两个关键字的字符串值
        for line in thinLUNInfo:
            if len(line.split(':')) < 2:
                continue
            if line.split(':')[0].strip() == SubscribedCapacity:
                SubscribedCapacityValue = line.split(':')[1].strip()
                return(True, cliRet, SubscribedCapacityValue, errMsg)
        
        if SubscribedCapacityValue == "":
            return(False, cliRet, SubscribedCapacityValue, common.getMsg(LANG, "query.result.abnormal"))
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, SubscribedCapacityValue, common.getMsg(LANG, "query.result.abnormal"))
    
    
    
    