# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import re
from com.huawei.ism.tool.obase.exception import ToolException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
            检查方法    
            步骤1 使用admin账户登录设备；
            步骤2 执行命令：show upgrade package查询系统版本及热补丁版本信息。
            
            检查标准    
    1、若系统版本小于V300R001C21SPC100，则检查不通过；
    2、若系统版本为V300R001C21SPC100，且补丁版本小于V300R001C21SPH109，则检查不通过，否则检查通过；
    3、若系统版本为V300R001C30SPC100，且补丁版本小于V300R001C30SPH103，则检查不通过，否则检查通过；
    4、若系统版本为其他版本，则检查通过。
    
            修复建议    
    1、若检查不通过，请参考CIT-P-S-201911预警公告；
    2、如果有任何疑问，请联系技术工程师协助解决。
    '''
    bugModel2VersionsDict = {"Dorado5000 V3": ["V300R001C01SPC100", "V300R001C21SPC100", "V300R001C30SPC100"],
                             "Dorado6000 V3": ["V300R001C00SPC100", "V300R001C01SPC100", "V300R001C21SPC100", "V300R001C30SPC100"], }
    bugProVer2PatchVer = {"V300R001C21SPC100" : "V300R001C21SPH109",
                          "V300R001C30SPC100" : "V300R001C30SPH103", }
    reg_hotPatchVersion = re.compile("V\d{3}R\d{3}C\d{2}SPH\d{3}$")
    #返回值定义
    allCliRet = ""
    errMsg = ""
    try:
        #获取设备型号
        productModel = str(common.getProductModeFromContext(py_java_env))
        LOGGER.logInfo("Get product model from context:[%s]" % productModel)
        #获取设备当前产品版本
        checkRet, curProductVersionDictList, curHotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        allCliRet = common.joinLines(allCliRet, checkRet[1])
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, allCliRet , checkRet[2])
        result, curProductVersion, errMsg = common.getCurrentVersion(curProductVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        result, curHotPatchVersion, errMsg = common.getCurrentVersion(curHotPatchVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        LOGGER.logInfo("Get product version :[%s] and hot patch version[%s]" % (curProductVersion, curHotPatchVersion))
        
        bugProVersionList = bugModel2VersionsDict.get(productModel)
        if not bugProVersionList:
            return (True, allCliRet, "")
        if curProductVersion in bugProVersionList:
            bugPatchVer = bugProVer2PatchVer.get(curProductVersion)
            if bugPatchVer and reg_hotPatchVersion.match(curHotPatchVersion) and \
            curHotPatchVersion >= bugPatchVer:
                return (True, allCliRet, "")
            else:
                errMsg = common.getMsg(LANG, "check.no.pass.model.version.hot.patch", \
                                       (productModel, curProductVersion, curHotPatchVersion))
                return (False, allCliRet, errMsg)
        return (True, allCliRet, "")
    
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

