# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
    @summary: 【CIT-R-S-201830】关于存储产品日立He10硬盘闪断问题的整改通知
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''
    
    #返回值定义
    flag = False
    allCliRetList = []
    errMsg = ""
    
    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['2200 V3', '2600 V3', '2800 V3', '5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3', '18500 V3', '18800 V3', '2200 V5', '2600 V5', '2800 V5', '5300 V5', '5500 V5', '5600 V5', '5800 V5', '6800 V5', '18500 V5', '18800 V5']

    #判断当前系统型号和版本是否存在风险
    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)
        
        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, "\n".join(allCliRetList), errMsg)
        
        flag, riskDiskList, cliRet, errMsg = getRiskDiskList(cli, LANG)
        allCliRetList.append(cliRet)
        if flag != True:
            return flag, "\n".join(allCliRetList), errMsg
        
        if riskDiskList:
            return False, "\n".join(allCliRetList), common.getMsg(LANG, "current.version.exists.risk.he10", ",".join(riskDiskList))
        
        return(True, "\n".join(allCliRetList), '')
                
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
    
def getRiskDiskList(cli, LANG):
    riskDiskList = [] 
    cliRet = ''
    try:
        cmd = "show disk general |filterColumn include columnList=ID,Manufacturer,Model,Firmware\sVersion"
        cliRet =  cli.execCmd(cmd)
        retDictList = cliUtil.getHorizontalCliRet(cliRet)
        for retDict in retDictList:
            diskId = retDict.get("ID", '')
            fw = retDict.get("Firmware Version", '')
            model = retDict.get("Model", '')
            if (model == 'HUH721008AL4200' or model == 'HUH721010AL4200') and fw == 'A3R0':
                riskDiskList.append(diskId)
        return True, list(set(riskDiskList)), cliRet, ''
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, list(set(riskDiskList)), cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
    
    