# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import traceback
from com.huawei.ism.tool.obase.exception import ToolException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
allCliRet = ""

def execute(cli):
    '''
            检查方法    
            步骤1 以admin用户登录设备;
            步骤2 执行命令：show system general查询产品型号;
            步骤3 执行命令：show upgrade package查询系统软件版本和系统补丁版本。
            
            检查标准    
    1. 若产品为V3系列，且版本小于V300R006C20，则检查不通过，否则检查通过；
    2. 若产品为V5系列，且版本小于V500R007C10，则检查不通过，否则检查通过；
    3. 若产品为Dorado V3系列，且版本小于V300R001C21SPC100，则检查不通过，否则检查通过。
    
            修复建议    
    1 若检查不通过，请参考CIT-R-S-201919预警公告；
    2 如果有任何疑问，请联系技术工程师协助解决。
    '''
    global allCliRet
    errMsg = ""
    referenceVersion = ""
    
    try:
        #获取设备型号和SN
        result, productModel, devSN, errMsg = getModelAndSN(cli)
        if result != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        LOGGER.logInfo("Get product model [%s] and device SN [%s]" % (productModel, devSN))
        #获取设备当前产品版本
        checkRet, curProductVersionDictList, _ = common.parse_upgradePackage(cli, LANG)
        allCliRet = common.joinLines(allCliRet, checkRet[1])
        if checkRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet , checkRet[2])
        result, curProductVersion, errMsg = common.getCurrentVersion(curProductVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet , errMsg)
        LOGGER.logInfo("Get product version [%s]" % curProductVersion)
        
        if productModel in config.DORADO_DEVS:
            referenceVersion = "V300R001C21SPC100"
        elif curProductVersion.startswith("V3"):
            referenceVersion = "V300R006C20"
        elif curProductVersion.startswith("V5"):
            referenceVersion = "V500R007C10"
        else:
            return (True, allCliRet, "")
        LOGGER.logInfo("Get reference version is [%s]" % referenceVersion)
        if curProductVersion < referenceVersion and devSN in config.RECT_NOTICE_SOTRAGE_IN_2019_SN_LIST:
            errMsg = common.getMsg(LANG, "check.no.pass.model.version.SN", \
                                   (productModel, curProductVersion, devSN))
            return (False, allCliRet, errMsg)
        return (True, allCliRet, "")
            
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def getModelAndSN(cli):
    global allCliRet
    productModel = ""
    devSN = ""
    cmd = "show system general"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True: 
        return (False, productModel , devSN , errMsg)
    cliRetDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetDictList) == 0:
        return (False, productModel , devSN , common.getMsg("query.result.abnormal"))
    cliRetDict = cliRetDictList[0]
    productModel = cliRetDict.get("Product Model")
    devSN = cliRetDict.get("SN")
    if not productModel or not devSN:
        return (False, productModel , devSN , common.getMsg("query.result.abnormal"))
    return (True, productModel , devSN , "")
        

