# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 存储产品Bar Mitzvah Attack (RC4)安全漏洞
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""

    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']

    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)

        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)

        #查询当前产品软件版本号
        checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += '\n' + checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRet , checkRet[2])

        #获取当前环境soft version
        softVersionDict = currentVersionDictList[0]
        softCurrentVersion = softVersionDict.get("Current Version")
        sotfStandardVersion = common.switchValidVersion(softCurrentVersion)
        errMsg = common.getMsg(LANG, "current.version", sotfStandardVersion)
        targetVersion = 'V200R002C20SPC200'

        #检查当前软件版本是否属于V200R002C00版本或者属于V200R002C10版本
        if "V200R002C00" in sotfStandardVersion or "V200R002C10" in sotfStandardVersion:
            return (False, cliRet, errMsg)

        #检查当前软件版本是否为V200R002C20SPC200之前的所有V200R002C20版本
        if "V200R002C20" in sotfStandardVersion and sotfStandardVersion < targetVersion:
            return (False, cliRet, errMsg)

        return (True, cliRet, errMsg)
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
