# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 存储产品Bar Mitzvah Attack (RC4)安全漏洞
    @param cli: CLI连接
    @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
    '''

    #返回值定义
    flag = False
    cliRet = ""
    errMsg = ""

    #配置涉及该预警的产品型号和版本
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']

    try:
        #查询产品型号
        result, cliRet, productModel, errMsg = cliUtil.getProductModel(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)

        #判断当前产品型号是否是风险产品型号
        if productModel not in bugProductModelList:
            flag = cliUtil.RESULT_NOSUPPORT
            LOGGER.logPass()
            return (flag, cliRet, errMsg)

        #查询硬盘型号为ST33000650SS的列表
        cmd = "show disk general |filterRow column=Model predict=equal_to value=ST33000650SS"
        modelInfoEcho = cliUtil.excuteCmdInCliMode(cli,cmd,True,LANG)
        cliRet += modelInfoEcho[1]               
        
        if modelInfoEcho[0] != True:
            errMsg += modelInfoEcho[2]
            return (modelInfoEcho[0], cliRet, errMsg)
        
        modelInfoEchoDict = cliUtil.getHorizontalCliRet(modelInfoEcho[1])
        if modelInfoEchoDict == []:
            return(True, cliRet, errMsg)
        
        for diskInfo in modelInfoEchoDict:
            diskID = diskInfo.get("ID")
            flag = cliUtil.RESULT_WARNING
            errMsg += common.getMsg(LANG, "disk.model.err",(diskID,"ST33000650SS"))
        return(flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))










